/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination options for a flow log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationOptionsRequest.Builder, DestinationOptionsRequest> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FileFormat")
            .getter(getter(DestinationOptionsRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat")
                    .unmarshallLocationName("FileFormat").build()).build();

    private static final SdkField<Boolean> HIVE_COMPATIBLE_PARTITIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiveCompatiblePartitions")
            .getter(getter(DestinationOptionsRequest::hiveCompatiblePartitions))
            .setter(setter(Builder::hiveCompatiblePartitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiveCompatiblePartitions")
                    .unmarshallLocationName("HiveCompatiblePartitions").build()).build();

    private static final SdkField<Boolean> PER_HOUR_PARTITION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerHourPartition")
            .getter(getter(DestinationOptionsRequest::perHourPartition))
            .setter(setter(Builder::perHourPartition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerHourPartition")
                    .unmarshallLocationName("PerHourPartition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD,
            HIVE_COMPATIBLE_PARTITIONS_FIELD, PER_HOUR_PARTITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileFormat;

    private final Boolean hiveCompatiblePartitions;

    private final Boolean perHourPartition;

    private DestinationOptionsRequest(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.hiveCompatiblePartitions = builder.hiveCompatiblePartitions;
        this.perHourPartition = builder.perHourPartition;
    }

    /**
     * <p>
     * The format for the flow log. The default is <code>plain-text</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link DestinationFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format for the flow log. The default is <code>plain-text</code>.
     * @see DestinationFileFormat
     */
    public final DestinationFileFormat fileFormat() {
        return DestinationFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format for the flow log. The default is <code>plain-text</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link DestinationFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format for the flow log. The default is <code>plain-text</code>.
     * @see DestinationFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is
     * <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is
     *         <code>false</code>.
     */
    public final Boolean hiveCompatiblePartitions() {
        return hiveCompatiblePartitions;
    }

    /**
     * <p>
     * Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. The
     * default is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to partition the flow log per hour. This reduces the cost and response time for
     *         queries. The default is <code>false</code>.
     */
    public final Boolean perHourPartition() {
        return perHourPartition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hiveCompatiblePartitions());
        hashCode = 31 * hashCode + Objects.hashCode(perHourPartition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationOptionsRequest)) {
            return false;
        }
        DestinationOptionsRequest other = (DestinationOptionsRequest) obj;
        return Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(hiveCompatiblePartitions(), other.hiveCompatiblePartitions())
                && Objects.equals(perHourPartition(), other.perHourPartition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationOptionsRequest").add("FileFormat", fileFormatAsString())
                .add("HiveCompatiblePartitions", hiveCompatiblePartitions()).add("PerHourPartition", perHourPartition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "HiveCompatiblePartitions":
            return Optional.ofNullable(clazz.cast(hiveCompatiblePartitions()));
        case "PerHourPartition":
            return Optional.ofNullable(clazz.cast(perHourPartition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationOptionsRequest, T> g) {
        return obj -> g.apply((DestinationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationOptionsRequest> {
        /**
         * <p>
         * The format for the flow log. The default is <code>plain-text</code>.
         * </p>
         * 
         * @param fileFormat
         *        The format for the flow log. The default is <code>plain-text</code>.
         * @see DestinationFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format for the flow log. The default is <code>plain-text</code>.
         * </p>
         * 
         * @param fileFormat
         *        The format for the flow log. The default is <code>plain-text</code>.
         * @see DestinationFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationFileFormat
         */
        Builder fileFormat(DestinationFileFormat fileFormat);

        /**
         * <p>
         * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is
         * <code>false</code>.
         * </p>
         * 
         * @param hiveCompatiblePartitions
         *        Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiveCompatiblePartitions(Boolean hiveCompatiblePartitions);

        /**
         * <p>
         * Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries.
         * The default is <code>false</code>.
         * </p>
         * 
         * @param perHourPartition
         *        Indicates whether to partition the flow log per hour. This reduces the cost and response time for
         *        queries. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perHourPartition(Boolean perHourPartition);
    }

    static final class BuilderImpl implements Builder {
        private String fileFormat;

        private Boolean hiveCompatiblePartitions;

        private Boolean perHourPartition;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationOptionsRequest model) {
            fileFormat(model.fileFormat);
            hiveCompatiblePartitions(model.hiveCompatiblePartitions);
            perHourPartition(model.perHourPartition);
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(DestinationFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final Boolean getHiveCompatiblePartitions() {
            return hiveCompatiblePartitions;
        }

        public final void setHiveCompatiblePartitions(Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
        }

        @Override
        public final Builder hiveCompatiblePartitions(Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
            return this;
        }

        public final Boolean getPerHourPartition() {
            return perHourPartition;
        }

        public final void setPerHourPartition(Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
        }

        @Override
        public final Builder perHourPartition(Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
            return this;
        }

        @Override
        public DestinationOptionsRequest build() {
            return new DestinationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
