/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCoipPoolResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteCoipPoolResponse.Builder, DeleteCoipPoolResponse> {
    private static final SdkField<CoipPool> COIP_POOL_FIELD = SdkField
            .<CoipPool> builder(MarshallingType.SDK_POJO)
            .memberName("CoipPool")
            .getter(getter(DeleteCoipPoolResponse::coipPool))
            .setter(setter(Builder::coipPool))
            .constructor(CoipPool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPool")
                    .unmarshallLocationName("coipPool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOL_FIELD));

    private final CoipPool coipPool;

    private DeleteCoipPoolResponse(BuilderImpl builder) {
        super(builder);
        this.coipPool = builder.coipPool;
    }

    /**
     * <p>
     * Information about the CoIP address pool.
     * </p>
     * 
     * @return Information about the CoIP address pool.
     */
    public final CoipPool coipPool() {
        return coipPool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coipPool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCoipPoolResponse)) {
            return false;
        }
        DeleteCoipPoolResponse other = (DeleteCoipPoolResponse) obj;
        return Objects.equals(coipPool(), other.coipPool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCoipPoolResponse").add("CoipPool", coipPool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoipPool":
            return Optional.ofNullable(clazz.cast(coipPool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCoipPoolResponse, T> g) {
        return obj -> g.apply((DeleteCoipPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCoipPoolResponse> {
        /**
         * <p>
         * Information about the CoIP address pool.
         * </p>
         * 
         * @param coipPool
         *        Information about the CoIP address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPool(CoipPool coipPool);

        /**
         * <p>
         * Information about the CoIP address pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoipPool.Builder} avoiding the need to
         * create one manually via {@link CoipPool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoipPool.Builder#build()} is called immediately and its result is
         * passed to {@link #coipPool(CoipPool)}.
         * 
         * @param coipPool
         *        a consumer that will call methods on {@link CoipPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coipPool(CoipPool)
         */
        default Builder coipPool(Consumer<CoipPool.Builder> coipPool) {
            return coipPool(CoipPool.builder().applyMutation(coipPool).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CoipPool coipPool;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCoipPoolResponse model) {
            super(model);
            coipPool(model.coipPool);
        }

        public final CoipPool.Builder getCoipPool() {
            return coipPool != null ? coipPool.toBuilder() : null;
        }

        public final void setCoipPool(CoipPool.BuilderImpl coipPool) {
            this.coipPool = coipPool != null ? coipPool.build() : null;
        }

        @Override
        public final Builder coipPool(CoipPool coipPool) {
            this.coipPool = coipPool;
            return this;
        }

        @Override
        public DeleteCoipPoolResponse build() {
            return new DeleteCoipPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
