/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCapacityReservationFleetRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyCapacityReservationFleetRequest.Builder, ModifyCapacityReservationFleetRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationFleetId")
            .getter(getter(ModifyCapacityReservationFleetRequest::capacityReservationFleetId))
            .setter(setter(Builder::capacityReservationFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId")
                    .unmarshallLocationName("CapacityReservationFleetId").build()).build();

    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalTargetCapacity")
            .getter(getter(ModifyCapacityReservationFleetRequest::totalTargetCapacity))
            .setter(setter(Builder::totalTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity")
                    .unmarshallLocationName("TotalTargetCapacity").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(ModifyCapacityReservationFleetRequest::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("EndDate").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyCapacityReservationFleetRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<Boolean> REMOVE_END_DATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveEndDate")
            .getter(getter(ModifyCapacityReservationFleetRequest::removeEndDate))
            .setter(setter(Builder::removeEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEndDate")
                    .unmarshallLocationName("RemoveEndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_FLEET_ID_FIELD, TOTAL_TARGET_CAPACITY_FIELD, END_DATE_FIELD, DRY_RUN_FIELD,
            REMOVE_END_DATE_FIELD));

    private final String capacityReservationFleetId;

    private final Integer totalTargetCapacity;

    private final Instant endDate;

    private final Boolean dryRun;

    private final Boolean removeEndDate;

    private ModifyCapacityReservationFleetRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.endDate = builder.endDate;
        this.dryRun = builder.dryRun;
        this.removeEndDate = builder.removeEndDate;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation Fleet to modify.
     * </p>
     * 
     * @return The ID of the Capacity Reservation Fleet to modify.
     */
    public final String capacityReservationFleetId() {
        return capacityReservationFleetId;
    }

    /**
     * <p>
     * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with
     * the instance type weights that you assign to each instance type used by the Fleet determine the number of
     * instances for which the Fleet reserves capacity. Both values are based on units that make sense for your
     * workload. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
     * capacity</a> in the Amazon EC2 User Guide.
     * </p>
     * 
     * @return The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together
     *         with the instance type weights that you assign to each instance type used by the Fleet determine the
     *         number of instances for which the Fleet reserves capacity. Both values are based on units that make sense
     *         for your workload. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
     *         target capacity</a> in the Amazon EC2 User Guide.
     */
    public final Integer totalTargetCapacity() {
        return totalTargetCapacity;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires,
     * its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
     * </p>
     * <p>
     * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify
     * <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between
     * <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>.
     * </p>
     * <p>
     * You can't specify <b>EndDate</b> and <b> RemoveEndDate</b> in the same request.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet
     *         expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet
     *         expire.</p>
     *         <p>
     *         The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
     *         specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to
     *         expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>.
     *         </p>
     *         <p>
     *         You can't specify <b>EndDate</b> and <b> RemoveEndDate</b> in the same request.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the end date, the
     * Capacity Reservation Fleet does not expire and it remains active until you explicitly cancel it using the
     * <b>CancelCapacityReservationFleet</b> action.
     * </p>
     * <p>
     * You can't specify <b>RemoveEndDate</b> and <b> EndDate</b> in the same request.
     * </p>
     * 
     * @return Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the end date,
     *         the Capacity Reservation Fleet does not expire and it remains active until you explicitly cancel it using
     *         the <b>CancelCapacityReservationFleet</b> action.</p>
     *         <p>
     *         You can't specify <b>RemoveEndDate</b> and <b> EndDate</b> in the same request.
     */
    public final Boolean removeEndDate() {
        return removeEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(removeEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationFleetRequest)) {
            return false;
        }
        ModifyCapacityReservationFleetRequest other = (ModifyCapacityReservationFleetRequest) obj;
        return Objects.equals(capacityReservationFleetId(), other.capacityReservationFleetId())
                && Objects.equals(totalTargetCapacity(), other.totalTargetCapacity())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(removeEndDate(), other.removeEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCapacityReservationFleetRequest")
                .add("CapacityReservationFleetId", capacityReservationFleetId())
                .add("TotalTargetCapacity", totalTargetCapacity()).add("EndDate", endDate()).add("DryRun", dryRun())
                .add("RemoveEndDate", removeEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationFleetId":
            return Optional.ofNullable(clazz.cast(capacityReservationFleetId()));
        case "TotalTargetCapacity":
            return Optional.ofNullable(clazz.cast(totalTargetCapacity()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "RemoveEndDate":
            return Optional.ofNullable(clazz.cast(removeEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationFleetRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCapacityReservationFleetRequest> {
        /**
         * <p>
         * The ID of the Capacity Reservation Fleet to modify.
         * </p>
         * 
         * @param capacityReservationFleetId
         *        The ID of the Capacity Reservation Fleet to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationFleetId(String capacityReservationFleetId);

        /**
         * <p>
         * The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together
         * with the instance type weights that you assign to each instance type used by the Fleet determine the number
         * of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your
         * workload. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
         * capacity</a> in the Amazon EC2 User Guide.
         * </p>
         * 
         * @param totalTargetCapacity
         *        The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value,
         *        together with the instance type weights that you assign to each instance type used by the Fleet
         *        determine the number of instances for which the Fleet reserves capacity. Both values are based on
         *        units that make sense for your workload. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
         *        target capacity</a> in the Amazon EC2 User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTargetCapacity(Integer totalTargetCapacity);

        /**
         * <p>
         * The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet
         * expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.
         * </p>
         * <p>
         * The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify
         * <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between
         * <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>.
         * </p>
         * <p>
         * You can't specify <b>EndDate</b> and <b> RemoveEndDate</b> in the same request.
         * </p>
         * 
         * @param endDate
         *        The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet
         *        expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet
         *        expire.</p>
         *        <p>
         *        The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you
         *        specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to
         *        expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>.
         *        </p>
         *        <p>
         *        You can't specify <b>EndDate</b> and <b> RemoveEndDate</b> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the end date, the
         * Capacity Reservation Fleet does not expire and it remains active until you explicitly cancel it using the
         * <b>CancelCapacityReservationFleet</b> action.
         * </p>
         * <p>
         * You can't specify <b>RemoveEndDate</b> and <b> EndDate</b> in the same request.
         * </p>
         * 
         * @param removeEndDate
         *        Indicates whether to remove the end date from the Capacity Reservation Fleet. If you remove the end
         *        date, the Capacity Reservation Fleet does not expire and it remains active until you explicitly cancel
         *        it using the <b>CancelCapacityReservationFleet</b> action.</p>
         *        <p>
         *        You can't specify <b>RemoveEndDate</b> and <b> EndDate</b> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEndDate(Boolean removeEndDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String capacityReservationFleetId;

        private Integer totalTargetCapacity;

        private Instant endDate;

        private Boolean dryRun;

        private Boolean removeEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationFleetRequest model) {
            super(model);
            capacityReservationFleetId(model.capacityReservationFleetId);
            totalTargetCapacity(model.totalTargetCapacity);
            endDate(model.endDate);
            dryRun(model.dryRun);
            removeEndDate(model.removeEndDate);
        }

        public final String getCapacityReservationFleetId() {
            return capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final Integer getTotalTargetCapacity() {
            return totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getRemoveEndDate() {
            return removeEndDate;
        }

        public final void setRemoveEndDate(Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
        }

        @Override
        public final Builder removeEndDate(Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationFleetRequest build() {
            return new ModifyCapacityReservationFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
