/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkAclsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeNetworkAclsResponse.Builder, DescribeNetworkAclsResponse> {
    private static final SdkField<List<NetworkAcl>> NETWORK_ACLS_FIELD = SdkField
            .<List<NetworkAcl>> builder(MarshallingType.LIST)
            .memberName("NetworkAcls")
            .getter(getter(DescribeNetworkAclsResponse::networkAcls))
            .setter(setter(Builder::networkAcls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclSet")
                    .unmarshallLocationName("networkAclSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkAcl> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkAcl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeNetworkAclsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ACLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NetworkAcl> networkAcls;

    private final String nextToken;

    private DescribeNetworkAclsResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcls = builder.networkAcls;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkAcls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkAcls() {
        return networkAcls != null && !(networkAcls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more network ACLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkAcls} method.
     * </p>
     * 
     * @return Information about one or more network ACLs.
     */
    public final List<NetworkAcl> networkAcls() {
        return networkAcls;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkAcls() ? networkAcls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsResponse)) {
            return false;
        }
        DescribeNetworkAclsResponse other = (DescribeNetworkAclsResponse) obj;
        return hasNetworkAcls() == other.hasNetworkAcls() && Objects.equals(networkAcls(), other.networkAcls())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNetworkAclsResponse").add("NetworkAcls", hasNetworkAcls() ? networkAcls() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAcls":
            return Optional.ofNullable(clazz.cast(networkAcls()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkAclsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkAclsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNetworkAclsResponse> {
        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(Collection<NetworkAcl> networkAcls);

        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * 
         * @param networkAcls
         *        Information about one or more network ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAcls(NetworkAcl... networkAcls);

        /**
         * <p>
         * Information about one or more network ACLs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.NetworkAcl.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.NetworkAcl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.NetworkAcl.Builder#build()} is called immediately and its
         * result is passed to {@link #networkAcls(List<NetworkAcl>)}.
         * 
         * @param networkAcls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.NetworkAcl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAcls(java.util.Collection<NetworkAcl>)
         */
        Builder networkAcls(Consumer<NetworkAcl.Builder>... networkAcls);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<NetworkAcl> networkAcls = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsResponse model) {
            super(model);
            networkAcls(model.networkAcls);
            nextToken(model.nextToken);
        }

        public final List<NetworkAcl.Builder> getNetworkAcls() {
            List<NetworkAcl.Builder> result = NetworkAclListCopier.copyToBuilder(this.networkAcls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkAcls(Collection<NetworkAcl.BuilderImpl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copyFromBuilder(networkAcls);
        }

        @Override
        public final Builder networkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(NetworkAcl... networkAcls) {
            networkAcls(Arrays.asList(networkAcls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(Consumer<NetworkAcl.Builder>... networkAcls) {
            networkAcls(Stream.of(networkAcls).map(c -> NetworkAcl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeNetworkAclsResponse build() {
            return new DescribeNetworkAclsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
