/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVerifiedAccessGroupRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteVerifiedAccessGroupRequest.Builder, DeleteVerifiedAccessGroupRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessGroupId")
            .getter(getter(DeleteVerifiedAccessGroupRequest::verifiedAccessGroupId))
            .setter(setter(Builder::verifiedAccessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId")
                    .unmarshallLocationName("VerifiedAccessGroupId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteVerifiedAccessGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_GROUP_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String verifiedAccessGroupId;

    private final String clientToken;

    private DeleteVerifiedAccessGroupRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Verified Access group.
     * </p>
     * 
     * @return The ID of the Verified Access group.
     */
    public final String verifiedAccessGroupId() {
        return verifiedAccessGroupId;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVerifiedAccessGroupRequest)) {
            return false;
        }
        DeleteVerifiedAccessGroupRequest other = (DeleteVerifiedAccessGroupRequest) obj;
        return Objects.equals(verifiedAccessGroupId(), other.verifiedAccessGroupId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVerifiedAccessGroupRequest").add("VerifiedAccessGroupId", verifiedAccessGroupId())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessGroupId":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroupId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVerifiedAccessGroupRequest, T> g) {
        return obj -> g.apply((DeleteVerifiedAccessGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVerifiedAccessGroupRequest> {
        /**
         * <p>
         * The ID of the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroupId
         *        The ID of the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroupId(String verifiedAccessGroupId);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String verifiedAccessGroupId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVerifiedAccessGroupRequest model) {
            super(model);
            verifiedAccessGroupId(model.verifiedAccessGroupId);
            clientToken(model.clientToken);
        }

        public final String getVerifiedAccessGroupId() {
            return verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVerifiedAccessGroupRequest build() {
            return new DeleteVerifiedAccessGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
