/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkCardInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkCardInfo> {
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(NetworkCardInfo.getter(NetworkCardInfo::networkCardIndex)).setter(NetworkCardInfo.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPerformance").getter(NetworkCardInfo.getter(NetworkCardInfo::networkPerformance)).setter(NetworkCardInfo.setter(Builder::networkPerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance").unmarshallLocationName("networkPerformance").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkInterfaces").getter(NetworkCardInfo.getter(NetworkCardInfo::maximumNetworkInterfaces)).setter(NetworkCardInfo.setter(Builder::maximumNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces").unmarshallLocationName("maximumNetworkInterfaces").build()}).build();
    private static final SdkField<Double> BASELINE_BANDWIDTH_IN_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BaselineBandwidthInGbps").getter(NetworkCardInfo.getter(NetworkCardInfo::baselineBandwidthInGbps)).setter(NetworkCardInfo.setter(Builder::baselineBandwidthInGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineBandwidthInGbps").unmarshallLocationName("baselineBandwidthInGbps").build()}).build();
    private static final SdkField<Double> PEAK_BANDWIDTH_IN_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PeakBandwidthInGbps").getter(NetworkCardInfo.getter(NetworkCardInfo::peakBandwidthInGbps)).setter(NetworkCardInfo.setter(Builder::peakBandwidthInGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakBandwidthInGbps").unmarshallLocationName("peakBandwidthInGbps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_CARD_INDEX_FIELD, NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD, BASELINE_BANDWIDTH_IN_GBPS_FIELD, PEAK_BANDWIDTH_IN_GBPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer networkCardIndex;
    private final String networkPerformance;
    private final Integer maximumNetworkInterfaces;
    private final Double baselineBandwidthInGbps;
    private final Double peakBandwidthInGbps;

    private NetworkCardInfo(BuilderImpl builder) {
        this.networkCardIndex = builder.networkCardIndex;
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.baselineBandwidthInGbps = builder.baselineBandwidthInGbps;
        this.peakBandwidthInGbps = builder.peakBandwidthInGbps;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final String networkPerformance() {
        return this.networkPerformance;
    }

    public final Integer maximumNetworkInterfaces() {
        return this.maximumNetworkInterfaces;
    }

    public final Double baselineBandwidthInGbps() {
        return this.baselineBandwidthInGbps;
    }

    public final Double peakBandwidthInGbps() {
        return this.peakBandwidthInGbps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineBandwidthInGbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.peakBandwidthInGbps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkCardInfo)) {
            return false;
        }
        NetworkCardInfo other = (NetworkCardInfo)obj;
        return Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && Objects.equals(this.networkPerformance(), other.networkPerformance()) && Objects.equals(this.maximumNetworkInterfaces(), other.maximumNetworkInterfaces()) && Objects.equals(this.baselineBandwidthInGbps(), other.baselineBandwidthInGbps()) && Objects.equals(this.peakBandwidthInGbps(), other.peakBandwidthInGbps());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkCardInfo").add("NetworkCardIndex", (Object)this.networkCardIndex()).add("NetworkPerformance", (Object)this.networkPerformance()).add("MaximumNetworkInterfaces", (Object)this.maximumNetworkInterfaces()).add("BaselineBandwidthInGbps", (Object)this.baselineBandwidthInGbps()).add("PeakBandwidthInGbps", (Object)this.peakBandwidthInGbps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "NetworkPerformance": {
                return Optional.ofNullable(clazz.cast(this.networkPerformance()));
            }
            case "MaximumNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkInterfaces()));
            }
            case "BaselineBandwidthInGbps": {
                return Optional.ofNullable(clazz.cast(this.baselineBandwidthInGbps()));
            }
            case "PeakBandwidthInGbps": {
                return Optional.ofNullable(clazz.cast(this.peakBandwidthInGbps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkCardInfo, T> g) {
        return obj -> g.apply((NetworkCardInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer networkCardIndex;
        private String networkPerformance;
        private Integer maximumNetworkInterfaces;
        private Double baselineBandwidthInGbps;
        private Double peakBandwidthInGbps;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkCardInfo model) {
            this.networkCardIndex(model.networkCardIndex);
            this.networkPerformance(model.networkPerformance);
            this.maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            this.baselineBandwidthInGbps(model.baselineBandwidthInGbps);
            this.peakBandwidthInGbps(model.peakBandwidthInGbps);
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getNetworkPerformance() {
            return this.networkPerformance;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return this.maximumNetworkInterfaces;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final Double getBaselineBandwidthInGbps() {
            return this.baselineBandwidthInGbps;
        }

        public final void setBaselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
        }

        @Override
        public final Builder baselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
            return this;
        }

        public final Double getPeakBandwidthInGbps() {
            return this.peakBandwidthInGbps;
        }

        public final void setPeakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
        }

        @Override
        public final Builder peakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
            return this;
        }

        public NetworkCardInfo build() {
            return new NetworkCardInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkCardInfo> {
        public Builder networkCardIndex(Integer var1);

        public Builder networkPerformance(String var1);

        public Builder maximumNetworkInterfaces(Integer var1);

        public Builder baselineBandwidthInGbps(Double var1);

        public Builder peakBandwidthInGbps(Double var1);
    }
}

