/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum InstanceType {
    A1_MEDIUM("a1.medium"),

    A1_LARGE("a1.large"),

    A1_XLARGE("a1.xlarge"),

    A1_2_XLARGE("a1.2xlarge"),

    A1_4_XLARGE("a1.4xlarge"),

    A1_METAL("a1.metal"),

    C1_MEDIUM("c1.medium"),

    C1_XLARGE("c1.xlarge"),

    C3_LARGE("c3.large"),

    C3_XLARGE("c3.xlarge"),

    C3_2_XLARGE("c3.2xlarge"),

    C3_4_XLARGE("c3.4xlarge"),

    C3_8_XLARGE("c3.8xlarge"),

    C4_LARGE("c4.large"),

    C4_XLARGE("c4.xlarge"),

    C4_2_XLARGE("c4.2xlarge"),

    C4_4_XLARGE("c4.4xlarge"),

    C4_8_XLARGE("c4.8xlarge"),

    C5_LARGE("c5.large"),

    C5_XLARGE("c5.xlarge"),

    C5_2_XLARGE("c5.2xlarge"),

    C5_4_XLARGE("c5.4xlarge"),

    C5_9_XLARGE("c5.9xlarge"),

    C5_12_XLARGE("c5.12xlarge"),

    C5_18_XLARGE("c5.18xlarge"),

    C5_24_XLARGE("c5.24xlarge"),

    C5_METAL("c5.metal"),

    C5_A_LARGE("c5a.large"),

    C5_A_XLARGE("c5a.xlarge"),

    C5_A_2_XLARGE("c5a.2xlarge"),

    C5_A_4_XLARGE("c5a.4xlarge"),

    C5_A_8_XLARGE("c5a.8xlarge"),

    C5_A_12_XLARGE("c5a.12xlarge"),

    C5_A_16_XLARGE("c5a.16xlarge"),

    C5_A_24_XLARGE("c5a.24xlarge"),

    C5_AD_LARGE("c5ad.large"),

    C5_AD_XLARGE("c5ad.xlarge"),

    C5_AD_2_XLARGE("c5ad.2xlarge"),

    C5_AD_4_XLARGE("c5ad.4xlarge"),

    C5_AD_8_XLARGE("c5ad.8xlarge"),

    C5_AD_12_XLARGE("c5ad.12xlarge"),

    C5_AD_16_XLARGE("c5ad.16xlarge"),

    C5_AD_24_XLARGE("c5ad.24xlarge"),

    C5_D_LARGE("c5d.large"),

    C5_D_XLARGE("c5d.xlarge"),

    C5_D_2_XLARGE("c5d.2xlarge"),

    C5_D_4_XLARGE("c5d.4xlarge"),

    C5_D_9_XLARGE("c5d.9xlarge"),

    C5_D_12_XLARGE("c5d.12xlarge"),

    C5_D_18_XLARGE("c5d.18xlarge"),

    C5_D_24_XLARGE("c5d.24xlarge"),

    C5_D_METAL("c5d.metal"),

    C5_N_LARGE("c5n.large"),

    C5_N_XLARGE("c5n.xlarge"),

    C5_N_2_XLARGE("c5n.2xlarge"),

    C5_N_4_XLARGE("c5n.4xlarge"),

    C5_N_9_XLARGE("c5n.9xlarge"),

    C5_N_18_XLARGE("c5n.18xlarge"),

    C5_N_METAL("c5n.metal"),

    C6_G_MEDIUM("c6g.medium"),

    C6_G_LARGE("c6g.large"),

    C6_G_XLARGE("c6g.xlarge"),

    C6_G_2_XLARGE("c6g.2xlarge"),

    C6_G_4_XLARGE("c6g.4xlarge"),

    C6_G_8_XLARGE("c6g.8xlarge"),

    C6_G_12_XLARGE("c6g.12xlarge"),

    C6_G_16_XLARGE("c6g.16xlarge"),

    C6_G_METAL("c6g.metal"),

    C6_GD_MEDIUM("c6gd.medium"),

    C6_GD_LARGE("c6gd.large"),

    C6_GD_XLARGE("c6gd.xlarge"),

    C6_GD_2_XLARGE("c6gd.2xlarge"),

    C6_GD_4_XLARGE("c6gd.4xlarge"),

    C6_GD_8_XLARGE("c6gd.8xlarge"),

    C6_GD_12_XLARGE("c6gd.12xlarge"),

    C6_GD_16_XLARGE("c6gd.16xlarge"),

    C6_GD_METAL("c6gd.metal"),

    C6_GN_MEDIUM("c6gn.medium"),

    C6_GN_LARGE("c6gn.large"),

    C6_GN_XLARGE("c6gn.xlarge"),

    C6_GN_2_XLARGE("c6gn.2xlarge"),

    C6_GN_4_XLARGE("c6gn.4xlarge"),

    C6_GN_8_XLARGE("c6gn.8xlarge"),

    C6_GN_12_XLARGE("c6gn.12xlarge"),

    C6_GN_16_XLARGE("c6gn.16xlarge"),

    C6_I_LARGE("c6i.large"),

    C6_I_XLARGE("c6i.xlarge"),

    C6_I_2_XLARGE("c6i.2xlarge"),

    C6_I_4_XLARGE("c6i.4xlarge"),

    C6_I_8_XLARGE("c6i.8xlarge"),

    C6_I_12_XLARGE("c6i.12xlarge"),

    C6_I_16_XLARGE("c6i.16xlarge"),

    C6_I_24_XLARGE("c6i.24xlarge"),

    C6_I_32_XLARGE("c6i.32xlarge"),

    C6_I_METAL("c6i.metal"),

    CC1_4_XLARGE("cc1.4xlarge"),

    CC2_8_XLARGE("cc2.8xlarge"),

    CG1_4_XLARGE("cg1.4xlarge"),

    CR1_8_XLARGE("cr1.8xlarge"),

    D2_XLARGE("d2.xlarge"),

    D2_2_XLARGE("d2.2xlarge"),

    D2_4_XLARGE("d2.4xlarge"),

    D2_8_XLARGE("d2.8xlarge"),

    D3_XLARGE("d3.xlarge"),

    D3_2_XLARGE("d3.2xlarge"),

    D3_4_XLARGE("d3.4xlarge"),

    D3_8_XLARGE("d3.8xlarge"),

    D3_EN_XLARGE("d3en.xlarge"),

    D3_EN_2_XLARGE("d3en.2xlarge"),

    D3_EN_4_XLARGE("d3en.4xlarge"),

    D3_EN_6_XLARGE("d3en.6xlarge"),

    D3_EN_8_XLARGE("d3en.8xlarge"),

    D3_EN_12_XLARGE("d3en.12xlarge"),

    DL1_24_XLARGE("dl1.24xlarge"),

    F1_2_XLARGE("f1.2xlarge"),

    F1_4_XLARGE("f1.4xlarge"),

    F1_16_XLARGE("f1.16xlarge"),

    G2_2_XLARGE("g2.2xlarge"),

    G2_8_XLARGE("g2.8xlarge"),

    G3_4_XLARGE("g3.4xlarge"),

    G3_8_XLARGE("g3.8xlarge"),

    G3_16_XLARGE("g3.16xlarge"),

    G3_S_XLARGE("g3s.xlarge"),

    G4_AD_XLARGE("g4ad.xlarge"),

    G4_AD_2_XLARGE("g4ad.2xlarge"),

    G4_AD_4_XLARGE("g4ad.4xlarge"),

    G4_AD_8_XLARGE("g4ad.8xlarge"),

    G4_AD_16_XLARGE("g4ad.16xlarge"),

    G4_DN_XLARGE("g4dn.xlarge"),

    G4_DN_2_XLARGE("g4dn.2xlarge"),

    G4_DN_4_XLARGE("g4dn.4xlarge"),

    G4_DN_8_XLARGE("g4dn.8xlarge"),

    G4_DN_12_XLARGE("g4dn.12xlarge"),

    G4_DN_16_XLARGE("g4dn.16xlarge"),

    G4_DN_METAL("g4dn.metal"),

    G5_XLARGE("g5.xlarge"),

    G5_2_XLARGE("g5.2xlarge"),

    G5_4_XLARGE("g5.4xlarge"),

    G5_8_XLARGE("g5.8xlarge"),

    G5_12_XLARGE("g5.12xlarge"),

    G5_16_XLARGE("g5.16xlarge"),

    G5_24_XLARGE("g5.24xlarge"),

    G5_48_XLARGE("g5.48xlarge"),

    G5_G_XLARGE("g5g.xlarge"),

    G5_G_2_XLARGE("g5g.2xlarge"),

    G5_G_4_XLARGE("g5g.4xlarge"),

    G5_G_8_XLARGE("g5g.8xlarge"),

    G5_G_16_XLARGE("g5g.16xlarge"),

    G5_G_METAL("g5g.metal"),

    HI1_4_XLARGE("hi1.4xlarge"),

    HPC6_A_48_XLARGE("hpc6a.48xlarge"),

    HS1_8_XLARGE("hs1.8xlarge"),

    H1_2_XLARGE("h1.2xlarge"),

    H1_4_XLARGE("h1.4xlarge"),

    H1_8_XLARGE("h1.8xlarge"),

    H1_16_XLARGE("h1.16xlarge"),

    I2_XLARGE("i2.xlarge"),

    I2_2_XLARGE("i2.2xlarge"),

    I2_4_XLARGE("i2.4xlarge"),

    I2_8_XLARGE("i2.8xlarge"),

    I3_LARGE("i3.large"),

    I3_XLARGE("i3.xlarge"),

    I3_2_XLARGE("i3.2xlarge"),

    I3_4_XLARGE("i3.4xlarge"),

    I3_8_XLARGE("i3.8xlarge"),

    I3_16_XLARGE("i3.16xlarge"),

    I3_METAL("i3.metal"),

    I3_EN_LARGE("i3en.large"),

    I3_EN_XLARGE("i3en.xlarge"),

    I3_EN_2_XLARGE("i3en.2xlarge"),

    I3_EN_3_XLARGE("i3en.3xlarge"),

    I3_EN_6_XLARGE("i3en.6xlarge"),

    I3_EN_12_XLARGE("i3en.12xlarge"),

    I3_EN_24_XLARGE("i3en.24xlarge"),

    I3_EN_METAL("i3en.metal"),

    IM4_GN_LARGE("im4gn.large"),

    IM4_GN_XLARGE("im4gn.xlarge"),

    IM4_GN_2_XLARGE("im4gn.2xlarge"),

    IM4_GN_4_XLARGE("im4gn.4xlarge"),

    IM4_GN_8_XLARGE("im4gn.8xlarge"),

    IM4_GN_16_XLARGE("im4gn.16xlarge"),

    INF1_XLARGE("inf1.xlarge"),

    INF1_2_XLARGE("inf1.2xlarge"),

    INF1_6_XLARGE("inf1.6xlarge"),

    INF1_24_XLARGE("inf1.24xlarge"),

    IS4_GEN_MEDIUM("is4gen.medium"),

    IS4_GEN_LARGE("is4gen.large"),

    IS4_GEN_XLARGE("is4gen.xlarge"),

    IS4_GEN_2_XLARGE("is4gen.2xlarge"),

    IS4_GEN_4_XLARGE("is4gen.4xlarge"),

    IS4_GEN_8_XLARGE("is4gen.8xlarge"),

    M1_SMALL("m1.small"),

    M1_MEDIUM("m1.medium"),

    M1_LARGE("m1.large"),

    M1_XLARGE("m1.xlarge"),

    M2_XLARGE("m2.xlarge"),

    M2_2_XLARGE("m2.2xlarge"),

    M2_4_XLARGE("m2.4xlarge"),

    M3_MEDIUM("m3.medium"),

    M3_LARGE("m3.large"),

    M3_XLARGE("m3.xlarge"),

    M3_2_XLARGE("m3.2xlarge"),

    M4_LARGE("m4.large"),

    M4_XLARGE("m4.xlarge"),

    M4_2_XLARGE("m4.2xlarge"),

    M4_4_XLARGE("m4.4xlarge"),

    M4_10_XLARGE("m4.10xlarge"),

    M4_16_XLARGE("m4.16xlarge"),

    M5_LARGE("m5.large"),

    M5_XLARGE("m5.xlarge"),

    M5_2_XLARGE("m5.2xlarge"),

    M5_4_XLARGE("m5.4xlarge"),

    M5_8_XLARGE("m5.8xlarge"),

    M5_12_XLARGE("m5.12xlarge"),

    M5_16_XLARGE("m5.16xlarge"),

    M5_24_XLARGE("m5.24xlarge"),

    M5_METAL("m5.metal"),

    M5_A_LARGE("m5a.large"),

    M5_A_XLARGE("m5a.xlarge"),

    M5_A_2_XLARGE("m5a.2xlarge"),

    M5_A_4_XLARGE("m5a.4xlarge"),

    M5_A_8_XLARGE("m5a.8xlarge"),

    M5_A_12_XLARGE("m5a.12xlarge"),

    M5_A_16_XLARGE("m5a.16xlarge"),

    M5_A_24_XLARGE("m5a.24xlarge"),

    M5_AD_LARGE("m5ad.large"),

    M5_AD_XLARGE("m5ad.xlarge"),

    M5_AD_2_XLARGE("m5ad.2xlarge"),

    M5_AD_4_XLARGE("m5ad.4xlarge"),

    M5_AD_8_XLARGE("m5ad.8xlarge"),

    M5_AD_12_XLARGE("m5ad.12xlarge"),

    M5_AD_16_XLARGE("m5ad.16xlarge"),

    M5_AD_24_XLARGE("m5ad.24xlarge"),

    M5_D_LARGE("m5d.large"),

    M5_D_XLARGE("m5d.xlarge"),

    M5_D_2_XLARGE("m5d.2xlarge"),

    M5_D_4_XLARGE("m5d.4xlarge"),

    M5_D_8_XLARGE("m5d.8xlarge"),

    M5_D_12_XLARGE("m5d.12xlarge"),

    M5_D_16_XLARGE("m5d.16xlarge"),

    M5_D_24_XLARGE("m5d.24xlarge"),

    M5_D_METAL("m5d.metal"),

    M5_DN_LARGE("m5dn.large"),

    M5_DN_XLARGE("m5dn.xlarge"),

    M5_DN_2_XLARGE("m5dn.2xlarge"),

    M5_DN_4_XLARGE("m5dn.4xlarge"),

    M5_DN_8_XLARGE("m5dn.8xlarge"),

    M5_DN_12_XLARGE("m5dn.12xlarge"),

    M5_DN_16_XLARGE("m5dn.16xlarge"),

    M5_DN_24_XLARGE("m5dn.24xlarge"),

    M5_DN_METAL("m5dn.metal"),

    M5_N_LARGE("m5n.large"),

    M5_N_XLARGE("m5n.xlarge"),

    M5_N_2_XLARGE("m5n.2xlarge"),

    M5_N_4_XLARGE("m5n.4xlarge"),

    M5_N_8_XLARGE("m5n.8xlarge"),

    M5_N_12_XLARGE("m5n.12xlarge"),

    M5_N_16_XLARGE("m5n.16xlarge"),

    M5_N_24_XLARGE("m5n.24xlarge"),

    M5_N_METAL("m5n.metal"),

    M5_ZN_LARGE("m5zn.large"),

    M5_ZN_XLARGE("m5zn.xlarge"),

    M5_ZN_2_XLARGE("m5zn.2xlarge"),

    M5_ZN_3_XLARGE("m5zn.3xlarge"),

    M5_ZN_6_XLARGE("m5zn.6xlarge"),

    M5_ZN_12_XLARGE("m5zn.12xlarge"),

    M5_ZN_METAL("m5zn.metal"),

    M6_A_LARGE("m6a.large"),

    M6_A_XLARGE("m6a.xlarge"),

    M6_A_2_XLARGE("m6a.2xlarge"),

    M6_A_4_XLARGE("m6a.4xlarge"),

    M6_A_8_XLARGE("m6a.8xlarge"),

    M6_A_12_XLARGE("m6a.12xlarge"),

    M6_A_16_XLARGE("m6a.16xlarge"),

    M6_A_24_XLARGE("m6a.24xlarge"),

    M6_A_32_XLARGE("m6a.32xlarge"),

    M6_A_48_XLARGE("m6a.48xlarge"),

    M6_G_METAL("m6g.metal"),

    M6_G_MEDIUM("m6g.medium"),

    M6_G_LARGE("m6g.large"),

    M6_G_XLARGE("m6g.xlarge"),

    M6_G_2_XLARGE("m6g.2xlarge"),

    M6_G_4_XLARGE("m6g.4xlarge"),

    M6_G_8_XLARGE("m6g.8xlarge"),

    M6_G_12_XLARGE("m6g.12xlarge"),

    M6_G_16_XLARGE("m6g.16xlarge"),

    M6_GD_METAL("m6gd.metal"),

    M6_GD_MEDIUM("m6gd.medium"),

    M6_GD_LARGE("m6gd.large"),

    M6_GD_XLARGE("m6gd.xlarge"),

    M6_GD_2_XLARGE("m6gd.2xlarge"),

    M6_GD_4_XLARGE("m6gd.4xlarge"),

    M6_GD_8_XLARGE("m6gd.8xlarge"),

    M6_GD_12_XLARGE("m6gd.12xlarge"),

    M6_GD_16_XLARGE("m6gd.16xlarge"),

    M6_I_LARGE("m6i.large"),

    M6_I_XLARGE("m6i.xlarge"),

    M6_I_2_XLARGE("m6i.2xlarge"),

    M6_I_4_XLARGE("m6i.4xlarge"),

    M6_I_8_XLARGE("m6i.8xlarge"),

    M6_I_12_XLARGE("m6i.12xlarge"),

    M6_I_16_XLARGE("m6i.16xlarge"),

    M6_I_24_XLARGE("m6i.24xlarge"),

    M6_I_32_XLARGE("m6i.32xlarge"),

    M6_I_METAL("m6i.metal"),

    MAC1_METAL("mac1.metal"),

    P2_XLARGE("p2.xlarge"),

    P2_8_XLARGE("p2.8xlarge"),

    P2_16_XLARGE("p2.16xlarge"),

    P3_2_XLARGE("p3.2xlarge"),

    P3_8_XLARGE("p3.8xlarge"),

    P3_16_XLARGE("p3.16xlarge"),

    P3_DN_24_XLARGE("p3dn.24xlarge"),

    P4_D_24_XLARGE("p4d.24xlarge"),

    R3_LARGE("r3.large"),

    R3_XLARGE("r3.xlarge"),

    R3_2_XLARGE("r3.2xlarge"),

    R3_4_XLARGE("r3.4xlarge"),

    R3_8_XLARGE("r3.8xlarge"),

    R4_LARGE("r4.large"),

    R4_XLARGE("r4.xlarge"),

    R4_2_XLARGE("r4.2xlarge"),

    R4_4_XLARGE("r4.4xlarge"),

    R4_8_XLARGE("r4.8xlarge"),

    R4_16_XLARGE("r4.16xlarge"),

    R5_LARGE("r5.large"),

    R5_XLARGE("r5.xlarge"),

    R5_2_XLARGE("r5.2xlarge"),

    R5_4_XLARGE("r5.4xlarge"),

    R5_8_XLARGE("r5.8xlarge"),

    R5_12_XLARGE("r5.12xlarge"),

    R5_16_XLARGE("r5.16xlarge"),

    R5_24_XLARGE("r5.24xlarge"),

    R5_METAL("r5.metal"),

    R5_A_LARGE("r5a.large"),

    R5_A_XLARGE("r5a.xlarge"),

    R5_A_2_XLARGE("r5a.2xlarge"),

    R5_A_4_XLARGE("r5a.4xlarge"),

    R5_A_8_XLARGE("r5a.8xlarge"),

    R5_A_12_XLARGE("r5a.12xlarge"),

    R5_A_16_XLARGE("r5a.16xlarge"),

    R5_A_24_XLARGE("r5a.24xlarge"),

    R5_AD_LARGE("r5ad.large"),

    R5_AD_XLARGE("r5ad.xlarge"),

    R5_AD_2_XLARGE("r5ad.2xlarge"),

    R5_AD_4_XLARGE("r5ad.4xlarge"),

    R5_AD_8_XLARGE("r5ad.8xlarge"),

    R5_AD_12_XLARGE("r5ad.12xlarge"),

    R5_AD_16_XLARGE("r5ad.16xlarge"),

    R5_AD_24_XLARGE("r5ad.24xlarge"),

    R5_B_LARGE("r5b.large"),

    R5_B_XLARGE("r5b.xlarge"),

    R5_B_2_XLARGE("r5b.2xlarge"),

    R5_B_4_XLARGE("r5b.4xlarge"),

    R5_B_8_XLARGE("r5b.8xlarge"),

    R5_B_12_XLARGE("r5b.12xlarge"),

    R5_B_16_XLARGE("r5b.16xlarge"),

    R5_B_24_XLARGE("r5b.24xlarge"),

    R5_B_METAL("r5b.metal"),

    R5_D_LARGE("r5d.large"),

    R5_D_XLARGE("r5d.xlarge"),

    R5_D_2_XLARGE("r5d.2xlarge"),

    R5_D_4_XLARGE("r5d.4xlarge"),

    R5_D_8_XLARGE("r5d.8xlarge"),

    R5_D_12_XLARGE("r5d.12xlarge"),

    R5_D_16_XLARGE("r5d.16xlarge"),

    R5_D_24_XLARGE("r5d.24xlarge"),

    R5_D_METAL("r5d.metal"),

    R5_DN_LARGE("r5dn.large"),

    R5_DN_XLARGE("r5dn.xlarge"),

    R5_DN_2_XLARGE("r5dn.2xlarge"),

    R5_DN_4_XLARGE("r5dn.4xlarge"),

    R5_DN_8_XLARGE("r5dn.8xlarge"),

    R5_DN_12_XLARGE("r5dn.12xlarge"),

    R5_DN_16_XLARGE("r5dn.16xlarge"),

    R5_DN_24_XLARGE("r5dn.24xlarge"),

    R5_DN_METAL("r5dn.metal"),

    R5_N_LARGE("r5n.large"),

    R5_N_XLARGE("r5n.xlarge"),

    R5_N_2_XLARGE("r5n.2xlarge"),

    R5_N_4_XLARGE("r5n.4xlarge"),

    R5_N_8_XLARGE("r5n.8xlarge"),

    R5_N_12_XLARGE("r5n.12xlarge"),

    R5_N_16_XLARGE("r5n.16xlarge"),

    R5_N_24_XLARGE("r5n.24xlarge"),

    R5_N_METAL("r5n.metal"),

    R6_G_MEDIUM("r6g.medium"),

    R6_G_LARGE("r6g.large"),

    R6_G_XLARGE("r6g.xlarge"),

    R6_G_2_XLARGE("r6g.2xlarge"),

    R6_G_4_XLARGE("r6g.4xlarge"),

    R6_G_8_XLARGE("r6g.8xlarge"),

    R6_G_12_XLARGE("r6g.12xlarge"),

    R6_G_16_XLARGE("r6g.16xlarge"),

    R6_G_METAL("r6g.metal"),

    R6_GD_MEDIUM("r6gd.medium"),

    R6_GD_LARGE("r6gd.large"),

    R6_GD_XLARGE("r6gd.xlarge"),

    R6_GD_2_XLARGE("r6gd.2xlarge"),

    R6_GD_4_XLARGE("r6gd.4xlarge"),

    R6_GD_8_XLARGE("r6gd.8xlarge"),

    R6_GD_12_XLARGE("r6gd.12xlarge"),

    R6_GD_16_XLARGE("r6gd.16xlarge"),

    R6_GD_METAL("r6gd.metal"),

    R6_I_LARGE("r6i.large"),

    R6_I_XLARGE("r6i.xlarge"),

    R6_I_2_XLARGE("r6i.2xlarge"),

    R6_I_4_XLARGE("r6i.4xlarge"),

    R6_I_8_XLARGE("r6i.8xlarge"),

    R6_I_12_XLARGE("r6i.12xlarge"),

    R6_I_16_XLARGE("r6i.16xlarge"),

    R6_I_24_XLARGE("r6i.24xlarge"),

    R6_I_32_XLARGE("r6i.32xlarge"),

    R6_I_METAL("r6i.metal"),

    T1_MICRO("t1.micro"),

    T2_NANO("t2.nano"),

    T2_MICRO("t2.micro"),

    T2_SMALL("t2.small"),

    T2_MEDIUM("t2.medium"),

    T2_LARGE("t2.large"),

    T2_XLARGE("t2.xlarge"),

    T2_2_XLARGE("t2.2xlarge"),

    T3_NANO("t3.nano"),

    T3_MICRO("t3.micro"),

    T3_SMALL("t3.small"),

    T3_MEDIUM("t3.medium"),

    T3_LARGE("t3.large"),

    T3_XLARGE("t3.xlarge"),

    T3_2_XLARGE("t3.2xlarge"),

    T3_A_NANO("t3a.nano"),

    T3_A_MICRO("t3a.micro"),

    T3_A_SMALL("t3a.small"),

    T3_A_MEDIUM("t3a.medium"),

    T3_A_LARGE("t3a.large"),

    T3_A_XLARGE("t3a.xlarge"),

    T3_A_2_XLARGE("t3a.2xlarge"),

    T4_G_NANO("t4g.nano"),

    T4_G_MICRO("t4g.micro"),

    T4_G_SMALL("t4g.small"),

    T4_G_MEDIUM("t4g.medium"),

    T4_G_LARGE("t4g.large"),

    T4_G_XLARGE("t4g.xlarge"),

    T4_G_2_XLARGE("t4g.2xlarge"),

    U_6_TB1_56_XLARGE("u-6tb1.56xlarge"),

    U_6_TB1_112_XLARGE("u-6tb1.112xlarge"),

    U_9_TB1_112_XLARGE("u-9tb1.112xlarge"),

    U_12_TB1_112_XLARGE("u-12tb1.112xlarge"),

    U_6_TB1_METAL("u-6tb1.metal"),

    U_9_TB1_METAL("u-9tb1.metal"),

    U_12_TB1_METAL("u-12tb1.metal"),

    U_18_TB1_METAL("u-18tb1.metal"),

    U_24_TB1_METAL("u-24tb1.metal"),

    VT1_3_XLARGE("vt1.3xlarge"),

    VT1_6_XLARGE("vt1.6xlarge"),

    VT1_24_XLARGE("vt1.24xlarge"),

    X1_16_XLARGE("x1.16xlarge"),

    X1_32_XLARGE("x1.32xlarge"),

    X1_E_XLARGE("x1e.xlarge"),

    X1_E_2_XLARGE("x1e.2xlarge"),

    X1_E_4_XLARGE("x1e.4xlarge"),

    X1_E_8_XLARGE("x1e.8xlarge"),

    X1_E_16_XLARGE("x1e.16xlarge"),

    X1_E_32_XLARGE("x1e.32xlarge"),

    X2_IEZN_2_XLARGE("x2iezn.2xlarge"),

    X2_IEZN_4_XLARGE("x2iezn.4xlarge"),

    X2_IEZN_6_XLARGE("x2iezn.6xlarge"),

    X2_IEZN_8_XLARGE("x2iezn.8xlarge"),

    X2_IEZN_12_XLARGE("x2iezn.12xlarge"),

    X2_IEZN_METAL("x2iezn.metal"),

    X2_GD_MEDIUM("x2gd.medium"),

    X2_GD_LARGE("x2gd.large"),

    X2_GD_XLARGE("x2gd.xlarge"),

    X2_GD_2_XLARGE("x2gd.2xlarge"),

    X2_GD_4_XLARGE("x2gd.4xlarge"),

    X2_GD_8_XLARGE("x2gd.8xlarge"),

    X2_GD_12_XLARGE("x2gd.12xlarge"),

    X2_GD_16_XLARGE("x2gd.16xlarge"),

    X2_GD_METAL("x2gd.metal"),

    Z1_D_LARGE("z1d.large"),

    Z1_D_XLARGE("z1d.xlarge"),

    Z1_D_2_XLARGE("z1d.2xlarge"),

    Z1_D_3_XLARGE("z1d.3xlarge"),

    Z1_D_6_XLARGE("z1d.6xlarge"),

    Z1_D_12_XLARGE("z1d.12xlarge"),

    Z1_D_METAL("z1d.metal"),

    X2_IDN_16_XLARGE("x2idn.16xlarge"),

    X2_IDN_24_XLARGE("x2idn.24xlarge"),

    X2_IDN_32_XLARGE("x2idn.32xlarge"),

    X2_IEDN_XLARGE("x2iedn.xlarge"),

    X2_IEDN_2_XLARGE("x2iedn.2xlarge"),

    X2_IEDN_4_XLARGE("x2iedn.4xlarge"),

    X2_IEDN_8_XLARGE("x2iedn.8xlarge"),

    X2_IEDN_16_XLARGE("x2iedn.16xlarge"),

    X2_IEDN_24_XLARGE("x2iedn.24xlarge"),

    X2_IEDN_32_XLARGE("x2iedn.32xlarge"),

    C6_A_LARGE("c6a.large"),

    C6_A_XLARGE("c6a.xlarge"),

    C6_A_2_XLARGE("c6a.2xlarge"),

    C6_A_4_XLARGE("c6a.4xlarge"),

    C6_A_8_XLARGE("c6a.8xlarge"),

    C6_A_12_XLARGE("c6a.12xlarge"),

    C6_A_16_XLARGE("c6a.16xlarge"),

    C6_A_24_XLARGE("c6a.24xlarge"),

    C6_A_32_XLARGE("c6a.32xlarge"),

    C6_A_48_XLARGE("c6a.48xlarge"),

    C6_A_METAL("c6a.metal"),

    M6_A_METAL("m6a.metal"),

    I4_I_LARGE("i4i.large"),

    I4_I_XLARGE("i4i.xlarge"),

    I4_I_2_XLARGE("i4i.2xlarge"),

    I4_I_4_XLARGE("i4i.4xlarge"),

    I4_I_8_XLARGE("i4i.8xlarge"),

    I4_I_16_XLARGE("i4i.16xlarge"),

    I4_I_32_XLARGE("i4i.32xlarge"),

    I4_I_METAL("i4i.metal"),

    X2_IDN_METAL("x2idn.metal"),

    X2_IEDN_METAL("x2iedn.metal"),

    C7_G_MEDIUM("c7g.medium"),

    C7_G_LARGE("c7g.large"),

    C7_G_XLARGE("c7g.xlarge"),

    C7_G_2_XLARGE("c7g.2xlarge"),

    C7_G_4_XLARGE("c7g.4xlarge"),

    C7_G_8_XLARGE("c7g.8xlarge"),

    C7_G_12_XLARGE("c7g.12xlarge"),

    C7_G_16_XLARGE("c7g.16xlarge"),

    MAC2_METAL("mac2.metal"),

    C6_ID_LARGE("c6id.large"),

    C6_ID_XLARGE("c6id.xlarge"),

    C6_ID_2_XLARGE("c6id.2xlarge"),

    C6_ID_4_XLARGE("c6id.4xlarge"),

    C6_ID_8_XLARGE("c6id.8xlarge"),

    C6_ID_12_XLARGE("c6id.12xlarge"),

    C6_ID_16_XLARGE("c6id.16xlarge"),

    C6_ID_24_XLARGE("c6id.24xlarge"),

    C6_ID_32_XLARGE("c6id.32xlarge"),

    C6_ID_METAL("c6id.metal"),

    M6_ID_LARGE("m6id.large"),

    M6_ID_XLARGE("m6id.xlarge"),

    M6_ID_2_XLARGE("m6id.2xlarge"),

    M6_ID_4_XLARGE("m6id.4xlarge"),

    M6_ID_8_XLARGE("m6id.8xlarge"),

    M6_ID_12_XLARGE("m6id.12xlarge"),

    M6_ID_16_XLARGE("m6id.16xlarge"),

    M6_ID_24_XLARGE("m6id.24xlarge"),

    M6_ID_32_XLARGE("m6id.32xlarge"),

    M6_ID_METAL("m6id.metal"),

    R6_ID_LARGE("r6id.large"),

    R6_ID_XLARGE("r6id.xlarge"),

    R6_ID_2_XLARGE("r6id.2xlarge"),

    R6_ID_4_XLARGE("r6id.4xlarge"),

    R6_ID_8_XLARGE("r6id.8xlarge"),

    R6_ID_12_XLARGE("r6id.12xlarge"),

    R6_ID_16_XLARGE("r6id.16xlarge"),

    R6_ID_24_XLARGE("r6id.24xlarge"),

    R6_ID_32_XLARGE("r6id.32xlarge"),

    R6_ID_METAL("r6id.metal"),

    R6_A_LARGE("r6a.large"),

    R6_A_XLARGE("r6a.xlarge"),

    R6_A_2_XLARGE("r6a.2xlarge"),

    R6_A_4_XLARGE("r6a.4xlarge"),

    R6_A_8_XLARGE("r6a.8xlarge"),

    R6_A_12_XLARGE("r6a.12xlarge"),

    R6_A_16_XLARGE("r6a.16xlarge"),

    R6_A_24_XLARGE("r6a.24xlarge"),

    R6_A_32_XLARGE("r6a.32xlarge"),

    R6_A_48_XLARGE("r6a.48xlarge"),

    R6_A_METAL("r6a.metal"),

    P4_DE_24_XLARGE("p4de.24xlarge"),

    U_3_TB1_56_XLARGE("u-3tb1.56xlarge"),

    U_18_TB1_112_XLARGE("u-18tb1.112xlarge"),

    U_24_TB1_112_XLARGE("u-24tb1.112xlarge"),

    TRN1_2_XLARGE("trn1.2xlarge"),

    TRN1_32_XLARGE("trn1.32xlarge"),

    HPC6_ID_32_XLARGE("hpc6id.32xlarge"),

    C6_IN_LARGE("c6in.large"),

    C6_IN_XLARGE("c6in.xlarge"),

    C6_IN_2_XLARGE("c6in.2xlarge"),

    C6_IN_4_XLARGE("c6in.4xlarge"),

    C6_IN_8_XLARGE("c6in.8xlarge"),

    C6_IN_12_XLARGE("c6in.12xlarge"),

    C6_IN_16_XLARGE("c6in.16xlarge"),

    C6_IN_24_XLARGE("c6in.24xlarge"),

    C6_IN_32_XLARGE("c6in.32xlarge"),

    M6_IN_LARGE("m6in.large"),

    M6_IN_XLARGE("m6in.xlarge"),

    M6_IN_2_XLARGE("m6in.2xlarge"),

    M6_IN_4_XLARGE("m6in.4xlarge"),

    M6_IN_8_XLARGE("m6in.8xlarge"),

    M6_IN_12_XLARGE("m6in.12xlarge"),

    M6_IN_16_XLARGE("m6in.16xlarge"),

    M6_IN_24_XLARGE("m6in.24xlarge"),

    M6_IN_32_XLARGE("m6in.32xlarge"),

    M6_IDN_LARGE("m6idn.large"),

    M6_IDN_XLARGE("m6idn.xlarge"),

    M6_IDN_2_XLARGE("m6idn.2xlarge"),

    M6_IDN_4_XLARGE("m6idn.4xlarge"),

    M6_IDN_8_XLARGE("m6idn.8xlarge"),

    M6_IDN_12_XLARGE("m6idn.12xlarge"),

    M6_IDN_16_XLARGE("m6idn.16xlarge"),

    M6_IDN_24_XLARGE("m6idn.24xlarge"),

    M6_IDN_32_XLARGE("m6idn.32xlarge"),

    R6_IN_LARGE("r6in.large"),

    R6_IN_XLARGE("r6in.xlarge"),

    R6_IN_2_XLARGE("r6in.2xlarge"),

    R6_IN_4_XLARGE("r6in.4xlarge"),

    R6_IN_8_XLARGE("r6in.8xlarge"),

    R6_IN_12_XLARGE("r6in.12xlarge"),

    R6_IN_16_XLARGE("r6in.16xlarge"),

    R6_IN_24_XLARGE("r6in.24xlarge"),

    R6_IN_32_XLARGE("r6in.32xlarge"),

    R6_IDN_LARGE("r6idn.large"),

    R6_IDN_XLARGE("r6idn.xlarge"),

    R6_IDN_2_XLARGE("r6idn.2xlarge"),

    R6_IDN_4_XLARGE("r6idn.4xlarge"),

    R6_IDN_8_XLARGE("r6idn.8xlarge"),

    R6_IDN_12_XLARGE("r6idn.12xlarge"),

    R6_IDN_16_XLARGE("r6idn.16xlarge"),

    R6_IDN_24_XLARGE("r6idn.24xlarge"),

    R6_IDN_32_XLARGE("r6idn.32xlarge"),

    C7_G_METAL("c7g.metal"),

    M7_G_MEDIUM("m7g.medium"),

    M7_G_LARGE("m7g.large"),

    M7_G_XLARGE("m7g.xlarge"),

    M7_G_2_XLARGE("m7g.2xlarge"),

    M7_G_4_XLARGE("m7g.4xlarge"),

    M7_G_8_XLARGE("m7g.8xlarge"),

    M7_G_12_XLARGE("m7g.12xlarge"),

    M7_G_16_XLARGE("m7g.16xlarge"),

    M7_G_METAL("m7g.metal"),

    R7_G_MEDIUM("r7g.medium"),

    R7_G_LARGE("r7g.large"),

    R7_G_XLARGE("r7g.xlarge"),

    R7_G_2_XLARGE("r7g.2xlarge"),

    R7_G_4_XLARGE("r7g.4xlarge"),

    R7_G_8_XLARGE("r7g.8xlarge"),

    R7_G_12_XLARGE("r7g.12xlarge"),

    R7_G_16_XLARGE("r7g.16xlarge"),

    R7_G_METAL("r7g.metal"),

    C6_IN_METAL("c6in.metal"),

    M6_IN_METAL("m6in.metal"),

    M6_IDN_METAL("m6idn.metal"),

    R6_IN_METAL("r6in.metal"),

    R6_IDN_METAL("r6idn.metal"),

    INF2_XLARGE("inf2.xlarge"),

    INF2_8_XLARGE("inf2.8xlarge"),

    INF2_24_XLARGE("inf2.24xlarge"),

    INF2_48_XLARGE("inf2.48xlarge"),

    TRN1_N_32_XLARGE("trn1n.32xlarge"),

    I4_G_LARGE("i4g.large"),

    I4_G_XLARGE("i4g.xlarge"),

    I4_G_2_XLARGE("i4g.2xlarge"),

    I4_G_4_XLARGE("i4g.4xlarge"),

    I4_G_8_XLARGE("i4g.8xlarge"),

    I4_G_16_XLARGE("i4g.16xlarge"),

    HPC7_G_4_XLARGE("hpc7g.4xlarge"),

    HPC7_G_8_XLARGE("hpc7g.8xlarge"),

    HPC7_G_16_XLARGE("hpc7g.16xlarge"),

    C7_GN_MEDIUM("c7gn.medium"),

    C7_GN_LARGE("c7gn.large"),

    C7_GN_XLARGE("c7gn.xlarge"),

    C7_GN_2_XLARGE("c7gn.2xlarge"),

    C7_GN_4_XLARGE("c7gn.4xlarge"),

    C7_GN_8_XLARGE("c7gn.8xlarge"),

    C7_GN_12_XLARGE("c7gn.12xlarge"),

    C7_GN_16_XLARGE("c7gn.16xlarge"),

    P5_48_XLARGE("p5.48xlarge"),

    M7_I_LARGE("m7i.large"),

    M7_I_XLARGE("m7i.xlarge"),

    M7_I_2_XLARGE("m7i.2xlarge"),

    M7_I_4_XLARGE("m7i.4xlarge"),

    M7_I_8_XLARGE("m7i.8xlarge"),

    M7_I_12_XLARGE("m7i.12xlarge"),

    M7_I_16_XLARGE("m7i.16xlarge"),

    M7_I_24_XLARGE("m7i.24xlarge"),

    M7_I_48_XLARGE("m7i.48xlarge"),

    M7_I_FLEX_LARGE("m7i-flex.large"),

    M7_I_FLEX_XLARGE("m7i-flex.xlarge"),

    M7_I_FLEX_2_XLARGE("m7i-flex.2xlarge"),

    M7_I_FLEX_4_XLARGE("m7i-flex.4xlarge"),

    M7_I_FLEX_8_XLARGE("m7i-flex.8xlarge"),

    M7_A_MEDIUM("m7a.medium"),

    M7_A_LARGE("m7a.large"),

    M7_A_XLARGE("m7a.xlarge"),

    M7_A_2_XLARGE("m7a.2xlarge"),

    M7_A_4_XLARGE("m7a.4xlarge"),

    M7_A_8_XLARGE("m7a.8xlarge"),

    M7_A_12_XLARGE("m7a.12xlarge"),

    M7_A_16_XLARGE("m7a.16xlarge"),

    M7_A_24_XLARGE("m7a.24xlarge"),

    M7_A_32_XLARGE("m7a.32xlarge"),

    M7_A_48_XLARGE("m7a.48xlarge"),

    M7_A_METAL_48_XL("m7a.metal-48xl"),

    HPC7_A_12_XLARGE("hpc7a.12xlarge"),

    HPC7_A_24_XLARGE("hpc7a.24xlarge"),

    HPC7_A_48_XLARGE("hpc7a.48xlarge"),

    HPC7_A_96_XLARGE("hpc7a.96xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceType> VALUE_MAP = EnumUtils.uniqueIndex(InstanceType.class, InstanceType::toString);

    private final String value;

    private InstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InstanceType corresponding to the value
     */
    public static InstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InstanceType}s
     */
    public static Set<InstanceType> knownValues() {
        Set<InstanceType> knownValues = EnumSet.allOf(InstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
