/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a scheduled event for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStatusEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStatusEvent.Builder, InstanceStatusEvent> {
    private static final SdkField<String> INSTANCE_EVENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventId")
            .getter(getter(InstanceStatusEvent::instanceEventId))
            .setter(setter(Builder::instanceEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventId")
                    .unmarshallLocationName("instanceEventId").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Code")
            .getter(getter(InstanceStatusEvent::codeAsString))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(InstanceStatusEvent::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotAfter")
            .getter(getter(InstanceStatusEvent::notAfter))
            .setter(setter(Builder::notAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter")
                    .unmarshallLocationName("notAfter").build()).build();

    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotBefore")
            .getter(getter(InstanceStatusEvent::notBefore))
            .setter(setter(Builder::notBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore")
                    .unmarshallLocationName("notBefore").build()).build();

    private static final SdkField<Instant> NOT_BEFORE_DEADLINE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotBeforeDeadline")
            .getter(getter(InstanceStatusEvent::notBeforeDeadline))
            .setter(setter(Builder::notBeforeDeadline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBeforeDeadline")
                    .unmarshallLocationName("notBeforeDeadline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_ID_FIELD,
            CODE_FIELD, DESCRIPTION_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, NOT_BEFORE_DEADLINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceEventId;

    private final String code;

    private final String description;

    private final Instant notAfter;

    private final Instant notBefore;

    private final Instant notBeforeDeadline;

    private InstanceStatusEvent(BuilderImpl builder) {
        this.instanceEventId = builder.instanceEventId;
        this.code = builder.code;
        this.description = builder.description;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.notBeforeDeadline = builder.notBeforeDeadline;
    }

    /**
     * <p>
     * The ID of the event.
     * </p>
     * 
     * @return The ID of the event.
     */
    public final String instanceEventId() {
        return instanceEventId;
    }

    /**
     * <p>
     * The event code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link EventCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The event code.
     * @see EventCode
     */
    public final EventCode code() {
        return EventCode.fromValue(code);
    }

    /**
     * <p>
     * The event code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link EventCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The event code.
     * @see EventCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A description of the event.
     * </p>
     * <p>
     * After a scheduled event is completed, it can still be described for up to a week. If the event has been
     * completed, this description starts with the following text: [Completed].
     * </p>
     * 
     * @return A description of the event.</p>
     *         <p>
     *         After a scheduled event is completed, it can still be described for up to a week. If the event has been
     *         completed, this description starts with the following text: [Completed].
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The latest scheduled end time for the event.
     * </p>
     * 
     * @return The latest scheduled end time for the event.
     */
    public final Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The earliest scheduled start time for the event.
     * </p>
     * 
     * @return The earliest scheduled start time for the event.
     */
    public final Instant notBefore() {
        return notBefore;
    }

    /**
     * <p>
     * The deadline for starting the event.
     * </p>
     * 
     * @return The deadline for starting the event.
     */
    public final Instant notBeforeDeadline() {
        return notBeforeDeadline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventId());
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(notBeforeDeadline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusEvent)) {
            return false;
        }
        InstanceStatusEvent other = (InstanceStatusEvent) obj;
        return Objects.equals(instanceEventId(), other.instanceEventId()) && Objects.equals(codeAsString(), other.codeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(notAfter(), other.notAfter())
                && Objects.equals(notBefore(), other.notBefore())
                && Objects.equals(notBeforeDeadline(), other.notBeforeDeadline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceStatusEvent").add("InstanceEventId", instanceEventId()).add("Code", codeAsString())
                .add("Description", description()).add("NotAfter", notAfter()).add("NotBefore", notBefore())
                .add("NotBeforeDeadline", notBeforeDeadline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventId":
            return Optional.ofNullable(clazz.cast(instanceEventId()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NotAfter":
            return Optional.ofNullable(clazz.cast(notAfter()));
        case "NotBefore":
            return Optional.ofNullable(clazz.cast(notBefore()));
        case "NotBeforeDeadline":
            return Optional.ofNullable(clazz.cast(notBeforeDeadline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatusEvent, T> g) {
        return obj -> g.apply((InstanceStatusEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStatusEvent> {
        /**
         * <p>
         * The ID of the event.
         * </p>
         * 
         * @param instanceEventId
         *        The ID of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventId(String instanceEventId);

        /**
         * <p>
         * The event code.
         * </p>
         * 
         * @param code
         *        The event code.
         * @see EventCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCode
         */
        Builder code(String code);

        /**
         * <p>
         * The event code.
         * </p>
         * 
         * @param code
         *        The event code.
         * @see EventCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventCode
         */
        Builder code(EventCode code);

        /**
         * <p>
         * A description of the event.
         * </p>
         * <p>
         * After a scheduled event is completed, it can still be described for up to a week. If the event has been
         * completed, this description starts with the following text: [Completed].
         * </p>
         * 
         * @param description
         *        A description of the event.</p>
         *        <p>
         *        After a scheduled event is completed, it can still be described for up to a week. If the event has
         *        been completed, this description starts with the following text: [Completed].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The latest scheduled end time for the event.
         * </p>
         * 
         * @param notAfter
         *        The latest scheduled end time for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * The earliest scheduled start time for the event.
         * </p>
         * 
         * @param notBefore
         *        The earliest scheduled start time for the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);

        /**
         * <p>
         * The deadline for starting the event.
         * </p>
         * 
         * @param notBeforeDeadline
         *        The deadline for starting the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBeforeDeadline(Instant notBeforeDeadline);
    }

    static final class BuilderImpl implements Builder {
        private String instanceEventId;

        private String code;

        private String description;

        private Instant notAfter;

        private Instant notBefore;

        private Instant notBeforeDeadline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusEvent model) {
            instanceEventId(model.instanceEventId);
            code(model.code);
            description(model.description);
            notAfter(model.notAfter);
            notBefore(model.notBefore);
            notBeforeDeadline(model.notBeforeDeadline);
        }

        public final String getInstanceEventId() {
            return instanceEventId;
        }

        public final void setInstanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
        }

        @Override
        public final Builder instanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(EventCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final Instant getNotBeforeDeadline() {
            return notBeforeDeadline;
        }

        public final void setNotBeforeDeadline(Instant notBeforeDeadline) {
            this.notBeforeDeadline = notBeforeDeadline;
        }

        @Override
        public final Builder notBeforeDeadline(Instant notBeforeDeadline) {
            this.notBeforeDeadline = notBeforeDeadline;
            return this;
        }

        @Override
        public InstanceStatusEvent build() {
            return new InstanceStatusEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
