/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the default credit option for CPU usage of a burstable performance instance family.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFamilyCreditSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFamilyCreditSpecification.Builder, InstanceFamilyCreditSpecification> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily")
            .getter(getter(InstanceFamilyCreditSpecification::instanceFamilyAsString))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("instanceFamily").build()).build();

    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CpuCredits")
            .getter(getter(InstanceFamilyCreditSpecification::cpuCredits))
            .setter(setter(Builder::cpuCredits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits")
                    .unmarshallLocationName("cpuCredits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD,
            CPU_CREDITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceFamily;

    private final String cpuCredits;

    private InstanceFamilyCreditSpecification(BuilderImpl builder) {
        this.instanceFamily = builder.instanceFamily;
        this.cpuCredits = builder.cpuCredits;
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public final UnlimitedSupportedInstanceFamily instanceFamily() {
        return UnlimitedSupportedInstanceFamily.fromValue(instanceFamily);
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public final String instanceFamilyAsString() {
        return instanceFamily;
    }

    /**
     * <p>
     * The default credit option for CPU usage of the instance family. Valid values are <code>standard</code> and
     * <code>unlimited</code>.
     * </p>
     * 
     * @return The default credit option for CPU usage of the instance family. Valid values are <code>standard</code>
     *         and <code>unlimited</code>.
     */
    public final String cpuCredits() {
        return cpuCredits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCredits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFamilyCreditSpecification)) {
            return false;
        }
        InstanceFamilyCreditSpecification other = (InstanceFamilyCreditSpecification) obj;
        return Objects.equals(instanceFamilyAsString(), other.instanceFamilyAsString())
                && Objects.equals(cpuCredits(), other.cpuCredits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceFamilyCreditSpecification").add("InstanceFamily", instanceFamilyAsString())
                .add("CpuCredits", cpuCredits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamilyAsString()));
        case "CpuCredits":
            return Optional.ofNullable(clazz.cast(cpuCredits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFamilyCreditSpecification, T> g) {
        return obj -> g.apply((InstanceFamilyCreditSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFamilyCreditSpecification> {
        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily);

        /**
         * <p>
         * The default credit option for CPU usage of the instance family. Valid values are <code>standard</code> and
         * <code>unlimited</code>.
         * </p>
         * 
         * @param cpuCredits
         *        The default credit option for CPU usage of the instance family. Valid values are <code>standard</code>
         *        and <code>unlimited</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCredits(String cpuCredits);
    }

    static final class BuilderImpl implements Builder {
        private String instanceFamily;

        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFamilyCreditSpecification model) {
            instanceFamily(model.instanceFamily);
            cpuCredits(model.cpuCredits);
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public final Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
            this.instanceFamily(instanceFamily == null ? null : instanceFamily.toString());
            return this;
        }

        public final String getCpuCredits() {
            return cpuCredits;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        @Override
        public InstanceFamilyCreditSpecification build() {
            return new InstanceFamilyCreditSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
