/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes service integrations with VPC Flow logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrateServices implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrateServices.Builder, IntegrateServices> {
    private static final SdkField<List<AthenaIntegration>> ATHENA_INTEGRATIONS_FIELD = SdkField
            .<List<AthenaIntegration>> builder(MarshallingType.LIST)
            .memberName("AthenaIntegrations")
            .getter(getter(IntegrateServices::athenaIntegrations))
            .setter(setter(Builder::athenaIntegrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaIntegration")
                    .unmarshallLocationName("AthenaIntegration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AthenaIntegration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AthenaIntegration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_INTEGRATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AthenaIntegration> athenaIntegrations;

    private IntegrateServices(BuilderImpl builder) {
        this.athenaIntegrations = builder.athenaIntegrations;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaIntegrations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAthenaIntegrations() {
        return athenaIntegrations != null && !(athenaIntegrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the integration with Amazon Athena.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaIntegrations} method.
     * </p>
     * 
     * @return Information about the integration with Amazon Athena.
     */
    public final List<AthenaIntegration> athenaIntegrations() {
        return athenaIntegrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaIntegrations() ? athenaIntegrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrateServices)) {
            return false;
        }
        IntegrateServices other = (IntegrateServices) obj;
        return hasAthenaIntegrations() == other.hasAthenaIntegrations()
                && Objects.equals(athenaIntegrations(), other.athenaIntegrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrateServices")
                .add("AthenaIntegrations", hasAthenaIntegrations() ? athenaIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AthenaIntegrations":
            return Optional.ofNullable(clazz.cast(athenaIntegrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegrateServices, T> g) {
        return obj -> g.apply((IntegrateServices) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrateServices> {
        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * 
         * @param athenaIntegrations
         *        Information about the integration with Amazon Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaIntegrations(Collection<AthenaIntegration> athenaIntegrations);

        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * 
         * @param athenaIntegrations
         *        Information about the integration with Amazon Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaIntegrations(AthenaIntegration... athenaIntegrations);

        /**
         * <p>
         * Information about the integration with Amazon Athena.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AthenaIntegration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.AthenaIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AthenaIntegration.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaIntegrations(List<AthenaIntegration>)}.
         * 
         * @param athenaIntegrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AthenaIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaIntegrations(java.util.Collection<AthenaIntegration>)
         */
        Builder athenaIntegrations(Consumer<AthenaIntegration.Builder>... athenaIntegrations);
    }

    static final class BuilderImpl implements Builder {
        private List<AthenaIntegration> athenaIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrateServices model) {
            athenaIntegrations(model.athenaIntegrations);
        }

        public final List<AthenaIntegration.Builder> getAthenaIntegrations() {
            List<AthenaIntegration.Builder> result = AthenaIntegrationsSetCopier.copyToBuilder(this.athenaIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAthenaIntegrations(Collection<AthenaIntegration.BuilderImpl> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copyFromBuilder(athenaIntegrations);
        }

        @Override
        public final Builder athenaIntegrations(Collection<AthenaIntegration> athenaIntegrations) {
            this.athenaIntegrations = AthenaIntegrationsSetCopier.copy(athenaIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(AthenaIntegration... athenaIntegrations) {
            athenaIntegrations(Arrays.asList(athenaIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder athenaIntegrations(Consumer<AthenaIntegration.Builder>... athenaIntegrations) {
            athenaIntegrations(Stream.of(athenaIntegrations).map(c -> AthenaIntegration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IntegrateServices build() {
            return new IntegrateServices(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
