/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransitGatewayPolicyTableAssociationsResponse extends Ec2Response
        implements
        ToCopyableBuilder<GetTransitGatewayPolicyTableAssociationsResponse.Builder, GetTransitGatewayPolicyTableAssociationsResponse> {
    private static final SdkField<List<TransitGatewayPolicyTableAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<TransitGatewayPolicyTableAssociation>> builder(MarshallingType.LIST)
            .memberName("Associations")
            .getter(getter(GetTransitGatewayPolicyTableAssociationsResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations")
                    .unmarshallLocationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayPolicyTableAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayPolicyTableAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetTransitGatewayPolicyTableAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TransitGatewayPolicyTableAssociation> associations;

    private final String nextToken;

    private GetTransitGatewayPolicyTableAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns details about the transit gateway policy table association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return Returns details about the transit gateway policy table association.
     */
    public final List<TransitGatewayPolicyTableAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayPolicyTableAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayPolicyTableAssociationsResponse other = (GetTransitGatewayPolicyTableAssociationsResponse) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransitGatewayPolicyTableAssociationsResponse")
                .add("Associations", hasAssociations() ? associations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayPolicyTableAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayPolicyTableAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransitGatewayPolicyTableAssociationsResponse> {
        /**
         * <p>
         * Returns details about the transit gateway policy table association.
         * </p>
         * 
         * @param associations
         *        Returns details about the transit gateway policy table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<TransitGatewayPolicyTableAssociation> associations);

        /**
         * <p>
         * Returns details about the transit gateway policy table association.
         * </p>
         * 
         * @param associations
         *        Returns details about the transit gateway policy table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(TransitGatewayPolicyTableAssociation... associations);

        /**
         * <p>
         * Returns details about the transit gateway policy table association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #associations(List<TransitGatewayPolicyTableAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<TransitGatewayPolicyTableAssociation>)
         */
        Builder associations(Consumer<TransitGatewayPolicyTableAssociation.Builder>... associations);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayPolicyTableAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayPolicyTableAssociationsResponse model) {
            super(model);
            associations(model.associations);
            nextToken(model.nextToken);
        }

        public final List<TransitGatewayPolicyTableAssociation.Builder> getAssociations() {
            List<TransitGatewayPolicyTableAssociation.Builder> result = TransitGatewayPolicyTableAssociationListCopier
                    .copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<TransitGatewayPolicyTableAssociation.BuilderImpl> associations) {
            this.associations = TransitGatewayPolicyTableAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<TransitGatewayPolicyTableAssociation> associations) {
            this.associations = TransitGatewayPolicyTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(TransitGatewayPolicyTableAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<TransitGatewayPolicyTableAssociation.Builder>... associations) {
            associations(Stream.of(associations)
                    .map(c -> TransitGatewayPolicyTableAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayPolicyTableAssociationsResponse build() {
            return new GetTransitGatewayPolicyTableAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
