/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyNetworkInterfaceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
    private static final SdkField<NetworkInterfaceAttachmentChanges> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::attachment)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::attachment)).constructor(NetworkInterfaceAttachmentChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::description)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::groups)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::networkInterfaceId)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyNetworkInterfaceAttributeRequest.getter(ModifyNetworkInterfaceAttributeRequest::sourceDestCheck)).setter(ModifyNetworkInterfaceAttributeRequest.setter(Builder::sourceDestCheck)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, NETWORK_INTERFACE_ID_FIELD, SOURCE_DEST_CHECK_FIELD));
    private final NetworkInterfaceAttachmentChanges attachment;
    private final AttributeValue description;
    private final List<String> groups;
    private final String networkInterfaceId;
    private final AttributeBooleanValue sourceDestCheck;

    private ModifyNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public NetworkInterfaceAttachmentChanges attachment() {
        return this.attachment;
    }

    public AttributeValue description() {
        return this.description;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public AttributeBooleanValue sourceDestCheck() {
        return this.sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest)((Object)obj);
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public String toString() {
        return ToString.builder((String)"ModifyNetworkInterfaceAttributeRequest").add("Attachment", (Object)this.attachment()).add("Description", (Object)this.description()).add("Groups", this.groups()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SourceDestCheck", (Object)this.sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyNetworkInterfaceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyNetworkInterfaceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private NetworkInterfaceAttachmentChanges attachment;
        private AttributeValue description;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private AttributeBooleanValue sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyNetworkInterfaceAttributeRequest model) {
            super(model);
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachmentChanges.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachmentChanges.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return this.sourceDestCheck != null ? this.sourceDestCheck.toBuilder() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyNetworkInterfaceAttributeRequest build() {
            return new ModifyNetworkInterfaceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
        public Builder attachment(NetworkInterfaceAttachmentChanges var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachmentChanges.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachmentChanges)((NetworkInterfaceAttachmentChanges.Builder)NetworkInterfaceAttachmentChanges.builder().applyMutation(attachment)).build());
        }

        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(AttributeBooleanValue var1);

        default public Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return this.sourceDestCheck((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(sourceDestCheck)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

