/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportInstanceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportInstanceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportInstanceRequest.getter(ImportInstanceRequest::description)).setter(ImportInstanceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<DiskImage>> DISK_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImportInstanceRequest.getter(ImportInstanceRequest::diskImages)).setter(ImportInstanceRequest.setter(Builder::diskImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImage").unmarshallLocationName("diskImage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImportInstanceLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImportInstanceRequest.getter(ImportInstanceRequest::launchSpecification)).setter(ImportInstanceRequest.setter(Builder::launchSpecification)).constructor(ImportInstanceLaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification").unmarshallLocationName("launchSpecification").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportInstanceRequest.getter(ImportInstanceRequest::platformAsString)).setter(ImportInstanceRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISK_IMAGES_FIELD, LAUNCH_SPECIFICATION_FIELD, PLATFORM_FIELD));
    private final String description;
    private final List<DiskImage> diskImages;
    private final ImportInstanceLaunchSpecification launchSpecification;
    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.diskImages = builder.diskImages;
        this.launchSpecification = builder.launchSpecification;
        this.platform = builder.platform;
    }

    public String description() {
        return this.description;
    }

    public List<DiskImage> diskImages() {
        return this.diskImages;
    }

    public ImportInstanceLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.diskImages(), other.diskImages()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public String toString() {
        return ToString.builder((String)"ImportInstanceRequest").add("Description", (Object)this.description()).add("DiskImages", this.diskImages()).add("LaunchSpecification", (Object)this.launchSpecification()).add("Platform", (Object)this.platformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskImages": {
                return Optional.ofNullable(clazz.cast(this.diskImages()));
            }
            case "LaunchSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchSpecification()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceRequest, T> g) {
        return obj -> g.apply((ImportInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private List<DiskImage> diskImages = DefaultSdkAutoConstructList.getInstance();
        private ImportInstanceLaunchSpecification launchSpecification;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            super(model);
            this.description(model.description);
            this.diskImages(model.diskImages);
            this.launchSpecification(model.launchSpecification);
            this.platform(model.platform);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DiskImage.Builder> getDiskImages() {
            return this.diskImages != null ? (Collection)this.diskImages.stream().map(DiskImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage ... diskImages) {
            this.diskImages(Arrays.asList(diskImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(Consumer<DiskImage.Builder> ... diskImages) {
            this.diskImages(Stream.of(diskImages).map(c -> (DiskImage)((DiskImage.Builder)DiskImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDiskImages(Collection<DiskImage.BuilderImpl> diskImages) {
            this.diskImages = DiskImageListCopier.copyFromBuilder(diskImages);
        }

        public final ImportInstanceLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportInstanceRequest> {
        public Builder description(String var1);

        public Builder diskImages(Collection<DiskImage> var1);

        public Builder diskImages(DiskImage ... var1);

        public Builder diskImages(Consumer<DiskImage.Builder> ... var1);

        public Builder launchSpecification(ImportInstanceLaunchSpecification var1);

        default public Builder launchSpecification(Consumer<ImportInstanceLaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((ImportInstanceLaunchSpecification)((ImportInstanceLaunchSpecification.Builder)ImportInstanceLaunchSpecification.builder().applyMutation(launchSpecification)).build());
        }

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

