/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AllocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityAllocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityAllocation> {
    private static final SdkField<String> ALLOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationType").getter(CapacityAllocation.getter(CapacityAllocation::allocationTypeAsString)).setter(CapacityAllocation.setter(Builder::allocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationType").unmarshallLocationName("allocationType").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(CapacityAllocation.getter(CapacityAllocation::count)).setter(CapacityAllocation.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_TYPE_FIELD, COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationType;
    private final Integer count;

    private CapacityAllocation(BuilderImpl builder) {
        this.allocationType = builder.allocationType;
        this.count = builder.count;
    }

    public final AllocationType allocationType() {
        return AllocationType.fromValue(this.allocationType);
    }

    public final String allocationTypeAsString() {
        return this.allocationType;
    }

    public final Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAllocation)) {
            return false;
        }
        CapacityAllocation other = (CapacityAllocation)obj;
        return Objects.equals(this.allocationTypeAsString(), other.allocationTypeAsString()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityAllocation").add("AllocationType", (Object)this.allocationTypeAsString()).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationType": {
                return Optional.ofNullable(clazz.cast(this.allocationTypeAsString()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityAllocation, T> g) {
        return obj -> g.apply((CapacityAllocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationType;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAllocation model) {
            this.allocationType(model.allocationType);
            this.count(model.count);
        }

        public final String getAllocationType() {
            return this.allocationType;
        }

        public final void setAllocationType(String allocationType) {
            this.allocationType = allocationType;
        }

        @Override
        public final Builder allocationType(String allocationType) {
            this.allocationType = allocationType;
            return this;
        }

        @Override
        public final Builder allocationType(AllocationType allocationType) {
            this.allocationType(allocationType == null ? null : allocationType.toString());
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public CapacityAllocation build() {
            return new CapacityAllocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityAllocation> {
        public Builder allocationType(String var1);

        public Builder allocationType(AllocationType var1);

        public Builder count(Integer var1);
    }
}

