/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RequestSpotInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestSpotInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<RequestSpotInstancesResponse.Builder, RequestSpotInstancesResponse> {
    private static final SdkField<List<SpotInstanceRequest>> SPOT_INSTANCE_REQUESTS_FIELD = SdkField
            .<List<SpotInstanceRequest>> builder(MarshallingType.LIST)
            .memberName("SpotInstanceRequests")
            .getter(getter(RequestSpotInstancesResponse::spotInstanceRequests))
            .setter(setter(Builder::spotInstanceRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet")
                    .unmarshallLocationName("spotInstanceRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotInstanceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotInstanceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUESTS_FIELD));

    private final List<SpotInstanceRequest> spotInstanceRequests;

    private RequestSpotInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the SpotInstanceRequests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpotInstanceRequests() {
        return spotInstanceRequests != null && !(spotInstanceRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Spot Instance requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpotInstanceRequests} method.
     * </p>
     * 
     * @return One or more Spot Instance requests.
     */
    public final List<SpotInstanceRequest> spotInstanceRequests() {
        return spotInstanceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSpotInstanceRequests() ? spotInstanceRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesResponse)) {
            return false;
        }
        RequestSpotInstancesResponse other = (RequestSpotInstancesResponse) obj;
        return hasSpotInstanceRequests() == other.hasSpotInstanceRequests()
                && Objects.equals(spotInstanceRequests(), other.spotInstanceRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestSpotInstancesResponse")
                .add("SpotInstanceRequests", hasSpotInstanceRequests() ? spotInstanceRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequests":
            return Optional.ofNullable(clazz.cast(spotInstanceRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotInstancesResponse, T> g) {
        return obj -> g.apply((RequestSpotInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RequestSpotInstancesResponse> {
        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests);

        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot Instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests);

        /**
         * <p>
         * One or more Spot Instance requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SpotInstanceRequest.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SpotInstanceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SpotInstanceRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #spotInstanceRequests(List<SpotInstanceRequest>)}.
         * 
         * @param spotInstanceRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SpotInstanceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotInstanceRequests(java.util.Collection<SpotInstanceRequest>)
         */
        Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder>... spotInstanceRequests);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesResponse model) {
            super(model);
            spotInstanceRequests(model.spotInstanceRequests);
        }

        public final List<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            List<SpotInstanceRequest.Builder> result = SpotInstanceRequestListCopier.copyToBuilder(this.spotInstanceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests) {
            spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder>... spotInstanceRequests) {
            spotInstanceRequests(Stream.of(spotInstanceRequests).map(c -> SpotInstanceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RequestSpotInstancesResponse build() {
            return new RequestSpotInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
