/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse;
import software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType;

public class GetVpnConnectionDeviceTypesIterable
implements SdkIterable<GetVpnConnectionDeviceTypesResponse> {
    private final Ec2Client client;
    private final GetVpnConnectionDeviceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetVpnConnectionDeviceTypesIterable(Ec2Client client, GetVpnConnectionDeviceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetVpnConnectionDeviceTypesResponseFetcher();
    }

    public Iterator<GetVpnConnectionDeviceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpnConnectionDeviceType> vpnConnectionDeviceTypes() {
        Function<GetVpnConnectionDeviceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpnConnectionDeviceTypes() != null) {
                return response.vpnConnectionDeviceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetVpnConnectionDeviceTypesResponseFetcher
    implements SyncPageFetcher<GetVpnConnectionDeviceTypesResponse> {
        private GetVpnConnectionDeviceTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetVpnConnectionDeviceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetVpnConnectionDeviceTypesResponse nextPage(GetVpnConnectionDeviceTypesResponse previousPage) {
            if (previousPage == null) {
                return GetVpnConnectionDeviceTypesIterable.this.client.getVpnConnectionDeviceTypes(GetVpnConnectionDeviceTypesIterable.this.firstRequest);
            }
            return GetVpnConnectionDeviceTypesIterable.this.client.getVpnConnectionDeviceTypes((GetVpnConnectionDeviceTypesRequest)((Object)GetVpnConnectionDeviceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

