/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FlowLogResourceIdsCopier;
import software.amazon.awssdk.services.ec2.model.FlowLogsResourceType;
import software.amazon.awssdk.services.ec2.model.LogDestinationType;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowLogsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateFlowLogsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::clientToken)).setter(CreateFlowLogsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<String> DELIVER_LOGS_PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliverLogsPermissionArn").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::deliverLogsPermissionArn)).setter(CreateFlowLogsRequest.setter(Builder::deliverLogsPermissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsPermissionArn").unmarshallLocationName("DeliverLogsPermissionArn").build()}).build();
    private static final SdkField<String> DELIVER_CROSS_ACCOUNT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliverCrossAccountRole").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::deliverCrossAccountRole)).setter(CreateFlowLogsRequest.setter(Builder::deliverCrossAccountRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverCrossAccountRole").unmarshallLocationName("DeliverCrossAccountRole").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logGroupName)).setter(CreateFlowLogsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").unmarshallLocationName("LogGroupName").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIds").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::resourceIds)).setter(CreateFlowLogsRequest.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("ResourceId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::resourceTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficType").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::trafficTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").unmarshallLocationName("TrafficType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDestinationType").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logDestinationTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::logDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").unmarshallLocationName("LogDestinationType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDestination").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logDestination)).setter(CreateFlowLogsRequest.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").unmarshallLocationName("LogDestination").build()}).build();
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFormat").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logFormat)).setter(CreateFlowLogsRequest.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").unmarshallLocationName("LogFormat").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::tagSpecifications)).setter(CreateFlowLogsRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_AGGREGATION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAggregationInterval").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::maxAggregationInterval)).setter(CreateFlowLogsRequest.setter(Builder::maxAggregationInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAggregationInterval").unmarshallLocationName("MaxAggregationInterval").build()}).build();
    private static final SdkField<DestinationOptionsRequest> DESTINATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationOptions").getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::destinationOptions)).setter(CreateFlowLogsRequest.setter(Builder::destinationOptions)).constructor(DestinationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").unmarshallLocationName("DestinationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DELIVER_LOGS_PERMISSION_ARN_FIELD, DELIVER_CROSS_ACCOUNT_ROLE_FIELD, LOG_GROUP_NAME_FIELD, RESOURCE_IDS_FIELD, RESOURCE_TYPE_FIELD, TRAFFIC_TYPE_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_DESTINATION_FIELD, LOG_FORMAT_FIELD, TAG_SPECIFICATIONS_FIELD, MAX_AGGREGATION_INTERVAL_FIELD, DESTINATION_OPTIONS_FIELD));
    private final String clientToken;
    private final String deliverLogsPermissionArn;
    private final String deliverCrossAccountRole;
    private final String logGroupName;
    private final List<String> resourceIds;
    private final String resourceType;
    private final String trafficType;
    private final String logDestinationType;
    private final String logDestination;
    private final String logFormat;
    private final List<TagSpecification> tagSpecifications;
    private final Integer maxAggregationInterval;
    private final DestinationOptionsRequest destinationOptions;

    private CreateFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.deliverCrossAccountRole = builder.deliverCrossAccountRole;
        this.logGroupName = builder.logGroupName;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.trafficType = builder.trafficType;
        this.logDestinationType = builder.logDestinationType;
        this.logDestination = builder.logDestination;
        this.logFormat = builder.logFormat;
        this.tagSpecifications = builder.tagSpecifications;
        this.maxAggregationInterval = builder.maxAggregationInterval;
        this.destinationOptions = builder.destinationOptions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String deliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public final String deliverCrossAccountRole() {
        return this.deliverCrossAccountRole;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIds() {
        return this.resourceIds;
    }

    public final FlowLogsResourceType resourceType() {
        return FlowLogsResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public final String trafficTypeAsString() {
        return this.trafficType;
    }

    public final LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(this.logDestinationType);
    }

    public final String logDestinationTypeAsString() {
        return this.logDestinationType;
    }

    public final String logDestination() {
        return this.logDestination;
    }

    public final String logFormat() {
        return this.logFormat;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Integer maxAggregationInterval() {
        return this.maxAggregationInterval;
    }

    public final DestinationOptionsRequest destinationOptions() {
        return this.destinationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverCrossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAggregationInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deliverLogsPermissionArn(), other.deliverLogsPermissionArn()) && Objects.equals(this.deliverCrossAccountRole(), other.deliverCrossAccountRole()) && Objects.equals(this.logGroupName(), other.logGroupName()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString()) && Objects.equals(this.logDestinationTypeAsString(), other.logDestinationTypeAsString()) && Objects.equals(this.logDestination(), other.logDestination()) && Objects.equals(this.logFormat(), other.logFormat()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.maxAggregationInterval(), other.maxAggregationInterval()) && Objects.equals(this.destinationOptions(), other.destinationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFlowLogsRequest").add("ClientToken", (Object)this.clientToken()).add("DeliverLogsPermissionArn", (Object)this.deliverLogsPermissionArn()).add("DeliverCrossAccountRole", (Object)this.deliverCrossAccountRole()).add("LogGroupName", (Object)this.logGroupName()).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("ResourceType", (Object)this.resourceTypeAsString()).add("TrafficType", (Object)this.trafficTypeAsString()).add("LogDestinationType", (Object)this.logDestinationTypeAsString()).add("LogDestination", (Object)this.logDestination()).add("LogFormat", (Object)this.logFormat()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("MaxAggregationInterval", (Object)this.maxAggregationInterval()).add("DestinationOptions", (Object)this.destinationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DeliverLogsPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsPermissionArn()));
            }
            case "DeliverCrossAccountRole": {
                return Optional.ofNullable(clazz.cast(this.deliverCrossAccountRole()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
            case "LogDestinationType": {
                return Optional.ofNullable(clazz.cast(this.logDestinationTypeAsString()));
            }
            case "LogDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestination()));
            }
            case "LogFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormat()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "MaxAggregationInterval": {
                return Optional.ofNullable(clazz.cast(this.maxAggregationInterval()));
            }
            case "DestinationOptions": {
                return Optional.ofNullable(clazz.cast(this.destinationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowLogsRequest, T> g) {
        return obj -> g.apply((CreateFlowLogsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deliverLogsPermissionArn;
        private String deliverCrossAccountRole;
        private String logGroupName;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private String trafficType;
        private String logDestinationType;
        private String logDestination;
        private String logFormat;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAggregationInterval;
        private DestinationOptionsRequest destinationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            this.deliverCrossAccountRole(model.deliverCrossAccountRole);
            this.logGroupName(model.logGroupName);
            this.resourceIds(model.resourceIds);
            this.resourceType(model.resourceType);
            this.trafficType(model.trafficType);
            this.logDestinationType(model.logDestinationType);
            this.logDestination(model.logDestination);
            this.logFormat(model.logFormat);
            this.tagSpecifications(model.tagSpecifications);
            this.maxAggregationInterval(model.maxAggregationInterval);
            this.destinationOptions(model.destinationOptions);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final String getDeliverCrossAccountRole() {
            return this.deliverCrossAccountRole;
        }

        public final void setDeliverCrossAccountRole(String deliverCrossAccountRole) {
            this.deliverCrossAccountRole = deliverCrossAccountRole;
        }

        @Override
        public final Builder deliverCrossAccountRole(String deliverCrossAccountRole) {
            this.deliverCrossAccountRole = deliverCrossAccountRole;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = FlowLogResourceIdsCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = FlowLogResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FlowLogsResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final String getLogDestinationType() {
            return this.logDestinationType;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final String getLogDestination() {
            return this.logDestination;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        public final void setMaxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
        }

        @Override
        public final Builder maxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        public final DestinationOptionsRequest.Builder getDestinationOptions() {
            return this.destinationOptions != null ? this.destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(DestinationOptionsRequest.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(DestinationOptionsRequest destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowLogsRequest build() {
            return new CreateFlowLogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowLogsRequest> {
        public Builder clientToken(String var1);

        public Builder deliverLogsPermissionArn(String var1);

        public Builder deliverCrossAccountRole(String var1);

        public Builder logGroupName(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FlowLogsResourceType var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder logDestinationType(String var1);

        public Builder logDestinationType(LogDestinationType var1);

        public Builder logDestination(String var1);

        public Builder logFormat(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder maxAggregationInterval(Integer var1);

        public Builder destinationOptions(DestinationOptionsRequest var1);

        default public Builder destinationOptions(Consumer<DestinationOptionsRequest.Builder> destinationOptions) {
            return this.destinationOptions((DestinationOptionsRequest)((DestinationOptionsRequest.Builder)DestinationOptionsRequest.builder().applyMutation(destinationOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

