/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpamResourceCidrRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyIpamResourceCidrRequest.Builder, ModifyIpamResourceCidrRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(ModifyIpamResourceCidrRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceCidr")
            .getter(getter(ModifyIpamResourceCidrRequest::resourceCidr))
            .setter(setter(Builder::resourceCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr")
                    .unmarshallLocationName("ResourceCidr").build()).build();

    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceRegion")
            .getter(getter(ModifyIpamResourceCidrRequest::resourceRegion))
            .setter(setter(Builder::resourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion")
                    .unmarshallLocationName("ResourceRegion").build()).build();

    private static final SdkField<String> CURRENT_IPAM_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentIpamScopeId")
            .getter(getter(ModifyIpamResourceCidrRequest::currentIpamScopeId))
            .setter(setter(Builder::currentIpamScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentIpamScopeId")
                    .unmarshallLocationName("CurrentIpamScopeId").build()).build();

    private static final SdkField<String> DESTINATION_IPAM_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationIpamScopeId")
            .getter(getter(ModifyIpamResourceCidrRequest::destinationIpamScopeId))
            .setter(setter(Builder::destinationIpamScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpamScopeId")
                    .unmarshallLocationName("DestinationIpamScopeId").build()).build();

    private static final SdkField<Boolean> MONITORED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Monitored")
            .getter(getter(ModifyIpamResourceCidrRequest::monitored))
            .setter(setter(Builder::monitored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitored")
                    .unmarshallLocationName("Monitored").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_CIDR_FIELD, RESOURCE_REGION_FIELD, CURRENT_IPAM_SCOPE_ID_FIELD, DESTINATION_IPAM_SCOPE_ID_FIELD,
            MONITORED_FIELD));

    private final String resourceId;

    private final String resourceCidr;

    private final String resourceRegion;

    private final String currentIpamScopeId;

    private final String destinationIpamScopeId;

    private final Boolean monitored;

    private ModifyIpamResourceCidrRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceCidr = builder.resourceCidr;
        this.resourceRegion = builder.resourceRegion;
        this.currentIpamScopeId = builder.currentIpamScopeId;
        this.destinationIpamScopeId = builder.destinationIpamScopeId;
        this.monitored = builder.monitored;
    }

    /**
     * <p>
     * The ID of the resource you want to modify.
     * </p>
     * 
     * @return The ID of the resource you want to modify.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The CIDR of the resource you want to modify.
     * </p>
     * 
     * @return The CIDR of the resource you want to modify.
     */
    public final String resourceCidr() {
        return resourceCidr;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the resource you want to modify.
     * </p>
     * 
     * @return The Amazon Web Services Region of the resource you want to modify.
     */
    public final String resourceRegion() {
        return resourceRegion;
    }

    /**
     * <p>
     * The ID of the current scope that the resource CIDR is in.
     * </p>
     * 
     * @return The ID of the current scope that the resource CIDR is in.
     */
    public final String currentIpamScopeId() {
        return currentIpamScopeId;
    }

    /**
     * <p>
     * The ID of the scope you want to transfer the resource CIDR to.
     * </p>
     * 
     * @return The ID of the scope you want to transfer the resource CIDR to.
     */
    public final String destinationIpamScopeId() {
        return destinationIpamScopeId;
    }

    /**
     * <p>
     * Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is discovered by IPAM
     * and you can view details about the resource’s CIDR.
     * </p>
     * 
     * @return Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is discovered
     *         by IPAM and you can view details about the resource’s CIDR.
     */
    public final Boolean monitored() {
        return monitored;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(currentIpamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(monitored());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamResourceCidrRequest)) {
            return false;
        }
        ModifyIpamResourceCidrRequest other = (ModifyIpamResourceCidrRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceCidr(), other.resourceCidr())
                && Objects.equals(resourceRegion(), other.resourceRegion())
                && Objects.equals(currentIpamScopeId(), other.currentIpamScopeId())
                && Objects.equals(destinationIpamScopeId(), other.destinationIpamScopeId())
                && Objects.equals(monitored(), other.monitored());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpamResourceCidrRequest").add("ResourceId", resourceId())
                .add("ResourceCidr", resourceCidr()).add("ResourceRegion", resourceRegion())
                .add("CurrentIpamScopeId", currentIpamScopeId()).add("DestinationIpamScopeId", destinationIpamScopeId())
                .add("Monitored", monitored()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceCidr":
            return Optional.ofNullable(clazz.cast(resourceCidr()));
        case "ResourceRegion":
            return Optional.ofNullable(clazz.cast(resourceRegion()));
        case "CurrentIpamScopeId":
            return Optional.ofNullable(clazz.cast(currentIpamScopeId()));
        case "DestinationIpamScopeId":
            return Optional.ofNullable(clazz.cast(destinationIpamScopeId()));
        case "Monitored":
            return Optional.ofNullable(clazz.cast(monitored()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamResourceCidrRequest, T> g) {
        return obj -> g.apply((ModifyIpamResourceCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIpamResourceCidrRequest> {
        /**
         * <p>
         * The ID of the resource you want to modify.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The CIDR of the resource you want to modify.
         * </p>
         * 
         * @param resourceCidr
         *        The CIDR of the resource you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCidr(String resourceCidr);

        /**
         * <p>
         * The Amazon Web Services Region of the resource you want to modify.
         * </p>
         * 
         * @param resourceRegion
         *        The Amazon Web Services Region of the resource you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRegion(String resourceRegion);

        /**
         * <p>
         * The ID of the current scope that the resource CIDR is in.
         * </p>
         * 
         * @param currentIpamScopeId
         *        The ID of the current scope that the resource CIDR is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentIpamScopeId(String currentIpamScopeId);

        /**
         * <p>
         * The ID of the scope you want to transfer the resource CIDR to.
         * </p>
         * 
         * @param destinationIpamScopeId
         *        The ID of the scope you want to transfer the resource CIDR to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpamScopeId(String destinationIpamScopeId);

        /**
         * <p>
         * Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is discovered by
         * IPAM and you can view details about the resource’s CIDR.
         * </p>
         * 
         * @param monitored
         *        Determines if the resource is monitored by IPAM. If a resource is monitored, the resource is
         *        discovered by IPAM and you can view details about the resource’s CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitored(Boolean monitored);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceCidr;

        private String resourceRegion;

        private String currentIpamScopeId;

        private String destinationIpamScopeId;

        private Boolean monitored;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamResourceCidrRequest model) {
            super(model);
            resourceId(model.resourceId);
            resourceCidr(model.resourceCidr);
            resourceRegion(model.resourceRegion);
            currentIpamScopeId(model.currentIpamScopeId);
            destinationIpamScopeId(model.destinationIpamScopeId);
            monitored(model.monitored);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceCidr() {
            return resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceRegion() {
            return resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getCurrentIpamScopeId() {
            return currentIpamScopeId;
        }

        public final void setCurrentIpamScopeId(String currentIpamScopeId) {
            this.currentIpamScopeId = currentIpamScopeId;
        }

        @Override
        public final Builder currentIpamScopeId(String currentIpamScopeId) {
            this.currentIpamScopeId = currentIpamScopeId;
            return this;
        }

        public final String getDestinationIpamScopeId() {
            return destinationIpamScopeId;
        }

        public final void setDestinationIpamScopeId(String destinationIpamScopeId) {
            this.destinationIpamScopeId = destinationIpamScopeId;
        }

        @Override
        public final Builder destinationIpamScopeId(String destinationIpamScopeId) {
            this.destinationIpamScopeId = destinationIpamScopeId;
            return this;
        }

        public final Boolean getMonitored() {
            return monitored;
        }

        public final void setMonitored(Boolean monitored) {
            this.monitored = monitored;
        }

        @Override
        public final Builder monitored(Boolean monitored) {
            this.monitored = monitored;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamResourceCidrRequest build() {
            return new ModifyIpamResourceCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
