/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTransitGatewayRouteTableAnnouncementRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeleteTransitGatewayRouteTableAnnouncementRequest.Builder, DeleteTransitGatewayRouteTableAnnouncementRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableAnnouncementId")
            .getter(getter(DeleteTransitGatewayRouteTableAnnouncementRequest::transitGatewayRouteTableAnnouncementId))
            .setter(setter(Builder::transitGatewayRouteTableAnnouncementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransitGatewayRouteTableAnnouncementId")
                    .unmarshallLocationName("TransitGatewayRouteTableAnnouncementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD));

    private final String transitGatewayRouteTableAnnouncementId;

    private DeleteTransitGatewayRouteTableAnnouncementRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableAnnouncementId = builder.transitGatewayRouteTableAnnouncementId;
    }

    /**
     * <p>
     * The transit gateway route table ID that's being deleted.
     * </p>
     * 
     * @return The transit gateway route table ID that's being deleted.
     */
    public final String transitGatewayRouteTableAnnouncementId() {
        return transitGatewayRouteTableAnnouncementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableAnnouncementId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTransitGatewayRouteTableAnnouncementRequest)) {
            return false;
        }
        DeleteTransitGatewayRouteTableAnnouncementRequest other = (DeleteTransitGatewayRouteTableAnnouncementRequest) obj;
        return Objects.equals(transitGatewayRouteTableAnnouncementId(), other.transitGatewayRouteTableAnnouncementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTransitGatewayRouteTableAnnouncementRequest")
                .add("TransitGatewayRouteTableAnnouncementId", transitGatewayRouteTableAnnouncementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableAnnouncementId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableAnnouncementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTransitGatewayRouteTableAnnouncementRequest, T> g) {
        return obj -> g.apply((DeleteTransitGatewayRouteTableAnnouncementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTransitGatewayRouteTableAnnouncementRequest> {
        /**
         * <p>
         * The transit gateway route table ID that's being deleted.
         * </p>
         * 
         * @param transitGatewayRouteTableAnnouncementId
         *        The transit gateway route table ID that's being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayRouteTableAnnouncementId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTransitGatewayRouteTableAnnouncementRequest model) {
            super(model);
            transitGatewayRouteTableAnnouncementId(model.transitGatewayRouteTableAnnouncementId);
        }

        public final String getTransitGatewayRouteTableAnnouncementId() {
            return transitGatewayRouteTableAnnouncementId;
        }

        public final void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTransitGatewayRouteTableAnnouncementRequest build() {
            return new DeleteTransitGatewayRouteTableAnnouncementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
