/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the multicast domain associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMulticastDomainAssociations implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMulticastDomainAssociations.Builder, TransitGatewayMulticastDomainAssociations> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMulticastDomainId")
            .getter(getter(TransitGatewayMulticastDomainAssociations::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .unmarshallLocationName("transitGatewayMulticastDomainId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(TransitGatewayMulticastDomainAssociations::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceId")
            .getter(getter(TransitGatewayMulticastDomainAssociations::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(TransitGatewayMulticastDomainAssociations::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwnerId")
            .getter(getter(TransitGatewayMulticastDomainAssociations::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId")
                    .unmarshallLocationName("resourceOwnerId").build()).build();

    private static final SdkField<List<SubnetAssociation>> SUBNETS_FIELD = SdkField
            .<List<SubnetAssociation>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(TransitGatewayMulticastDomainAssociations::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets")
                    .unmarshallLocationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ID_FIELD, SUBNETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayMulticastDomainId;

    private final String transitGatewayAttachmentId;

    private final String resourceId;

    private final String resourceType;

    private final String resourceOwnerId;

    private final List<SubnetAssociation> subnets;

    private TransitGatewayMulticastDomainAssociations(BuilderImpl builder) {
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.subnets = builder.subnets;
    }

    /**
     * <p>
     * The ID of the transit gateway multicast domain.
     * </p>
     * 
     * @return The ID of the transit gateway multicast domain.
     */
    public final String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * <p>
     * The ID of the transit gateway attachment.
     * </p>
     * 
     * @return The ID of the transit gateway attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the resource.
     */
    public final String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets associated with the multicast domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The subnets associated with the multicast domain.
     */
    public final List<SubnetAssociation> subnets() {
        return subnets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDomainAssociations)) {
            return false;
        }
        TransitGatewayMulticastDomainAssociations other = (TransitGatewayMulticastDomainAssociations) obj;
        return Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceOwnerId(), other.resourceOwnerId()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayMulticastDomainAssociations")
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).add("ResourceOwnerId", resourceOwnerId())
                .add("Subnets", hasSubnets() ? subnets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDomainAssociations, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDomainAssociations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMulticastDomainAssociations> {
        /**
         * <p>
         * The ID of the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        The ID of the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * The ID of the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the resource.
         * </p>
         * 
         * @param resourceOwnerId
         *        The ID of the Amazon Web Services account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * The subnets associated with the multicast domain.
         * </p>
         * 
         * @param subnets
         *        The subnets associated with the multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<SubnetAssociation> subnets);

        /**
         * <p>
         * The subnets associated with the multicast domain.
         * </p>
         * 
         * @param subnets
         *        The subnets associated with the multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(SubnetAssociation... subnets);

        /**
         * <p>
         * The subnets associated with the multicast domain.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubnetAssociation>.Builder} avoiding the
         * need to create one manually via {@link List<SubnetAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubnetAssociation>.Builder#build()} is called immediately
         * and its result is passed to {@link #subnets(List<SubnetAssociation>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on {@link List<SubnetAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(List<SubnetAssociation>)
         */
        Builder subnets(Consumer<SubnetAssociation.Builder>... subnets);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayMulticastDomainId;

        private String transitGatewayAttachmentId;

        private String resourceId;

        private String resourceType;

        private String resourceOwnerId;

        private List<SubnetAssociation> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDomainAssociations model) {
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            resourceOwnerId(model.resourceOwnerId);
            subnets(model.subnets);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        @Transient
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        @Transient
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final List<SubnetAssociation.Builder> getSubnets() {
            List<SubnetAssociation.Builder> result = SubnetAssociationListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<SubnetAssociation.BuilderImpl> subnets) {
            this.subnets = SubnetAssociationListCopier.copyFromBuilder(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<SubnetAssociation> subnets) {
            this.subnets = SubnetAssociationListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(SubnetAssociation... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(Consumer<SubnetAssociation.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> SubnetAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayMulticastDomainAssociations build() {
            return new TransitGatewayMulticastDomainAssociations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
