/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv6 address associated with a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfaceIpv6Address implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfaceIpv6Address.Builder, NetworkInterfaceIpv6Address> {
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Address")
            .getter(getter(NetworkInterfaceIpv6Address::ipv6Address))
            .setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address")
                    .unmarshallLocationName("ipv6Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipv6Address;

    private NetworkInterfaceIpv6Address(BuilderImpl builder) {
        this.ipv6Address = builder.ipv6Address;
    }

    /**
     * <p>
     * The IPv6 address.
     * </p>
     * 
     * @return The IPv6 address.
     */
    public final String ipv6Address() {
        return ipv6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceIpv6Address)) {
            return false;
        }
        NetworkInterfaceIpv6Address other = (NetworkInterfaceIpv6Address) obj;
        return Objects.equals(ipv6Address(), other.ipv6Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterfaceIpv6Address").add("Ipv6Address", ipv6Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceIpv6Address, T> g) {
        return obj -> g.apply((NetworkInterfaceIpv6Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfaceIpv6Address> {
        /**
         * <p>
         * The IPv6 address.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);
    }

    static final class BuilderImpl implements Builder {
        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceIpv6Address model) {
            ipv6Address(model.ipv6Address);
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        @Transient
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        @Override
        public NetworkInterfaceIpv6Address build() {
            return new NetworkInterfaceIpv6Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
