/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointRequest.Builder, ModifyVpcEndpointRequest> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(ModifyVpcEndpointRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("VpcEndpointId").build()).build();

    private static final SdkField<Boolean> RESET_POLICY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetPolicy")
            .getter(getter(ModifyVpcEndpointRequest::resetPolicy))
            .setter(setter(Builder::resetPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetPolicy")
                    .unmarshallLocationName("ResetPolicy").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(ModifyVpcEndpointRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("PolicyDocument").build()).build();

    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddRouteTableIds")
            .getter(getter(ModifyVpcEndpointRequest::addRouteTableIds))
            .setter(setter(Builder::addRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableId")
                    .unmarshallLocationName("AddRouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveRouteTableIds")
            .getter(getter(ModifyVpcEndpointRequest::removeRouteTableIds))
            .setter(setter(Builder::removeRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableId")
                    .unmarshallLocationName("RemoveRouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSubnetIds")
            .getter(getter(ModifyVpcEndpointRequest::addSubnetIds))
            .setter(setter(Builder::addSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetId")
                    .unmarshallLocationName("AddSubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSubnetIds")
            .getter(getter(ModifyVpcEndpointRequest::removeSubnetIds))
            .setter(setter(Builder::removeSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetId")
                    .unmarshallLocationName("RemoveSubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSecurityGroupIds")
            .getter(getter(ModifyVpcEndpointRequest::addSecurityGroupIds))
            .setter(setter(Builder::addSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSecurityGroupId")
                    .unmarshallLocationName("AddSecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSecurityGroupIds")
            .getter(getter(ModifyVpcEndpointRequest::removeSecurityGroupIds))
            .setter(setter(Builder::removeSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSecurityGroupId")
                    .unmarshallLocationName("RemoveSecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivateDnsEnabled")
            .getter(getter(ModifyVpcEndpointRequest::privateDnsEnabled))
            .setter(setter(Builder::privateDnsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled")
                    .unmarshallLocationName("PrivateDnsEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD,
            RESET_POLICY_FIELD, POLICY_DOCUMENT_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD,
            ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD, REMOVE_SECURITY_GROUP_IDS_FIELD,
            PRIVATE_DNS_ENABLED_FIELD));

    private final String vpcEndpointId;

    private final Boolean resetPolicy;

    private final String policyDocument;

    private final List<String> addRouteTableIds;

    private final List<String> removeRouteTableIds;

    private final List<String> addSubnetIds;

    private final List<String> removeSubnetIds;

    private final List<String> addSecurityGroupIds;

    private final List<String> removeSecurityGroupIds;

    private final Boolean privateDnsEnabled;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.privateDnsEnabled = builder.privateDnsEnabled;
    }

    /**
     * <p>
     * The ID of the endpoint.
     * </p>
     * 
     * @return The ID of the endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
     * policy allows full access to the service.
     * </p>
     * 
     * @return (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
     *         default policy allows full access to the service.
     */
    public final Boolean resetPolicy() {
        return resetPolicy;
    }

    /**
     * <p>
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
     * policy must be in valid JSON format.
     * </p>
     * 
     * @return (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service.
     *         The policy must be in valid JSON format.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddRouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddRouteTableIds() {
        return addRouteTableIds != null && !(addRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddRouteTableIds} method.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
     */
    public final List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveRouteTableIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveRouteTableIds() {
        return removeRouteTableIds != null && !(removeRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveRouteTableIds} method.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
     */
    public final List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSubnetIds() {
        return addSubnetIds != null && !(addSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a
     * Gateway Load Balancer endpoint, you can specify only one subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnetIds} method.
     * </p>
     * 
     * @return (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint.
     *         For a Gateway Load Balancer endpoint, you can specify only one subnet.
     */
    public final List<String> addSubnetIds() {
        return addSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnetIds() {
        return removeSubnetIds != null && !(removeSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnetIds} method.
     * </p>
     * 
     * @return (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
     */
    public final List<String> removeSubnetIds() {
        return removeSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSecurityGroupIds() {
        return addSecurityGroupIds != null && !(addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) One or more security group IDs to associate with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSecurityGroupIds} method.
     * </p>
     * 
     * @return (Interface endpoint) One or more security group IDs to associate with the network interface.
     */
    public final List<String> addSecurityGroupIds() {
        return addSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSecurityGroupIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveSecurityGroupIds() {
        return removeSecurityGroupIds != null && !(removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSecurityGroupIds} method.
     * </p>
     * 
     * @return (Interface endpoint) One or more security group IDs to disassociate from the network interface.
     */
    public final List<String> removeSecurityGroupIds() {
        return removeSecurityGroupIds;
    }

    /**
     * <p>
     * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
     * </p>
     * 
     * @return (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
     */
    public final Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddRouteTableIds() ? addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveRouteTableIds() ? removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnetIds() ? addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnetIds() ? removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSecurityGroupIds() ? addSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(resetPolicy(), other.resetPolicy())
                && Objects.equals(policyDocument(), other.policyDocument())
                && hasAddRouteTableIds() == other.hasAddRouteTableIds()
                && Objects.equals(addRouteTableIds(), other.addRouteTableIds())
                && hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds()
                && Objects.equals(removeRouteTableIds(), other.removeRouteTableIds())
                && hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(addSubnetIds(), other.addSubnetIds())
                && hasRemoveSubnetIds() == other.hasRemoveSubnetIds()
                && Objects.equals(removeSubnetIds(), other.removeSubnetIds())
                && hasAddSecurityGroupIds() == other.hasAddSecurityGroupIds()
                && Objects.equals(addSecurityGroupIds(), other.addSecurityGroupIds())
                && hasRemoveSecurityGroupIds() == other.hasRemoveSecurityGroupIds()
                && Objects.equals(removeSecurityGroupIds(), other.removeSecurityGroupIds())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEndpointRequest").add("VpcEndpointId", vpcEndpointId())
                .add("ResetPolicy", resetPolicy()).add("PolicyDocument", policyDocument())
                .add("AddRouteTableIds", hasAddRouteTableIds() ? addRouteTableIds() : null)
                .add("RemoveRouteTableIds", hasRemoveRouteTableIds() ? removeRouteTableIds() : null)
                .add("AddSubnetIds", hasAddSubnetIds() ? addSubnetIds() : null)
                .add("RemoveSubnetIds", hasRemoveSubnetIds() ? removeSubnetIds() : null)
                .add("AddSecurityGroupIds", hasAddSecurityGroupIds() ? addSecurityGroupIds() : null)
                .add("RemoveSecurityGroupIds", hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null)
                .add("PrivateDnsEnabled", privateDnsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "ResetPolicy":
            return Optional.ofNullable(clazz.cast(resetPolicy()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "AddRouteTableIds":
            return Optional.ofNullable(clazz.cast(addRouteTableIds()));
        case "RemoveRouteTableIds":
            return Optional.ofNullable(clazz.cast(removeRouteTableIds()));
        case "AddSubnetIds":
            return Optional.ofNullable(clazz.cast(addSubnetIds()));
        case "RemoveSubnetIds":
            return Optional.ofNullable(clazz.cast(removeSubnetIds()));
        case "AddSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(addSecurityGroupIds()));
        case "RemoveSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(removeSecurityGroupIds()));
        case "PrivateDnsEnabled":
            return Optional.ofNullable(clazz.cast(privateDnsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        /**
         * <p>
         * The ID of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
         * policy allows full access to the service.
         * </p>
         * 
         * @param resetPolicy
         *        (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
         *        default policy allows full access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetPolicy(Boolean resetPolicy);

        /**
         * <p>
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
         * policy must be in valid JSON format.
         * </p>
         * 
         * @param policyDocument
         *        (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
         *        service. The policy must be in valid JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a
         * Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint.
         *        For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(Collection<String> addSubnetIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a
         * Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint.
         *        For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(String... addSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(Collection<String> removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(String... removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to associate with the network interface.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to associate with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to associate with the network interface.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to associate with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(String... addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(String... removeSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpcEndpointId;

        private Boolean resetPolicy;

        private String policyDocument;

        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean privateDnsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            super(model);
            vpcEndpointId(model.vpcEndpointId);
            resetPolicy(model.resetPolicy);
            policyDocument(model.policyDocument);
            addRouteTableIds(model.addRouteTableIds);
            removeRouteTableIds(model.removeRouteTableIds);
            addSubnetIds(model.addSubnetIds);
            removeSubnetIds(model.removeSubnetIds);
            addSecurityGroupIds(model.addSecurityGroupIds);
            removeSecurityGroupIds(model.removeSecurityGroupIds);
            privateDnsEnabled(model.privateDnsEnabled);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        @Transient
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Boolean getResetPolicy() {
            return resetPolicy;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        @Override
        @Transient
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        @Transient
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
        }

        @Override
        @Transient
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
        }

        @Override
        @Transient
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
        }

        @Override
        @Transient
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSubnetIds(String... addSubnetIds) {
            addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
        }

        @Override
        @Transient
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSubnetIds(String... removeSubnetIds) {
            removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final Collection<String> getAddSecurityGroupIds() {
            if (addSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSecurityGroupIds;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
        }

        @Override
        @Transient
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSecurityGroupIds(String... addSecurityGroupIds) {
            addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            if (removeSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSecurityGroupIds;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
        }

        @Override
        @Transient
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String... removeSecurityGroupIds) {
            removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        @Transient
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
