/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVolumeResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVolumeResponse.Builder, ModifyVolumeResponse> {
    private static final SdkField<VolumeModification> VOLUME_MODIFICATION_FIELD = SdkField
            .<VolumeModification> builder(MarshallingType.SDK_POJO)
            .memberName("VolumeModification")
            .getter(getter(ModifyVolumeResponse::volumeModification))
            .setter(setter(Builder::volumeModification))
            .constructor(VolumeModification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeModification")
                    .unmarshallLocationName("volumeModification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_MODIFICATION_FIELD));

    private final VolumeModification volumeModification;

    private ModifyVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeModification = builder.volumeModification;
    }

    /**
     * <p>
     * Information about the volume modification.
     * </p>
     * 
     * @return Information about the volume modification.
     */
    public final VolumeModification volumeModification() {
        return volumeModification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeModification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeResponse)) {
            return false;
        }
        ModifyVolumeResponse other = (ModifyVolumeResponse) obj;
        return Objects.equals(volumeModification(), other.volumeModification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVolumeResponse").add("VolumeModification", volumeModification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeModification":
            return Optional.ofNullable(clazz.cast(volumeModification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVolumeResponse, T> g) {
        return obj -> g.apply((ModifyVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVolumeResponse> {
        /**
         * <p>
         * Information about the volume modification.
         * </p>
         * 
         * @param volumeModification
         *        Information about the volume modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeModification(VolumeModification volumeModification);

        /**
         * <p>
         * Information about the volume modification.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeModification.Builder} avoiding the need to
         * create one manually via {@link VolumeModification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeModification.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeModification(VolumeModification)}.
         * 
         * @param volumeModification
         *        a consumer that will call methods on {@link VolumeModification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeModification(VolumeModification)
         */
        default Builder volumeModification(Consumer<VolumeModification.Builder> volumeModification) {
            return volumeModification(VolumeModification.builder().applyMutation(volumeModification).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VolumeModification volumeModification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeResponse model) {
            super(model);
            volumeModification(model.volumeModification);
        }

        public final VolumeModification.Builder getVolumeModification() {
            return volumeModification != null ? volumeModification.toBuilder() : null;
        }

        public final void setVolumeModification(VolumeModification.BuilderImpl volumeModification) {
            this.volumeModification = volumeModification != null ? volumeModification.build() : null;
        }

        @Override
        @Transient
        public final Builder volumeModification(VolumeModification volumeModification) {
            this.volumeModification = volumeModification;
            return this;
        }

        @Override
        public ModifyVolumeResponse build() {
            return new ModifyVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
