/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an export instance task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTask implements SdkPojo, Serializable, ToCopyableBuilder<ExportTask.Builder, ExportTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ExportTask::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> EXPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExportTaskId")
            .getter(getter(ExportTask::exportTaskId))
            .setter(setter(Builder::exportTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskId")
                    .unmarshallLocationName("exportTaskId").build()).build();

    private static final SdkField<ExportToS3Task> EXPORT_TO_S3_TASK_FIELD = SdkField
            .<ExportToS3Task> builder(MarshallingType.SDK_POJO)
            .memberName("ExportToS3Task")
            .getter(getter(ExportTask::exportToS3Task))
            .setter(setter(Builder::exportToS3Task))
            .constructor(ExportToS3Task::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToS3")
                    .unmarshallLocationName("exportToS3").build()).build();

    private static final SdkField<InstanceExportDetails> INSTANCE_EXPORT_DETAILS_FIELD = SdkField
            .<InstanceExportDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceExportDetails")
            .getter(getter(ExportTask::instanceExportDetails))
            .setter(setter(Builder::instanceExportDetails))
            .constructor(InstanceExportDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceExport")
                    .unmarshallLocationName("instanceExport").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(ExportTask::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(ExportTask::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ExportTask::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXPORT_TASK_ID_FIELD, EXPORT_TO_S3_TASK_FIELD, INSTANCE_EXPORT_DETAILS_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String exportTaskId;

    private final ExportToS3Task exportToS3Task;

    private final InstanceExportDetails instanceExportDetails;

    private final String state;

    private final String statusMessage;

    private final List<Tag> tags;

    private ExportTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportTaskId = builder.exportTaskId;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceExportDetails = builder.instanceExportDetails;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A description of the resource being exported.
     * </p>
     * 
     * @return A description of the resource being exported.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the export task.
     * </p>
     * 
     * @return The ID of the export task.
     */
    public final String exportTaskId() {
        return exportTaskId;
    }

    /**
     * <p>
     * Information about the export task.
     * </p>
     * 
     * @return Information about the export task.
     */
    public final ExportToS3Task exportToS3Task() {
        return exportToS3Task;
    }

    /**
     * <p>
     * Information about the instance to export.
     * </p>
     * 
     * @return Information about the instance to export.
     */
    public final InstanceExportDetails instanceExportDetails() {
        return instanceExportDetails;
    }

    /**
     * <p>
     * The state of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the export task.
     * @see ExportTaskState
     */
    public final ExportTaskState state() {
        return ExportTaskState.fromValue(state);
    }

    /**
     * <p>
     * The state of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the export task.
     * @see ExportTaskState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status message related to the export task.
     * </p>
     * 
     * @return The status message related to the export task.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the export task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the export task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(instanceExportDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(exportTaskId(), other.exportTaskId())
                && Objects.equals(exportToS3Task(), other.exportToS3Task())
                && Objects.equals(instanceExportDetails(), other.instanceExportDetails())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTask").add("Description", description()).add("ExportTaskId", exportTaskId())
                .add("ExportToS3Task", exportToS3Task()).add("InstanceExportDetails", instanceExportDetails())
                .add("State", stateAsString()).add("StatusMessage", statusMessage()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExportTaskId":
            return Optional.ofNullable(clazz.cast(exportTaskId()));
        case "ExportToS3Task":
            return Optional.ofNullable(clazz.cast(exportToS3Task()));
        case "InstanceExportDetails":
            return Optional.ofNullable(clazz.cast(instanceExportDetails()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTask> {
        /**
         * <p>
         * A description of the resource being exported.
         * </p>
         * 
         * @param description
         *        A description of the resource being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the export task.
         * </p>
         * 
         * @param exportTaskId
         *        The ID of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskId(String exportTaskId);

        /**
         * <p>
         * Information about the export task.
         * </p>
         * 
         * @param exportToS3Task
         *        Information about the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToS3Task(ExportToS3Task exportToS3Task);

        /**
         * <p>
         * Information about the export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportToS3Task.Builder} avoiding the need to
         * create one manually via {@link ExportToS3Task#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportToS3Task.Builder#build()} is called immediately and its
         * result is passed to {@link #exportToS3Task(ExportToS3Task)}.
         * 
         * @param exportToS3Task
         *        a consumer that will call methods on {@link ExportToS3Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportToS3Task(ExportToS3Task)
         */
        default Builder exportToS3Task(Consumer<ExportToS3Task.Builder> exportToS3Task) {
            return exportToS3Task(ExportToS3Task.builder().applyMutation(exportToS3Task).build());
        }

        /**
         * <p>
         * Information about the instance to export.
         * </p>
         * 
         * @param instanceExportDetails
         *        Information about the instance to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceExportDetails(InstanceExportDetails instanceExportDetails);

        /**
         * <p>
         * Information about the instance to export.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceExportDetails.Builder} avoiding the need
         * to create one manually via {@link InstanceExportDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceExportDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceExportDetails(InstanceExportDetails)}.
         * 
         * @param instanceExportDetails
         *        a consumer that will call methods on {@link InstanceExportDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceExportDetails(InstanceExportDetails)
         */
        default Builder instanceExportDetails(Consumer<InstanceExportDetails.Builder> instanceExportDetails) {
            return instanceExportDetails(InstanceExportDetails.builder().applyMutation(instanceExportDetails).build());
        }

        /**
         * <p>
         * The state of the export task.
         * </p>
         * 
         * @param state
         *        The state of the export task.
         * @see ExportTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the export task.
         * </p>
         * 
         * @param state
         *        The state of the export task.
         * @see ExportTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskState
         */
        Builder state(ExportTaskState state);

        /**
         * <p>
         * The status message related to the export task.
         * </p>
         * 
         * @param statusMessage
         *        The status message related to the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The tags for the export task.
         * </p>
         * 
         * @param tags
         *        The tags for the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the export task.
         * </p>
         * 
         * @param tags
         *        The tags for the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the export task.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String exportTaskId;

        private ExportToS3Task exportToS3Task;

        private InstanceExportDetails instanceExportDetails;

        private String state;

        private String statusMessage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            description(model.description);
            exportTaskId(model.exportTaskId);
            exportToS3Task(model.exportToS3Task);
            instanceExportDetails(model.instanceExportDetails);
            state(model.state);
            statusMessage(model.statusMessage);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExportTaskId() {
            return exportTaskId;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        @Override
        @Transient
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final ExportToS3Task.Builder getExportToS3Task() {
            return exportToS3Task != null ? exportToS3Task.toBuilder() : null;
        }

        public final void setExportToS3Task(ExportToS3Task.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        @Override
        @Transient
        public final Builder exportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final InstanceExportDetails.Builder getInstanceExportDetails() {
            return instanceExportDetails != null ? instanceExportDetails.toBuilder() : null;
        }

        public final void setInstanceExportDetails(InstanceExportDetails.BuilderImpl instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails != null ? instanceExportDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ExportTaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExportTask build() {
            return new ExportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
