/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CapacityReservationGroupSetCopier {
    static List<CapacityReservationGroup> copy(Collection<? extends CapacityReservationGroup> capacityReservationGroupSetParam) {
        List<CapacityReservationGroup> list;
        if (capacityReservationGroupSetParam == null || capacityReservationGroupSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityReservationGroup> modifiableList = new ArrayList<>();
            capacityReservationGroupSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CapacityReservationGroup> copyFromBuilder(
            Collection<? extends CapacityReservationGroup.Builder> capacityReservationGroupSetParam) {
        List<CapacityReservationGroup> list;
        if (capacityReservationGroupSetParam == null || capacityReservationGroupSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityReservationGroup> modifiableList = new ArrayList<>();
            capacityReservationGroupSetParam.forEach(entry -> {
                CapacityReservationGroup member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CapacityReservationGroup.Builder> copyToBuilder(
            Collection<? extends CapacityReservationGroup> capacityReservationGroupSetParam) {
        List<CapacityReservationGroup.Builder> list;
        if (capacityReservationGroupSetParam == null || capacityReservationGroupSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityReservationGroup.Builder> modifiableList = new ArrayList<>();
            capacityReservationGroupSetParam.forEach(entry -> {
                CapacityReservationGroup.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
