/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ExportTaskState;
import software.amazon.awssdk.services.ec2.model.ExportToS3Task;
import software.amazon.awssdk.services.ec2.model.InstanceExportDetails;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ExportTask.getter(ExportTask::description)).setter(ExportTask.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> EXPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportTaskId").getter(ExportTask.getter(ExportTask::exportTaskId)).setter(ExportTask.setter(Builder::exportTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskId").unmarshallLocationName("exportTaskId").build()}).build();
    private static final SdkField<ExportToS3Task> EXPORT_TO_S3_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportToS3Task").getter(ExportTask.getter(ExportTask::exportToS3Task)).setter(ExportTask.setter(Builder::exportToS3Task)).constructor(ExportToS3Task::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToS3").unmarshallLocationName("exportToS3").build()}).build();
    private static final SdkField<InstanceExportDetails> INSTANCE_EXPORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceExportDetails").getter(ExportTask.getter(ExportTask::instanceExportDetails)).setter(ExportTask.setter(Builder::instanceExportDetails)).constructor(InstanceExportDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceExport").unmarshallLocationName("instanceExport").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ExportTask.getter(ExportTask::stateAsString)).setter(ExportTask.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ExportTask.getter(ExportTask::statusMessage)).setter(ExportTask.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ExportTask.getter(ExportTask::tags)).setter(ExportTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXPORT_TASK_ID_FIELD, EXPORT_TO_S3_TASK_FIELD, INSTANCE_EXPORT_DETAILS_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String exportTaskId;
    private final ExportToS3Task exportToS3Task;
    private final InstanceExportDetails instanceExportDetails;
    private final String state;
    private final String statusMessage;
    private final List<Tag> tags;

    private ExportTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportTaskId = builder.exportTaskId;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceExportDetails = builder.instanceExportDetails;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String exportTaskId() {
        return this.exportTaskId;
    }

    public final ExportToS3Task exportToS3Task() {
        return this.exportToS3Task;
    }

    public final InstanceExportDetails instanceExportDetails() {
        return this.instanceExportDetails;
    }

    public final ExportTaskState state() {
        return ExportTaskState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceExportDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.exportTaskId(), other.exportTaskId()) && Objects.equals(this.exportToS3Task(), other.exportToS3Task()) && Objects.equals(this.instanceExportDetails(), other.instanceExportDetails()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTask").add("Description", (Object)this.description()).add("ExportTaskId", (Object)this.exportTaskId()).add("ExportToS3Task", (Object)this.exportToS3Task()).add("InstanceExportDetails", (Object)this.instanceExportDetails()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExportTaskId": {
                return Optional.ofNullable(clazz.cast(this.exportTaskId()));
            }
            case "ExportToS3Task": {
                return Optional.ofNullable(clazz.cast(this.exportToS3Task()));
            }
            case "InstanceExportDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceExportDetails()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String exportTaskId;
        private ExportToS3Task exportToS3Task;
        private InstanceExportDetails instanceExportDetails;
        private String state;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.description(model.description);
            this.exportTaskId(model.exportTaskId);
            this.exportToS3Task(model.exportToS3Task);
            this.instanceExportDetails(model.instanceExportDetails);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExportTaskId() {
            return this.exportTaskId;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        @Override
        @Transient
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final ExportToS3Task.Builder getExportToS3Task() {
            return this.exportToS3Task != null ? this.exportToS3Task.toBuilder() : null;
        }

        public final void setExportToS3Task(ExportToS3Task.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        @Override
        @Transient
        public final Builder exportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final InstanceExportDetails.Builder getInstanceExportDetails() {
            return this.instanceExportDetails != null ? this.instanceExportDetails.toBuilder() : null;
        }

        public final void setInstanceExportDetails(InstanceExportDetails.BuilderImpl instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails != null ? instanceExportDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ExportTaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTask> {
        public Builder description(String var1);

        public Builder exportTaskId(String var1);

        public Builder exportToS3Task(ExportToS3Task var1);

        default public Builder exportToS3Task(Consumer<ExportToS3Task.Builder> exportToS3Task) {
            return this.exportToS3Task((ExportToS3Task)((ExportToS3Task.Builder)ExportToS3Task.builder().applyMutation(exportToS3Task)).build());
        }

        public Builder instanceExportDetails(InstanceExportDetails var1);

        default public Builder instanceExportDetails(Consumer<InstanceExportDetails.Builder> instanceExportDetails) {
            return this.instanceExportDetails((InstanceExportDetails)((InstanceExportDetails.Builder)InstanceExportDetails.builder().applyMutation(instanceExportDetails)).build());
        }

        public Builder state(String var1);

        public Builder state(ExportTaskState var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

