/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.OccurrenceDaySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstanceRecurrence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstanceRecurrence> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(ScheduledInstanceRecurrence.getter(ScheduledInstanceRecurrence::frequency)).setter(ScheduledInstanceRecurrence.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").unmarshallLocationName("frequency").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(ScheduledInstanceRecurrence.getter(ScheduledInstanceRecurrence::interval)).setter(ScheduledInstanceRecurrence.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").unmarshallLocationName("interval").build()}).build();
    private static final SdkField<List<Integer>> OCCURRENCE_DAY_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OccurrenceDaySet").getter(ScheduledInstanceRecurrence.getter(ScheduledInstanceRecurrence::occurrenceDaySet)).setter(ScheduledInstanceRecurrence.setter(Builder::occurrenceDaySet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceDaySet").unmarshallLocationName("occurrenceDaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> OCCURRENCE_RELATIVE_TO_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OccurrenceRelativeToEnd").getter(ScheduledInstanceRecurrence.getter(ScheduledInstanceRecurrence::occurrenceRelativeToEnd)).setter(ScheduledInstanceRecurrence.setter(Builder::occurrenceRelativeToEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceRelativeToEnd").unmarshallLocationName("occurrenceRelativeToEnd").build()}).build();
    private static final SdkField<String> OCCURRENCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OccurrenceUnit").getter(ScheduledInstanceRecurrence.getter(ScheduledInstanceRecurrence::occurrenceUnit)).setter(ScheduledInstanceRecurrence.setter(Builder::occurrenceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceUnit").unmarshallLocationName("occurrenceUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, INTERVAL_FIELD, OCCURRENCE_DAY_SET_FIELD, OCCURRENCE_RELATIVE_TO_END_FIELD, OCCURRENCE_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String frequency;
    private final Integer interval;
    private final List<Integer> occurrenceDaySet;
    private final Boolean occurrenceRelativeToEnd;
    private final String occurrenceUnit;

    private ScheduledInstanceRecurrence(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDaySet = builder.occurrenceDaySet;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    public final String frequency() {
        return this.frequency;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final boolean hasOccurrenceDaySet() {
        return this.occurrenceDaySet != null && !(this.occurrenceDaySet instanceof SdkAutoConstructList);
    }

    public final List<Integer> occurrenceDaySet() {
        return this.occurrenceDaySet;
    }

    public final Boolean occurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public final String occurrenceUnit() {
        return this.occurrenceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOccurrenceDaySet() ? this.occurrenceDaySet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceUnit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrence)) {
            return false;
        }
        ScheduledInstanceRecurrence other = (ScheduledInstanceRecurrence)obj;
        return Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.interval(), other.interval()) && this.hasOccurrenceDaySet() == other.hasOccurrenceDaySet() && Objects.equals(this.occurrenceDaySet(), other.occurrenceDaySet()) && Objects.equals(this.occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd()) && Objects.equals(this.occurrenceUnit(), other.occurrenceUnit());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledInstanceRecurrence").add("Frequency", (Object)this.frequency()).add("Interval", (Object)this.interval()).add("OccurrenceDaySet", this.hasOccurrenceDaySet() ? this.occurrenceDaySet() : null).add("OccurrenceRelativeToEnd", (Object)this.occurrenceRelativeToEnd()).add("OccurrenceUnit", (Object)this.occurrenceUnit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "OccurrenceDaySet": {
                return Optional.ofNullable(clazz.cast(this.occurrenceDaySet()));
            }
            case "OccurrenceRelativeToEnd": {
                return Optional.ofNullable(clazz.cast(this.occurrenceRelativeToEnd()));
            }
            case "OccurrenceUnit": {
                return Optional.ofNullable(clazz.cast(this.occurrenceUnit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceRecurrence, T> g) {
        return obj -> g.apply((ScheduledInstanceRecurrence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;
        private Integer interval;
        private List<Integer> occurrenceDaySet = DefaultSdkAutoConstructList.getInstance();
        private Boolean occurrenceRelativeToEnd;
        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrence model) {
            this.frequency(model.frequency);
            this.interval(model.interval);
            this.occurrenceDaySet(model.occurrenceDaySet);
            this.occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            this.occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        @Transient
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        @Transient
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Collection<Integer> getOccurrenceDaySet() {
            if (this.occurrenceDaySet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.occurrenceDaySet;
        }

        public final void setOccurrenceDaySet(Collection<Integer> occurrenceDaySet) {
            this.occurrenceDaySet = OccurrenceDaySetCopier.copy(occurrenceDaySet);
        }

        @Override
        @Transient
        public final Builder occurrenceDaySet(Collection<Integer> occurrenceDaySet) {
            this.occurrenceDaySet = OccurrenceDaySetCopier.copy(occurrenceDaySet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder occurrenceDaySet(Integer ... occurrenceDaySet) {
            this.occurrenceDaySet(Arrays.asList(occurrenceDaySet));
            return this;
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return this.occurrenceRelativeToEnd;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        @Override
        @Transient
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final String getOccurrenceUnit() {
            return this.occurrenceUnit;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        @Override
        @Transient
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public ScheduledInstanceRecurrence build() {
            return new ScheduledInstanceRecurrence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstanceRecurrence> {
        public Builder frequency(String var1);

        public Builder interval(Integer var1);

        public Builder occurrenceDaySet(Collection<Integer> var1);

        public Builder occurrenceDaySet(Integer ... var1);

        public Builder occurrenceRelativeToEnd(Boolean var1);

        public Builder occurrenceUnit(String var1);
    }
}

