/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInstanceEventWindowRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteInstanceEventWindowRequest> {
    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceDelete").getter(DeleteInstanceEventWindowRequest.getter(DeleteInstanceEventWindowRequest::forceDelete)).setter(DeleteInstanceEventWindowRequest.setter(Builder::forceDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDelete").unmarshallLocationName("ForceDelete").build()}).build();
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(DeleteInstanceEventWindowRequest.getter(DeleteInstanceEventWindowRequest::instanceEventWindowId)).setter(DeleteInstanceEventWindowRequest.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("InstanceEventWindowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_DELETE_FIELD, INSTANCE_EVENT_WINDOW_ID_FIELD));
    private final Boolean forceDelete;
    private final String instanceEventWindowId;

    private DeleteInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.forceDelete = builder.forceDelete;
        this.instanceEventWindowId = builder.instanceEventWindowId;
    }

    public final Boolean forceDelete() {
        return this.forceDelete;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDelete());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceEventWindowRequest)) {
            return false;
        }
        DeleteInstanceEventWindowRequest other = (DeleteInstanceEventWindowRequest)((Object)obj);
        return Objects.equals(this.forceDelete(), other.forceDelete()) && Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInstanceEventWindowRequest").add("ForceDelete", (Object)this.forceDelete()).add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForceDelete": {
                return Optional.ofNullable(clazz.cast(this.forceDelete()));
            }
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((DeleteInstanceEventWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean forceDelete;
        private String instanceEventWindowId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceEventWindowRequest model) {
            super(model);
            this.forceDelete(model.forceDelete);
            this.instanceEventWindowId(model.instanceEventWindowId);
        }

        public final Boolean getForceDelete() {
            return this.forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        @Transient
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        @Transient
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceEventWindowRequest build() {
            return new DeleteInstanceEventWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInstanceEventWindowRequest> {
        public Builder forceDelete(Boolean var1);

        public Builder instanceEventWindowId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

