/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of units to request. You can choose to set the target capacity in terms of instances or a performance
 * characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is
 * <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
 * </p>
 * <p>
 * You can use the On-Demand Instance <code>MaxTotalPrice</code> parameter, the Spot Instance <code>MaxTotalPrice</code>
 * , or both to ensure that your fleet cost does not exceed your budget. If you set a maximum price per hour for the
 * On-Demand Instances and Spot Instances in your request, EC2 Fleet will launch instances until it reaches the maximum
 * amount that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops
 * launching instances even if it hasn’t met the target capacity. The <code>MaxTotalPrice</code> parameters are located
 * in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptions.html">OnDemandOptions</a> and
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptions">SpotOptions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetCapacitySpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetCapacitySpecification.Builder, TargetCapacitySpecification> {
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalTargetCapacity")
            .getter(getter(TargetCapacitySpecification::totalTargetCapacity))
            .setter(setter(Builder::totalTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity")
                    .unmarshallLocationName("totalTargetCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandTargetCapacity")
            .getter(getter(TargetCapacitySpecification::onDemandTargetCapacity))
            .setter(setter(Builder::onDemandTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity")
                    .unmarshallLocationName("onDemandTargetCapacity").build()).build();

    private static final SdkField<Integer> SPOT_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpotTargetCapacity")
            .getter(getter(TargetCapacitySpecification::spotTargetCapacity))
            .setter(setter(Builder::spotTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotTargetCapacity")
                    .unmarshallLocationName("spotTargetCapacity").build()).build();

    private static final SdkField<String> DEFAULT_TARGET_CAPACITY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultTargetCapacityType")
            .getter(getter(TargetCapacitySpecification::defaultTargetCapacityTypeAsString))
            .setter(setter(Builder::defaultTargetCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetCapacityType")
                    .unmarshallLocationName("defaultTargetCapacityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_TARGET_CAPACITY_FIELD,
            ON_DEMAND_TARGET_CAPACITY_FIELD, SPOT_TARGET_CAPACITY_FIELD, DEFAULT_TARGET_CAPACITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalTargetCapacity;

    private final Integer onDemandTargetCapacity;

    private final Integer spotTargetCapacity;

    private final String defaultTargetCapacityType;

    private TargetCapacitySpecification(BuilderImpl builder) {
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.spotTargetCapacity = builder.spotTargetCapacity;
        this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
    }

    /**
     * <p>
     * The number of units to request, filled using <code>DefaultTargetCapacityType</code>.
     * </p>
     * 
     * @return The number of units to request, filled using <code>DefaultTargetCapacityType</code>.
     */
    public final Integer totalTargetCapacity() {
        return totalTargetCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify a
     * target capacity for On-Demand units.
     * </p>
     * 
     * @return The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot
     *         specify a target capacity for On-Demand units.
     */
    public final Integer onDemandTargetCapacity() {
        return onDemandTargetCapacity;
    }

    /**
     * <p>
     * The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot
     * specify a target capacity for Spot units.
     * </p>
     * 
     * @return The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you
     *         cannot specify a target capacity for Spot units.
     */
    public final Integer spotTargetCapacity() {
        return spotTargetCapacity;
    }

    /**
     * <p>
     * The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetCapacityType} will return {@link DefaultTargetCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetCapacityTypeAsString}.
     * </p>
     * 
     * @return The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>
     *         .
     * @see DefaultTargetCapacityType
     */
    public final DefaultTargetCapacityType defaultTargetCapacityType() {
        return DefaultTargetCapacityType.fromValue(defaultTargetCapacityType);
    }

    /**
     * <p>
     * The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetCapacityType} will return {@link DefaultTargetCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetCapacityTypeAsString}.
     * </p>
     * 
     * @return The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>
     *         .
     * @see DefaultTargetCapacityType
     */
    public final String defaultTargetCapacityTypeAsString() {
        return defaultTargetCapacityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(spotTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTargetCapacityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetCapacitySpecification)) {
            return false;
        }
        TargetCapacitySpecification other = (TargetCapacitySpecification) obj;
        return Objects.equals(totalTargetCapacity(), other.totalTargetCapacity())
                && Objects.equals(onDemandTargetCapacity(), other.onDemandTargetCapacity())
                && Objects.equals(spotTargetCapacity(), other.spotTargetCapacity())
                && Objects.equals(defaultTargetCapacityTypeAsString(), other.defaultTargetCapacityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetCapacitySpecification").add("TotalTargetCapacity", totalTargetCapacity())
                .add("OnDemandTargetCapacity", onDemandTargetCapacity()).add("SpotTargetCapacity", spotTargetCapacity())
                .add("DefaultTargetCapacityType", defaultTargetCapacityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalTargetCapacity":
            return Optional.ofNullable(clazz.cast(totalTargetCapacity()));
        case "OnDemandTargetCapacity":
            return Optional.ofNullable(clazz.cast(onDemandTargetCapacity()));
        case "SpotTargetCapacity":
            return Optional.ofNullable(clazz.cast(spotTargetCapacity()));
        case "DefaultTargetCapacityType":
            return Optional.ofNullable(clazz.cast(defaultTargetCapacityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetCapacitySpecification, T> g) {
        return obj -> g.apply((TargetCapacitySpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetCapacitySpecification> {
        /**
         * <p>
         * The number of units to request, filled using <code>DefaultTargetCapacityType</code>.
         * </p>
         * 
         * @param totalTargetCapacity
         *        The number of units to request, filled using <code>DefaultTargetCapacityType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTargetCapacity(Integer totalTargetCapacity);

        /**
         * <p>
         * The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify
         * a target capacity for On-Demand units.
         * </p>
         * 
         * @param onDemandTargetCapacity
         *        The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot
         *        specify a target capacity for On-Demand units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandTargetCapacity(Integer onDemandTargetCapacity);

        /**
         * <p>
         * The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot
         * specify a target capacity for Spot units.
         * </p>
         * 
         * @param spotTargetCapacity
         *        The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you
         *        cannot specify a target capacity for Spot units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotTargetCapacity(Integer spotTargetCapacity);

        /**
         * <p>
         * The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.
         * </p>
         * 
         * @param defaultTargetCapacityType
         *        The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or
         *        <code>On-Demand</code>.
         * @see DefaultTargetCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultTargetCapacityType
         */
        Builder defaultTargetCapacityType(String defaultTargetCapacityType);

        /**
         * <p>
         * The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.
         * </p>
         * 
         * @param defaultTargetCapacityType
         *        The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or
         *        <code>On-Demand</code>.
         * @see DefaultTargetCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultTargetCapacityType
         */
        Builder defaultTargetCapacityType(DefaultTargetCapacityType defaultTargetCapacityType);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalTargetCapacity;

        private Integer onDemandTargetCapacity;

        private Integer spotTargetCapacity;

        private String defaultTargetCapacityType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetCapacitySpecification model) {
            totalTargetCapacity(model.totalTargetCapacity);
            onDemandTargetCapacity(model.onDemandTargetCapacity);
            spotTargetCapacity(model.spotTargetCapacity);
            defaultTargetCapacityType(model.defaultTargetCapacityType);
        }

        public final Integer getTotalTargetCapacity() {
            return totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        @Transient
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Integer getOnDemandTargetCapacity() {
            return onDemandTargetCapacity;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        @Transient
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final Integer getSpotTargetCapacity() {
            return spotTargetCapacity;
        }

        public final void setSpotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
        }

        @Override
        @Transient
        public final Builder spotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
            return this;
        }

        public final String getDefaultTargetCapacityType() {
            return defaultTargetCapacityType;
        }

        public final void setDefaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
        }

        @Override
        @Transient
        public final Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
            return this;
        }

        @Override
        @Transient
        public final Builder defaultTargetCapacityType(DefaultTargetCapacityType defaultTargetCapacityType) {
            this.defaultTargetCapacityType(defaultTargetCapacityType == null ? null : defaultTargetCapacityType.toString());
            return this;
        }

        @Override
        public TargetCapacitySpecification build() {
            return new TargetCapacitySpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
