/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceEventStartTimeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceEventStartTimeRequest.Builder, ModifyInstanceEventStartTimeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceEventStartTimeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_EVENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventId")
            .getter(getter(ModifyInstanceEventStartTimeRequest::instanceEventId))
            .setter(setter(Builder::instanceEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventId")
                    .unmarshallLocationName("InstanceEventId").build()).build();

    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NotBefore")
            .getter(getter(ModifyInstanceEventStartTimeRequest::notBefore))
            .setter(setter(Builder::notBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore")
                    .unmarshallLocationName("NotBefore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_EVENT_ID_FIELD, NOT_BEFORE_FIELD));

    private final String instanceId;

    private final String instanceEventId;

    private final Instant notBefore;

    private ModifyInstanceEventStartTimeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.instanceEventId = builder.instanceEventId;
        this.notBefore = builder.notBefore;
    }

    /**
     * <p>
     * The ID of the instance with the scheduled event.
     * </p>
     * 
     * @return The ID of the instance with the scheduled event.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the event whose date and time you are modifying.
     * </p>
     * 
     * @return The ID of the event whose date and time you are modifying.
     */
    public final String instanceEventId() {
        return instanceEventId;
    }

    /**
     * <p>
     * The new date and time when the event will take place.
     * </p>
     * 
     * @return The new date and time when the event will take place.
     */
    public final Instant notBefore() {
        return notBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventId());
        hashCode = 31 * hashCode + Objects.hashCode(notBefore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceEventStartTimeRequest)) {
            return false;
        }
        ModifyInstanceEventStartTimeRequest other = (ModifyInstanceEventStartTimeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceEventId(), other.instanceEventId())
                && Objects.equals(notBefore(), other.notBefore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceEventStartTimeRequest").add("InstanceId", instanceId())
                .add("InstanceEventId", instanceEventId()).add("NotBefore", notBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceEventId":
            return Optional.ofNullable(clazz.cast(instanceEventId()));
        case "NotBefore":
            return Optional.ofNullable(clazz.cast(notBefore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceEventStartTimeRequest, T> g) {
        return obj -> g.apply((ModifyInstanceEventStartTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceEventStartTimeRequest> {
        /**
         * <p>
         * The ID of the instance with the scheduled event.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance with the scheduled event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the event whose date and time you are modifying.
         * </p>
         * 
         * @param instanceEventId
         *        The ID of the event whose date and time you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventId(String instanceEventId);

        /**
         * <p>
         * The new date and time when the event will take place.
         * </p>
         * 
         * @param notBefore
         *        The new date and time when the event will take place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private String instanceEventId;

        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceEventStartTimeRequest model) {
            super(model);
            instanceId(model.instanceId);
            instanceEventId(model.instanceEventId);
            notBefore(model.notBefore);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceEventId() {
            return instanceEventId;
        }

        public final void setInstanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
        }

        @Override
        @Transient
        public final Builder instanceEventId(String instanceEventId) {
            this.instanceEventId = instanceEventId;
            return this;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        @Transient
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceEventStartTimeRequest build() {
            return new ModifyInstanceEventStartTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
