/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyHostsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyHostsRequest.Builder, ModifyHostsRequest> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoPlacement")
            .getter(getter(ModifyHostsRequest::autoPlacementAsString))
            .setter(setter(Builder::autoPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement")
                    .unmarshallLocationName("autoPlacement").build()).build();

    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HostIds")
            .getter(getter(ModifyHostsRequest::hostIds))
            .setter(setter(Builder::hostIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> HOST_RECOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostRecovery")
            .getter(getter(ModifyHostsRequest::hostRecoveryAsString))
            .setter(setter(Builder::hostRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRecovery")
                    .unmarshallLocationName("HostRecovery").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ModifyHostsRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily")
            .getter(getter(ModifyHostsRequest::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("InstanceFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD,
            HOST_IDS_FIELD, HOST_RECOVERY_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_FAMILY_FIELD));

    private final String autoPlacement;

    private final List<String> hostIds;

    private final String hostRecovery;

    private final String instanceType;

    private final String instanceFamily;

    private ModifyHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.hostIds = builder.hostIds;
        this.hostRecovery = builder.hostRecovery;
        this.instanceType = builder.instanceType;
        this.instanceFamily = builder.instanceFamily;
    }

    /**
     * <p>
     * Specify whether to enable or disable auto-placement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Specify whether to enable or disable auto-placement.
     * @see AutoPlacement
     */
    public final AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * Specify whether to enable or disable auto-placement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Specify whether to enable or disable auto-placement.
     * @see AutoPlacement
     */
    public final String autoPlacementAsString() {
        return autoPlacement;
    }

    /**
     * For responses, this returns true if the service returned a value for the HostIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHostIds() {
        return hostIds != null && !(hostIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHostIds} method.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts to modify.
     */
    public final List<String> hostIds() {
        return hostIds;
    }

    /**
     * <p>
     * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRecovery} will
     * return {@link HostRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRecoveryAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
     *         recovery</a> in the <i>Amazon EC2 User Guide</i>.
     * @see HostRecovery
     */
    public final HostRecovery hostRecovery() {
        return HostRecovery.fromValue(hostRecovery);
    }

    /**
     * <p>
     * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRecovery} will
     * return {@link HostRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRecoveryAsString}.
     * </p>
     * 
     * @return Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
     *         recovery</a> in the <i>Amazon EC2 User Guide</i>.
     * @see HostRecovery
     */
    public final String hostRecoveryAsString() {
        return hostRecovery;
    }

    /**
     * <p>
     * Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to modify a Dedicated
     * Host to support only a specific instance type.
     * </p>
     * <p>
     * If you want to modify a Dedicated Host to support multiple instance types in its current instance family, omit
     * this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
     * <b>InstanceFamily</b> in the same request.
     * </p>
     * 
     * @return Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to modify a
     *         Dedicated Host to support only a specific instance type.</p>
     *         <p>
     *         If you want to modify a Dedicated Host to support multiple instance types in its current instance family,
     *         omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
     *         <b>InstanceFamily</b> in the same request.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Specifies the instance family to be supported by the Dedicated Host. Specify this parameter to modify a Dedicated
     * Host to support multiple instance types within its current instance family.
     * </p>
     * <p>
     * If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter and specify
     * <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same
     * request.
     * </p>
     * 
     * @return Specifies the instance family to be supported by the Dedicated Host. Specify this parameter to modify a
     *         Dedicated Host to support multiple instance types within its current instance family.</p>
     *         <p>
     *         If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter and
     *         specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in
     *         the same request.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasHostIds() ? hostIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest) obj;
        return Objects.equals(autoPlacementAsString(), other.autoPlacementAsString()) && hasHostIds() == other.hasHostIds()
                && Objects.equals(hostIds(), other.hostIds())
                && Objects.equals(hostRecoveryAsString(), other.hostRecoveryAsString())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instanceFamily(), other.instanceFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyHostsRequest").add("AutoPlacement", autoPlacementAsString())
                .add("HostIds", hasHostIds() ? hostIds() : null).add("HostRecovery", hostRecoveryAsString())
                .add("InstanceType", instanceType()).add("InstanceFamily", instanceFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.ofNullable(clazz.cast(autoPlacementAsString()));
        case "HostIds":
            return Optional.ofNullable(clazz.cast(hostIds()));
        case "HostRecovery":
            return Optional.ofNullable(clazz.cast(hostRecoveryAsString()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHostsRequest, T> g) {
        return obj -> g.apply((ModifyHostsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyHostsRequest> {
        /**
         * <p>
         * Specify whether to enable or disable auto-placement.
         * </p>
         * 
         * @param autoPlacement
         *        Specify whether to enable or disable auto-placement.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * Specify whether to enable or disable auto-placement.
         * </p>
         * 
         * @param autoPlacement
         *        Specify whether to enable or disable auto-placement.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The IDs of the Dedicated Hosts to modify.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(Collection<String> hostIds);

        /**
         * <p>
         * The IDs of the Dedicated Hosts to modify.
         * </p>
         * 
         * @param hostIds
         *        The IDs of the Dedicated Hosts to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(String... hostIds);

        /**
         * <p>
         * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param hostRecovery
         *        Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see
         *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
         *        recovery</a> in the <i>Amazon EC2 User Guide</i>.
         * @see HostRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRecovery
         */
        Builder hostRecovery(String hostRecovery);

        /**
         * <p>
         * Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a>
         * in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param hostRecovery
         *        Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see
         *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host
         *        recovery</a> in the <i>Amazon EC2 User Guide</i>.
         * @see HostRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRecovery
         */
        Builder hostRecovery(HostRecovery hostRecovery);

        /**
         * <p>
         * Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to modify a
         * Dedicated Host to support only a specific instance type.
         * </p>
         * <p>
         * If you want to modify a Dedicated Host to support multiple instance types in its current instance family,
         * omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and
         * <b>InstanceFamily</b> in the same request.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type to be supported by the Dedicated Host. Specify this parameter to modify a
         *        Dedicated Host to support only a specific instance type.</p>
         *        <p>
         *        If you want to modify a Dedicated Host to support multiple instance types in its current instance
         *        family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify
         *        <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Specifies the instance family to be supported by the Dedicated Host. Specify this parameter to modify a
         * Dedicated Host to support multiple instance types within its current instance family.
         * </p>
         * <p>
         * If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter and
         * specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the
         * same request.
         * </p>
         * 
         * @param instanceFamily
         *        Specifies the instance family to be supported by the Dedicated Host. Specify this parameter to modify
         *        a Dedicated Host to support multiple instance types within its current instance family.</p>
         *        <p>
         *        If you want to modify a Dedicated Host to support a specific instance type only, omit this parameter
         *        and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and
         *        <b>InstanceType</b> in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String autoPlacement;

        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();

        private String hostRecovery;

        private String instanceType;

        private String instanceFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsRequest model) {
            super(model);
            autoPlacement(model.autoPlacement);
            hostIds(model.hostIds);
            hostRecovery(model.hostRecovery);
            instanceType(model.instanceType);
            instanceFamily(model.instanceFamily);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        @Override
        @Transient
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        @Transient
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement == null ? null : autoPlacement.toString());
            return this;
        }

        public final Collection<String> getHostIds() {
            if (hostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return hostIds;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @Override
        @Transient
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final String getHostRecovery() {
            return hostRecovery;
        }

        public final void setHostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
        }

        @Override
        @Transient
        public final Builder hostRecovery(String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        @Override
        @Transient
        public final Builder hostRecovery(HostRecovery hostRecovery) {
            this.hostRecovery(hostRecovery == null ? null : hostRecovery.toString());
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        @Transient
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyHostsRequest build() {
            return new ModifyHostsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
