/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an elastic inference accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateElasticInferenceAcceleratorResponse
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LaunchTemplateElasticInferenceAcceleratorResponse.Builder, LaunchTemplateElasticInferenceAcceleratorResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(LaunchTemplateElasticInferenceAcceleratorResponse::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(LaunchTemplateElasticInferenceAcceleratorResponse::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer count;

    private LaunchTemplateElasticInferenceAcceleratorResponse(BuilderImpl builder) {
        this.type = builder.type;
        this.count = builder.count;
    }

    /**
     * <p>
     * The type of elastic inference accelerator. The possible values are eia1.medium, eia1.large, and eia1.xlarge.
     * </p>
     * 
     * @return The type of elastic inference accelerator. The possible values are eia1.medium, eia1.large, and
     *         eia1.xlarge.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The number of elastic inference accelerators to attach to the instance.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of elastic inference accelerators to attach to the instance. </p>
     *         <p>
     *         Default: 1
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateElasticInferenceAcceleratorResponse)) {
            return false;
        }
        LaunchTemplateElasticInferenceAcceleratorResponse other = (LaunchTemplateElasticInferenceAcceleratorResponse) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateElasticInferenceAcceleratorResponse").add("Type", type()).add("Count", count())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateElasticInferenceAcceleratorResponse, T> g) {
        return obj -> g.apply((LaunchTemplateElasticInferenceAcceleratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateElasticInferenceAcceleratorResponse> {
        /**
         * <p>
         * The type of elastic inference accelerator. The possible values are eia1.medium, eia1.large, and eia1.xlarge.
         * </p>
         * 
         * @param type
         *        The type of elastic inference accelerator. The possible values are eia1.medium, eia1.large, and
         *        eia1.xlarge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The number of elastic inference accelerators to attach to the instance.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param count
         *        The number of elastic inference accelerators to attach to the instance. </p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateElasticInferenceAcceleratorResponse model) {
            type(model.type);
            count(model.count);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public LaunchTemplateElasticInferenceAcceleratorResponse build() {
            return new LaunchTemplateElasticInferenceAcceleratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
