/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Ipv4PrefixesListCopier {
    static List<Ipv4PrefixSpecification> copy(Collection<? extends Ipv4PrefixSpecification> ipv4PrefixesListParam) {
        List<Ipv4PrefixSpecification> list;
        if (ipv4PrefixesListParam == null || ipv4PrefixesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecification> modifiableList = new ArrayList<>();
            ipv4PrefixesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ipv4PrefixSpecification> copyFromBuilder(
            Collection<? extends Ipv4PrefixSpecification.Builder> ipv4PrefixesListParam) {
        List<Ipv4PrefixSpecification> list;
        if (ipv4PrefixesListParam == null || ipv4PrefixesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecification> modifiableList = new ArrayList<>();
            ipv4PrefixesListParam.forEach(entry -> {
                Ipv4PrefixSpecification member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ipv4PrefixSpecification.Builder> copyToBuilder(Collection<? extends Ipv4PrefixSpecification> ipv4PrefixesListParam) {
        List<Ipv4PrefixSpecification.Builder> list;
        if (ipv4PrefixesListParam == null || ipv4PrefixesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ipv4PrefixSpecification.Builder> modifiableList = new ArrayList<>();
            ipv4PrefixesListParam.forEach(entry -> {
                Ipv4PrefixSpecification.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
