/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAvailabilityZonesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeAvailabilityZonesRequest.Builder, DescribeAvailabilityZonesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeAvailabilityZonesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ZONE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ZoneNames")
            .getter(getter(DescribeAvailabilityZonesRequest::zoneNames))
            .setter(setter(Builder::zoneNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName")
                    .unmarshallLocationName("ZoneName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ZoneName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ZoneName").unmarshallLocationName("ZoneName").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ZoneIds")
            .getter(getter(DescribeAvailabilityZonesRequest::zoneIds))
            .setter(setter(Builder::zoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId")
                    .unmarshallLocationName("ZoneId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ZoneId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ZoneId").unmarshallLocationName("ZoneId").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ALL_AVAILABILITY_ZONES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllAvailabilityZones")
            .getter(getter(DescribeAvailabilityZonesRequest::allAvailabilityZones))
            .setter(setter(Builder::allAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAvailabilityZones")
                    .unmarshallLocationName("AllAvailabilityZones").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            ZONE_NAMES_FIELD, ZONE_IDS_FIELD, ALL_AVAILABILITY_ZONES_FIELD));

    private final List<Filter> filters;

    private final List<String> zoneNames;

    private final List<String> zoneIds;

    private final Boolean allAvailabilityZones;

    private DescribeAvailabilityZonesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.zoneNames = builder.zoneNames;
        this.zoneIds = builder.zoneIds;
        this.allAvailabilityZones = builder.allAvailabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the group
     * associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of
     * the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>message</code> - The Zone message.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
     * <code>opt-in-not-required</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control
     * plane operations, such as API calls.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control
     * plane operations, such as API calls.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
     * <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone (for
     * example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local Zone
     * (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
     * <code>us-east-1-wl1-bos-wlz-1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of
     *         the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength
     *         Zones, use the name of the group associated with the Wavelength Zone (for example,
     *         <code>us-east-1-wl1-bos-wlz-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>message</code> - The Zone message.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
     *         <code>opt-in-not-required</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
     *         control plane operations, such as API calls.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
     *         control plane operations, such as API calls.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
     *         <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local
     *         Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
     *         <code>us-east-1-wl1-bos-wlz-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the
     *         Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
     *         <code>us-east-1-wl1-bos-wlz-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZoneNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasZoneNames() {
        return zoneNames != null && !(zoneNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the Availability Zones, Local Zones, and Wavelength Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZoneNames} method.
     * </p>
     * 
     * @return The names of the Availability Zones, Local Zones, and Wavelength Zones.
     */
    public final List<String> zoneNames() {
        return zoneNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZoneIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasZoneIds() {
        return zoneIds != null && !(zoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZoneIds} method.
     * </p>
     * 
     * @return The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
     */
    public final List<String> zoneIds() {
        return zoneIds;
    }

    /**
     * <p>
     * Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.
     * </p>
     * <p>
     * If you do not use this parameter, the results include only the zones for the Regions where you have chosen the
     * option to opt in.
     * </p>
     * 
     * @return Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.</p>
     *         <p>
     *         If you do not use this parameter, the results include only the zones for the Regions where you have
     *         chosen the option to opt in.
     */
    public final Boolean allAvailabilityZones() {
        return allAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasZoneNames() ? zoneNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasZoneIds() ? zoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allAvailabilityZones());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasZoneNames() == other.hasZoneNames() && Objects.equals(zoneNames(), other.zoneNames())
                && hasZoneIds() == other.hasZoneIds() && Objects.equals(zoneIds(), other.zoneIds())
                && Objects.equals(allAvailabilityZones(), other.allAvailabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAvailabilityZonesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("ZoneNames", hasZoneNames() ? zoneNames() : null).add("ZoneIds", hasZoneIds() ? zoneIds() : null)
                .add("AllAvailabilityZones", allAvailabilityZones()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ZoneNames":
            return Optional.ofNullable(clazz.cast(zoneNames()));
        case "ZoneIds":
            return Optional.ofNullable(clazz.cast(zoneIds()));
        case "AllAvailabilityZones":
            return Optional.ofNullable(clazz.cast(allAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAvailabilityZonesRequest, T> g) {
        return obj -> g.apply((DescribeAvailabilityZonesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the
         * group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use
         * the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>message</code> - The Zone message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
         * <code>opt-in-not-required</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
         * <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone
         * (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local
         * Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name
         *        of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength
         *        Zones, use the name of the group associated with the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>message</code> - The Zone message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
         *        <code>opt-in-not-required</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength
         *        Zone control plane operations, such as API calls.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength
         *        Zone control plane operations, such as API calls.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
         *        <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local
         *        Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the
         *        Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the
         * group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use
         * the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>message</code> - The Zone message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
         * <code>opt-in-not-required</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
         * <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone
         * (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local
         * Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name
         *        of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength
         *        Zones, use the name of the group associated with the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>message</code> - The Zone message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
         *        <code>opt-in-not-required</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength
         *        Zone control plane operations, such as API calls.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength
         *        Zone control plane operations, such as API calls.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
         *        <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local
         *        Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the
         *        Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
         *        <code>us-east-1-wl1-bos-wlz-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the
         * group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use
         * the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>message</code> - The Zone message.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> |
         * <code>opt-in-not-required</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone
         * control plane operations, such as API calls.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (
         * <code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone
         * (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local
         * Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example,
         * <code>us-east-1-wl1-bos-wlz-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The names of the Availability Zones, Local Zones, and Wavelength Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of the Availability Zones, Local Zones, and Wavelength Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(Collection<String> zoneNames);

        /**
         * <p>
         * The names of the Availability Zones, Local Zones, and Wavelength Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of the Availability Zones, Local Zones, and Wavelength Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(String... zoneNames);

        /**
         * <p>
         * The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
         * </p>
         * 
         * @param zoneIds
         *        The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneIds(Collection<String> zoneIds);

        /**
         * <p>
         * The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
         * </p>
         * 
         * @param zoneIds
         *        The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneIds(String... zoneIds);

        /**
         * <p>
         * Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.
         * </p>
         * <p>
         * If you do not use this parameter, the results include only the zones for the Regions where you have chosen
         * the option to opt in.
         * </p>
         * 
         * @param allAvailabilityZones
         *        Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in
         *        status.</p>
         *        <p>
         *        If you do not use this parameter, the results include only the zones for the Regions where you have
         *        chosen the option to opt in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allAvailabilityZones(Boolean allAvailabilityZones);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> zoneNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> zoneIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean allAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityZonesRequest model) {
            super(model);
            filters(model.filters);
            zoneNames(model.zoneNames);
            zoneIds(model.zoneIds);
            allAvailabilityZones(model.allAvailabilityZones);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getZoneNames() {
            if (zoneNames instanceof SdkAutoConstructList) {
                return null;
            }
            return zoneNames;
        }

        public final void setZoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
        }

        @Override
        @Transient
        public final Builder zoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder zoneNames(String... zoneNames) {
            zoneNames(Arrays.asList(zoneNames));
            return this;
        }

        public final Collection<String> getZoneIds() {
            if (zoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return zoneIds;
        }

        public final void setZoneIds(Collection<String> zoneIds) {
            this.zoneIds = ZoneIdStringListCopier.copy(zoneIds);
        }

        @Override
        @Transient
        public final Builder zoneIds(Collection<String> zoneIds) {
            this.zoneIds = ZoneIdStringListCopier.copy(zoneIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder zoneIds(String... zoneIds) {
            zoneIds(Arrays.asList(zoneIds));
            return this;
        }

        public final Boolean getAllAvailabilityZones() {
            return allAvailabilityZones;
        }

        public final void setAllAvailabilityZones(Boolean allAvailabilityZones) {
            this.allAvailabilityZones = allAvailabilityZones;
        }

        @Override
        @Transient
        public final Builder allAvailabilityZones(Boolean allAvailabilityZones) {
            this.allAvailabilityZones = allAvailabilityZones;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAvailabilityZonesRequest build() {
            return new DescribeAvailabilityZonesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
