/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLocalGatewayRouteTableResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteLocalGatewayRouteTableResponse.Builder, DeleteLocalGatewayRouteTableResponse> {
    private static final SdkField<LocalGatewayRouteTable> LOCAL_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<LocalGatewayRouteTable> builder(MarshallingType.SDK_POJO)
            .memberName("LocalGatewayRouteTable")
            .getter(getter(DeleteLocalGatewayRouteTableResponse::localGatewayRouteTable))
            .setter(setter(Builder::localGatewayRouteTable))
            .constructor(LocalGatewayRouteTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTable")
                    .unmarshallLocationName("localGatewayRouteTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_GATEWAY_ROUTE_TABLE_FIELD));

    private final LocalGatewayRouteTable localGatewayRouteTable;

    private DeleteLocalGatewayRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTable = builder.localGatewayRouteTable;
    }

    /**
     * Returns the value of the LocalGatewayRouteTable property for this object.
     * 
     * @return The value of the LocalGatewayRouteTable property for this object.
     */
    public final LocalGatewayRouteTable localGatewayRouteTable() {
        return localGatewayRouteTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLocalGatewayRouteTableResponse)) {
            return false;
        }
        DeleteLocalGatewayRouteTableResponse other = (DeleteLocalGatewayRouteTableResponse) obj;
        return Objects.equals(localGatewayRouteTable(), other.localGatewayRouteTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLocalGatewayRouteTableResponse").add("LocalGatewayRouteTable", localGatewayRouteTable())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLocalGatewayRouteTableResponse, T> g) {
        return obj -> g.apply((DeleteLocalGatewayRouteTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLocalGatewayRouteTableResponse> {
        /**
         * Sets the value of the LocalGatewayRouteTable property for this object.
         *
         * @param localGatewayRouteTable
         *        The new value for the LocalGatewayRouteTable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTable(LocalGatewayRouteTable localGatewayRouteTable);

        /**
         * Sets the value of the LocalGatewayRouteTable property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LocalGatewayRouteTable.Builder} avoiding
         * the need to create one manually via {@link LocalGatewayRouteTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalGatewayRouteTable.Builder#build()} is called immediately and
         * its result is passed to {@link #localGatewayRouteTable(LocalGatewayRouteTable)}.
         * 
         * @param localGatewayRouteTable
         *        a consumer that will call methods on {@link LocalGatewayRouteTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayRouteTable(LocalGatewayRouteTable)
         */
        default Builder localGatewayRouteTable(Consumer<LocalGatewayRouteTable.Builder> localGatewayRouteTable) {
            return localGatewayRouteTable(LocalGatewayRouteTable.builder().applyMutation(localGatewayRouteTable).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LocalGatewayRouteTable localGatewayRouteTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLocalGatewayRouteTableResponse model) {
            super(model);
            localGatewayRouteTable(model.localGatewayRouteTable);
        }

        public final LocalGatewayRouteTable.Builder getLocalGatewayRouteTable() {
            return localGatewayRouteTable != null ? localGatewayRouteTable.toBuilder() : null;
        }

        public final void setLocalGatewayRouteTable(LocalGatewayRouteTable.BuilderImpl localGatewayRouteTable) {
            this.localGatewayRouteTable = localGatewayRouteTable != null ? localGatewayRouteTable.build() : null;
        }

        @Override
        public final Builder localGatewayRouteTable(LocalGatewayRouteTable localGatewayRouteTable) {
            this.localGatewayRouteTable = localGatewayRouteTable;
            return this;
        }

        @Override
        public DeleteLocalGatewayRouteTableResponse build() {
            return new DeleteLocalGatewayRouteTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
