/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an additional detail for a path analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalDetail.Builder, AdditionalDetail> {
    private static final SdkField<String> ADDITIONAL_DETAIL_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AdditionalDetailType")
            .getter(getter(AdditionalDetail::additionalDetailType))
            .setter(setter(Builder::additionalDetailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetailType")
                    .unmarshallLocationName("additionalDetailType").build()).build();

    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Component")
            .getter(getter(AdditionalDetail::component))
            .setter(setter(Builder::component))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component")
                    .unmarshallLocationName("component").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_DETAIL_TYPE_FIELD,
            COMPONENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String additionalDetailType;

    private final AnalysisComponent component;

    private AdditionalDetail(BuilderImpl builder) {
        this.additionalDetailType = builder.additionalDetailType;
        this.component = builder.component;
    }

    /**
     * <p>
     * The information type.
     * </p>
     * 
     * @return The information type.
     */
    public final String additionalDetailType() {
        return additionalDetailType;
    }

    /**
     * <p>
     * The path component.
     * </p>
     * 
     * @return The path component.
     */
    public final AnalysisComponent component() {
        return component;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalDetailType());
        hashCode = 31 * hashCode + Objects.hashCode(component());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalDetail)) {
            return false;
        }
        AdditionalDetail other = (AdditionalDetail) obj;
        return Objects.equals(additionalDetailType(), other.additionalDetailType())
                && Objects.equals(component(), other.component());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalDetail").add("AdditionalDetailType", additionalDetailType())
                .add("Component", component()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalDetailType":
            return Optional.ofNullable(clazz.cast(additionalDetailType()));
        case "Component":
            return Optional.ofNullable(clazz.cast(component()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalDetail, T> g) {
        return obj -> g.apply((AdditionalDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalDetail> {
        /**
         * <p>
         * The information type.
         * </p>
         * 
         * @param additionalDetailType
         *        The information type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetailType(String additionalDetailType);

        /**
         * <p>
         * The path component.
         * </p>
         * 
         * @param component
         *        The path component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(AnalysisComponent component);

        /**
         * <p>
         * The path component.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #component(AnalysisComponent)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(AnalysisComponent)
         */
        default Builder component(Consumer<AnalysisComponent.Builder> component) {
            return component(AnalysisComponent.builder().applyMutation(component).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String additionalDetailType;

        private AnalysisComponent component;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalDetail model) {
            additionalDetailType(model.additionalDetailType);
            component(model.component);
        }

        public final String getAdditionalDetailType() {
            return additionalDetailType;
        }

        public final void setAdditionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
        }

        @Override
        public final Builder additionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        @Override
        public AdditionalDetail build() {
            return new AdditionalDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
