/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnConnectionOptionsSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnConnectionOptionsSpecification.Builder, VpnConnectionOptionsSpecification> {
    private static final SdkField<Boolean> ENABLE_ACCELERATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableAcceleration")
            .getter(getter(VpnConnectionOptionsSpecification::enableAcceleration))
            .setter(setter(Builder::enableAcceleration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleration")
                    .unmarshallLocationName("EnableAcceleration").build()).build();

    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StaticRoutesOnly")
            .getter(getter(VpnConnectionOptionsSpecification::staticRoutesOnly))
            .setter(setter(Builder::staticRoutesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly")
                    .unmarshallLocationName("staticRoutesOnly").build()).build();

    private static final SdkField<String> TUNNEL_INSIDE_IP_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TunnelInsideIpVersion")
            .getter(getter(VpnConnectionOptionsSpecification::tunnelInsideIpVersionAsString))
            .setter(setter(Builder::tunnelInsideIpVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpVersion")
                    .unmarshallLocationName("TunnelInsideIpVersion").build()).build();

    private static final SdkField<List<VpnTunnelOptionsSpecification>> TUNNEL_OPTIONS_FIELD = SdkField
            .<List<VpnTunnelOptionsSpecification>> builder(MarshallingType.LIST)
            .memberName("TunnelOptions")
            .getter(getter(VpnConnectionOptionsSpecification::tunnelOptions))
            .setter(setter(Builder::tunnelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions")
                    .unmarshallLocationName("TunnelOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpnTunnelOptionsSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpnTunnelOptionsSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv4NetworkCidr")
            .getter(getter(VpnConnectionOptionsSpecification::localIpv4NetworkCidr))
            .setter(setter(Builder::localIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr")
                    .unmarshallLocationName("LocalIpv4NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv4NetworkCidr")
            .getter(getter(VpnConnectionOptionsSpecification::remoteIpv4NetworkCidr))
            .setter(setter(Builder::remoteIpv4NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr")
                    .unmarshallLocationName("RemoteIpv4NetworkCidr").build()).build();

    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalIpv6NetworkCidr")
            .getter(getter(VpnConnectionOptionsSpecification::localIpv6NetworkCidr))
            .setter(setter(Builder::localIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr")
                    .unmarshallLocationName("LocalIpv6NetworkCidr").build()).build();

    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RemoteIpv6NetworkCidr")
            .getter(getter(VpnConnectionOptionsSpecification::remoteIpv6NetworkCidr))
            .setter(setter(Builder::remoteIpv6NetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr")
                    .unmarshallLocationName("RemoteIpv6NetworkCidr").build()).build();

    private static final SdkField<String> OUTSIDE_IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutsideIpAddressType")
            .getter(getter(VpnConnectionOptionsSpecification::outsideIpAddressType))
            .setter(setter(Builder::outsideIpAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddressType")
                    .unmarshallLocationName("OutsideIpAddressType").build()).build();

    private static final SdkField<String> TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransportTransitGatewayAttachmentId")
            .getter(getter(VpnConnectionOptionsSpecification::transportTransitGatewayAttachmentId))
            .setter(setter(Builder::transportTransitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransportTransitGatewayAttachmentId")
                    .unmarshallLocationName("TransportTransitGatewayAttachmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCELERATION_FIELD,
            STATIC_ROUTES_ONLY_FIELD, TUNNEL_INSIDE_IP_VERSION_FIELD, TUNNEL_OPTIONS_FIELD, LOCAL_IPV4_NETWORK_CIDR_FIELD,
            REMOTE_IPV4_NETWORK_CIDR_FIELD, LOCAL_IPV6_NETWORK_CIDR_FIELD, REMOTE_IPV6_NETWORK_CIDR_FIELD,
            OUTSIDE_IP_ADDRESS_TYPE_FIELD, TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableAcceleration;

    private final Boolean staticRoutesOnly;

    private final String tunnelInsideIpVersion;

    private final List<VpnTunnelOptionsSpecification> tunnelOptions;

    private final String localIpv4NetworkCidr;

    private final String remoteIpv4NetworkCidr;

    private final String localIpv6NetworkCidr;

    private final String remoteIpv6NetworkCidr;

    private final String outsideIpAddressType;

    private final String transportTransitGatewayAttachmentId;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.enableAcceleration = builder.enableAcceleration;
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelInsideIpVersion = builder.tunnelInsideIpVersion;
        this.tunnelOptions = builder.tunnelOptions;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
        this.outsideIpAddressType = builder.outsideIpAddressType;
        this.transportTransitGatewayAttachmentId = builder.transportTransitGatewayAttachmentId;
    }

    /**
     * <p>
     * Indicate whether to enable acceleration for the VPN connection.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicate whether to enable acceleration for the VPN connection.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean enableAcceleration() {
        return enableAcceleration;
    }

    /**
     * <p>
     * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device
     * that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to create a
     * static route.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
     *         device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a>
     *         to create a static route.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    /**
     * <p>
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     * </p>
     * <p>
     * Default: <code>ipv4</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tunnelInsideIpVersion} will return {@link TunnelInsideIpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tunnelInsideIpVersionAsString}.
     * </p>
     * 
     * @return Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
     *         <p>
     *         Default: <code>ipv4</code>
     * @see TunnelInsideIpVersion
     */
    public final TunnelInsideIpVersion tunnelInsideIpVersion() {
        return TunnelInsideIpVersion.fromValue(tunnelInsideIpVersion);
    }

    /**
     * <p>
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     * </p>
     * <p>
     * Default: <code>ipv4</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tunnelInsideIpVersion} will return {@link TunnelInsideIpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tunnelInsideIpVersionAsString}.
     * </p>
     * 
     * @return Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
     *         <p>
     *         Default: <code>ipv4</code>
     * @see TunnelInsideIpVersion
     */
    public final String tunnelInsideIpVersionAsString() {
        return tunnelInsideIpVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the TunnelOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTunnelOptions() {
        return tunnelOptions != null && !(tunnelOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tunnel options for the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTunnelOptions} method.
     * </p>
     * 
     * @return The tunnel options for the VPN connection.
     */
    public final List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return tunnelOptions;
    }

    /**
     * <p>
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * </p>
     * 
     * @return The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>
     *         Default: <code>0.0.0.0/0</code>
     */
    public final String localIpv4NetworkCidr() {
        return localIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * </p>
     * 
     * @return The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>
     *         Default: <code>0.0.0.0/0</code>
     */
    public final String remoteIpv4NetworkCidr() {
        return remoteIpv4NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>::/0</code>
     * </p>
     * 
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>
     *         Default: <code>::/0</code>
     */
    public final String localIpv6NetworkCidr() {
        return localIpv6NetworkCidr;
    }

    /**
     * <p>
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     * </p>
     * <p>
     * Default: <code>::/0</code>
     * </p>
     * 
     * @return The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>
     *         Default: <code>::/0</code>
     */
    public final String remoteIpv6NetworkCidr() {
        return remoteIpv6NetworkCidr;
    }

    /**
     * <p>
     * The type of IPv4 address assigned to the outside interface of the customer gateway device.
     * </p>
     * <p>
     * Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
     * </p>
     * <p>
     * Default: <code>PublicIpv4</code>
     * </p>
     * 
     * @return The type of IPv4 address assigned to the outside interface of the customer gateway device.</p>
     *         <p>
     *         Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
     *         </p>
     *         <p>
     *         Default: <code>PublicIpv4</code>
     */
    public final String outsideIpAddressType() {
        return outsideIpAddressType;
    }

    /**
     * <p>
     * The transit gateway attachment ID to use for the VPN tunnel.
     * </p>
     * <p>
     * Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code>.
     * </p>
     * 
     * @return The transit gateway attachment ID to use for the VPN tunnel.</p>
     *         <p>
     *         Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code>.
     */
    public final String transportTransitGatewayAttachmentId() {
        return transportTransitGatewayAttachmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableAcceleration());
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelInsideIpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTunnelOptions() ? tunnelOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(outsideIpAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(transportTransitGatewayAttachmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification) obj;
        return Objects.equals(enableAcceleration(), other.enableAcceleration())
                && Objects.equals(staticRoutesOnly(), other.staticRoutesOnly())
                && Objects.equals(tunnelInsideIpVersionAsString(), other.tunnelInsideIpVersionAsString())
                && hasTunnelOptions() == other.hasTunnelOptions() && Objects.equals(tunnelOptions(), other.tunnelOptions())
                && Objects.equals(localIpv4NetworkCidr(), other.localIpv4NetworkCidr())
                && Objects.equals(remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr())
                && Objects.equals(localIpv6NetworkCidr(), other.localIpv6NetworkCidr())
                && Objects.equals(remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr())
                && Objects.equals(outsideIpAddressType(), other.outsideIpAddressType())
                && Objects.equals(transportTransitGatewayAttachmentId(), other.transportTransitGatewayAttachmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnConnectionOptionsSpecification").add("EnableAcceleration", enableAcceleration())
                .add("StaticRoutesOnly", staticRoutesOnly()).add("TunnelInsideIpVersion", tunnelInsideIpVersionAsString())
                .add("TunnelOptions", hasTunnelOptions() ? tunnelOptions() : null)
                .add("LocalIpv4NetworkCidr", localIpv4NetworkCidr()).add("RemoteIpv4NetworkCidr", remoteIpv4NetworkCidr())
                .add("LocalIpv6NetworkCidr", localIpv6NetworkCidr()).add("RemoteIpv6NetworkCidr", remoteIpv6NetworkCidr())
                .add("OutsideIpAddressType", outsideIpAddressType())
                .add("TransportTransitGatewayAttachmentId", transportTransitGatewayAttachmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableAcceleration":
            return Optional.ofNullable(clazz.cast(enableAcceleration()));
        case "StaticRoutesOnly":
            return Optional.ofNullable(clazz.cast(staticRoutesOnly()));
        case "TunnelInsideIpVersion":
            return Optional.ofNullable(clazz.cast(tunnelInsideIpVersionAsString()));
        case "TunnelOptions":
            return Optional.ofNullable(clazz.cast(tunnelOptions()));
        case "LocalIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv4NetworkCidr()));
        case "RemoteIpv4NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv4NetworkCidr()));
        case "LocalIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(localIpv6NetworkCidr()));
        case "RemoteIpv6NetworkCidr":
            return Optional.ofNullable(clazz.cast(remoteIpv6NetworkCidr()));
        case "OutsideIpAddressType":
            return Optional.ofNullable(clazz.cast(outsideIpAddressType()));
        case "TransportTransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transportTransitGatewayAttachmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptionsSpecification, T> g) {
        return obj -> g.apply((VpnConnectionOptionsSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        /**
         * <p>
         * Indicate whether to enable acceleration for the VPN connection.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param enableAcceleration
         *        Indicate whether to enable acceleration for the VPN connection.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAcceleration(Boolean enableAcceleration);

        /**
         * <p>
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
         * device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to
         * create a static route.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param staticRoutesOnly
         *        Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for
         *        a device that does not support BGP, you must specify <code>true</code>. Use
         *        <a>CreateVpnConnectionRoute</a> to create a static route.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);

        /**
         * <p>
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         * </p>
         * <p>
         * Default: <code>ipv4</code>
         * </p>
         * 
         * @param tunnelInsideIpVersion
         *        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
         *        <p>
         *        Default: <code>ipv4</code>
         * @see TunnelInsideIpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelInsideIpVersion
         */
        Builder tunnelInsideIpVersion(String tunnelInsideIpVersion);

        /**
         * <p>
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         * </p>
         * <p>
         * Default: <code>ipv4</code>
         * </p>
         * 
         * @param tunnelInsideIpVersion
         *        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
         *        <p>
         *        Default: <code>ipv4</code>
         * @see TunnelInsideIpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelInsideIpVersion
         */
        Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <VpnTunnelOptionsSpecification>.Builder} avoiding the need to create one manually via {@link List
         * <VpnTunnelOptionsSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpnTunnelOptionsSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #tunnelOptions(List<VpnTunnelOptionsSpecification>)}.
         * 
         * @param tunnelOptions
         *        a consumer that will call methods on {@link List<VpnTunnelOptionsSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelOptions(List<VpnTunnelOptionsSpecification>)
         */
        Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder>... tunnelOptions);

        /**
         * <p>
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * </p>
         * 
         * @param localIpv4NetworkCidr
         *        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
         *        <p>
         *        Default: <code>0.0.0.0/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv4NetworkCidr(String localIpv4NetworkCidr);

        /**
         * <p>
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * </p>
         * 
         * @param remoteIpv4NetworkCidr
         *        The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
         *        <p>
         *        Default: <code>0.0.0.0/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>::/0</code>
         * </p>
         * 
         * @param localIpv6NetworkCidr
         *        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
         *        <p>
         *        Default: <code>::/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpv6NetworkCidr(String localIpv6NetworkCidr);

        /**
         * <p>
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         * </p>
         * <p>
         * Default: <code>::/0</code>
         * </p>
         * 
         * @param remoteIpv6NetworkCidr
         *        The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
         *        <p>
         *        Default: <code>::/0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr);

        /**
         * <p>
         * The type of IPv4 address assigned to the outside interface of the customer gateway device.
         * </p>
         * <p>
         * Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
         * </p>
         * <p>
         * Default: <code>PublicIpv4</code>
         * </p>
         * 
         * @param outsideIpAddressType
         *        The type of IPv4 address assigned to the outside interface of the customer gateway device.</p>
         *        <p>
         *        Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
         *        </p>
         *        <p>
         *        Default: <code>PublicIpv4</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outsideIpAddressType(String outsideIpAddressType);

        /**
         * <p>
         * The transit gateway attachment ID to use for the VPN tunnel.
         * </p>
         * <p>
         * Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code>.
         * </p>
         * 
         * @param transportTransitGatewayAttachmentId
         *        The transit gateway attachment ID to use for the VPN tunnel.</p>
         *        <p>
         *        Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableAcceleration;

        private Boolean staticRoutesOnly;

        private String tunnelInsideIpVersion;

        private List<VpnTunnelOptionsSpecification> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private String localIpv4NetworkCidr;

        private String remoteIpv4NetworkCidr;

        private String localIpv6NetworkCidr;

        private String remoteIpv6NetworkCidr;

        private String outsideIpAddressType;

        private String transportTransitGatewayAttachmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            enableAcceleration(model.enableAcceleration);
            staticRoutesOnly(model.staticRoutesOnly);
            tunnelInsideIpVersion(model.tunnelInsideIpVersion);
            tunnelOptions(model.tunnelOptions);
            localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
            outsideIpAddressType(model.outsideIpAddressType);
            transportTransitGatewayAttachmentId(model.transportTransitGatewayAttachmentId);
        }

        public final Boolean getEnableAcceleration() {
            return enableAcceleration;
        }

        public final void setEnableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
        }

        @Override
        public final Builder enableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final String getTunnelInsideIpVersion() {
            return tunnelInsideIpVersion;
        }

        public final void setTunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
        }

        @Override
        public final Builder tunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        @Override
        public final Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion(tunnelInsideIpVersion == null ? null : tunnelInsideIpVersion.toString());
            return this;
        }

        public final List<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            List<VpnTunnelOptionsSpecification.Builder> result = VpnTunnelOptionsSpecificationsListCopier
                    .copyToBuilder(this.tunnelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions) {
            tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder>... tunnelOptions) {
            tunnelOptions(Stream.of(tunnelOptions).map(c -> VpnTunnelOptionsSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLocalIpv4NetworkCidr() {
            return localIpv4NetworkCidr;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        @Override
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return remoteIpv4NetworkCidr;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        @Override
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final String getLocalIpv6NetworkCidr() {
            return localIpv6NetworkCidr;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        @Override
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return remoteIpv6NetworkCidr;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        @Override
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        public final String getOutsideIpAddressType() {
            return outsideIpAddressType;
        }

        public final void setOutsideIpAddressType(String outsideIpAddressType) {
            this.outsideIpAddressType = outsideIpAddressType;
        }

        @Override
        public final Builder outsideIpAddressType(String outsideIpAddressType) {
            this.outsideIpAddressType = outsideIpAddressType;
            return this;
        }

        public final String getTransportTransitGatewayAttachmentId() {
            return transportTransitGatewayAttachmentId;
        }

        public final void setTransportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
        }

        @Override
        public final Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        @Override
        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
