/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectTransitGatewayPeeringAttachmentResponse extends Ec2Response implements
        ToCopyableBuilder<RejectTransitGatewayPeeringAttachmentResponse.Builder, RejectTransitGatewayPeeringAttachmentResponse> {
    private static final SdkField<TransitGatewayPeeringAttachment> TRANSIT_GATEWAY_PEERING_ATTACHMENT_FIELD = SdkField
            .<TransitGatewayPeeringAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayPeeringAttachment")
            .getter(getter(RejectTransitGatewayPeeringAttachmentResponse::transitGatewayPeeringAttachment))
            .setter(setter(Builder::transitGatewayPeeringAttachment))
            .constructor(TransitGatewayPeeringAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPeeringAttachment")
                    .unmarshallLocationName("transitGatewayPeeringAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_PEERING_ATTACHMENT_FIELD));

    private final TransitGatewayPeeringAttachment transitGatewayPeeringAttachment;

    private RejectTransitGatewayPeeringAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPeeringAttachment = builder.transitGatewayPeeringAttachment;
    }

    /**
     * <p>
     * The transit gateway peering attachment.
     * </p>
     * 
     * @return The transit gateway peering attachment.
     */
    public final TransitGatewayPeeringAttachment transitGatewayPeeringAttachment() {
        return transitGatewayPeeringAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPeeringAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectTransitGatewayPeeringAttachmentResponse)) {
            return false;
        }
        RejectTransitGatewayPeeringAttachmentResponse other = (RejectTransitGatewayPeeringAttachmentResponse) obj;
        return Objects.equals(transitGatewayPeeringAttachment(), other.transitGatewayPeeringAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectTransitGatewayPeeringAttachmentResponse")
                .add("TransitGatewayPeeringAttachment", transitGatewayPeeringAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayPeeringAttachment":
            return Optional.ofNullable(clazz.cast(transitGatewayPeeringAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectTransitGatewayPeeringAttachmentResponse, T> g) {
        return obj -> g.apply((RejectTransitGatewayPeeringAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, RejectTransitGatewayPeeringAttachmentResponse> {
        /**
         * <p>
         * The transit gateway peering attachment.
         * </p>
         * 
         * @param transitGatewayPeeringAttachment
         *        The transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment transitGatewayPeeringAttachment);

        /**
         * <p>
         * The transit gateway peering attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayPeeringAttachment.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayPeeringAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayPeeringAttachment.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment)}.
         * 
         * @param transitGatewayPeeringAttachment
         *        a consumer that will call methods on {@link TransitGatewayPeeringAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment)
         */
        default Builder transitGatewayPeeringAttachment(
                Consumer<TransitGatewayPeeringAttachment.Builder> transitGatewayPeeringAttachment) {
            return transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment.builder()
                    .applyMutation(transitGatewayPeeringAttachment).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayPeeringAttachment transitGatewayPeeringAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectTransitGatewayPeeringAttachmentResponse model) {
            super(model);
            transitGatewayPeeringAttachment(model.transitGatewayPeeringAttachment);
        }

        public final TransitGatewayPeeringAttachment.Builder getTransitGatewayPeeringAttachment() {
            return transitGatewayPeeringAttachment != null ? transitGatewayPeeringAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayPeeringAttachment(
                TransitGatewayPeeringAttachment.BuilderImpl transitGatewayPeeringAttachment) {
            this.transitGatewayPeeringAttachment = transitGatewayPeeringAttachment != null ? transitGatewayPeeringAttachment
                    .build() : null;
        }

        @Override
        public final Builder transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment transitGatewayPeeringAttachment) {
            this.transitGatewayPeeringAttachment = transitGatewayPeeringAttachment;
            return this;
        }

        @Override
        public RejectTransitGatewayPeeringAttachmentResponse build() {
            return new RejectTransitGatewayPeeringAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
