/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathComponent implements SdkPojo, Serializable, ToCopyableBuilder<PathComponent.Builder, PathComponent> {
    private static final SdkField<Integer> SEQUENCE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SequenceNumber")
            .getter(getter(PathComponent::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber")
                    .unmarshallLocationName("sequenceNumber").build()).build();

    private static final SdkField<AnalysisAclRule> ACL_RULE_FIELD = SdkField
            .<AnalysisAclRule> builder(MarshallingType.SDK_POJO)
            .memberName("AclRule")
            .getter(getter(PathComponent::aclRule))
            .setter(setter(Builder::aclRule))
            .constructor(AnalysisAclRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclRule")
                    .unmarshallLocationName("aclRule").build()).build();

    private static final SdkField<AnalysisComponent> ATTACHED_TO_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("AttachedTo")
            .getter(getter(PathComponent::attachedTo))
            .setter(setter(Builder::attachedTo))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedTo")
                    .unmarshallLocationName("attachedTo").build()).build();

    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Component")
            .getter(getter(PathComponent::component))
            .setter(setter(Builder::component))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component")
                    .unmarshallLocationName("component").build()).build();

    private static final SdkField<AnalysisComponent> DESTINATION_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationVpc")
            .getter(getter(PathComponent::destinationVpc))
            .setter(setter(Builder::destinationVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationVpc")
                    .unmarshallLocationName("destinationVpc").build()).build();

    private static final SdkField<AnalysisPacketHeader> OUTBOUND_HEADER_FIELD = SdkField
            .<AnalysisPacketHeader> builder(MarshallingType.SDK_POJO)
            .memberName("OutboundHeader")
            .getter(getter(PathComponent::outboundHeader))
            .setter(setter(Builder::outboundHeader))
            .constructor(AnalysisPacketHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHeader")
                    .unmarshallLocationName("outboundHeader").build()).build();

    private static final SdkField<AnalysisPacketHeader> INBOUND_HEADER_FIELD = SdkField
            .<AnalysisPacketHeader> builder(MarshallingType.SDK_POJO)
            .memberName("InboundHeader")
            .getter(getter(PathComponent::inboundHeader))
            .setter(setter(Builder::inboundHeader))
            .constructor(AnalysisPacketHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundHeader")
                    .unmarshallLocationName("inboundHeader").build()).build();

    private static final SdkField<AnalysisRouteTableRoute> ROUTE_TABLE_ROUTE_FIELD = SdkField
            .<AnalysisRouteTableRoute> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableRoute")
            .getter(getter(PathComponent::routeTableRoute))
            .setter(setter(Builder::routeTableRoute))
            .constructor(AnalysisRouteTableRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableRoute")
                    .unmarshallLocationName("routeTableRoute").build()).build();

    private static final SdkField<AnalysisSecurityGroupRule> SECURITY_GROUP_RULE_FIELD = SdkField
            .<AnalysisSecurityGroupRule> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityGroupRule")
            .getter(getter(PathComponent::securityGroupRule))
            .setter(setter(Builder::securityGroupRule))
            .constructor(AnalysisSecurityGroupRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule")
                    .unmarshallLocationName("securityGroupRule").build()).build();

    private static final SdkField<AnalysisComponent> SOURCE_VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("SourceVpc")
            .getter(getter(PathComponent::sourceVpc))
            .setter(setter(Builder::sourceVpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVpc")
                    .unmarshallLocationName("sourceVpc").build()).build();

    private static final SdkField<AnalysisComponent> SUBNET_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Subnet")
            .getter(getter(PathComponent::subnet))
            .setter(setter(Builder::subnet))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet")
                    .unmarshallLocationName("subnet").build()).build();

    private static final SdkField<AnalysisComponent> VPC_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc")
            .getter(getter(PathComponent::vpc))
            .setter(setter(Builder::vpc))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc")
                    .build()).build();

    private static final SdkField<List<AdditionalDetail>> ADDITIONAL_DETAILS_FIELD = SdkField
            .<List<AdditionalDetail>> builder(MarshallingType.LIST)
            .memberName("AdditionalDetails")
            .getter(getter(PathComponent::additionalDetails))
            .setter(setter(Builder::additionalDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetailSet")
                    .unmarshallLocationName("additionalDetailSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AdditionalDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AnalysisComponent> TRANSIT_GATEWAY_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGateway")
            .getter(getter(PathComponent::transitGateway))
            .setter(setter(Builder::transitGateway))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGateway")
                    .unmarshallLocationName("transitGateway").build()).build();

    private static final SdkField<TransitGatewayRouteTableRoute> TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD = SdkField
            .<TransitGatewayRouteTableRoute> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayRouteTableRoute")
            .getter(getter(PathComponent::transitGatewayRouteTableRoute))
            .setter(setter(Builder::transitGatewayRouteTableRoute))
            .constructor(TransitGatewayRouteTableRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableRoute")
                    .unmarshallLocationName("transitGatewayRouteTableRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_NUMBER_FIELD,
            ACL_RULE_FIELD, ATTACHED_TO_FIELD, COMPONENT_FIELD, DESTINATION_VPC_FIELD, OUTBOUND_HEADER_FIELD,
            INBOUND_HEADER_FIELD, ROUTE_TABLE_ROUTE_FIELD, SECURITY_GROUP_RULE_FIELD, SOURCE_VPC_FIELD, SUBNET_FIELD, VPC_FIELD,
            ADDITIONAL_DETAILS_FIELD, TRANSIT_GATEWAY_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ROUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sequenceNumber;

    private final AnalysisAclRule aclRule;

    private final AnalysisComponent attachedTo;

    private final AnalysisComponent component;

    private final AnalysisComponent destinationVpc;

    private final AnalysisPacketHeader outboundHeader;

    private final AnalysisPacketHeader inboundHeader;

    private final AnalysisRouteTableRoute routeTableRoute;

    private final AnalysisSecurityGroupRule securityGroupRule;

    private final AnalysisComponent sourceVpc;

    private final AnalysisComponent subnet;

    private final AnalysisComponent vpc;

    private final List<AdditionalDetail> additionalDetails;

    private final AnalysisComponent transitGateway;

    private final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;

    private PathComponent(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.aclRule = builder.aclRule;
        this.attachedTo = builder.attachedTo;
        this.component = builder.component;
        this.destinationVpc = builder.destinationVpc;
        this.outboundHeader = builder.outboundHeader;
        this.inboundHeader = builder.inboundHeader;
        this.routeTableRoute = builder.routeTableRoute;
        this.securityGroupRule = builder.securityGroupRule;
        this.sourceVpc = builder.sourceVpc;
        this.subnet = builder.subnet;
        this.vpc = builder.vpc;
        this.additionalDetails = builder.additionalDetails;
        this.transitGateway = builder.transitGateway;
        this.transitGatewayRouteTableRoute = builder.transitGatewayRouteTableRoute;
    }

    /**
     * <p>
     * The sequence number.
     * </p>
     * 
     * @return The sequence number.
     */
    public final Integer sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The network ACL rule.
     * </p>
     * 
     * @return The network ACL rule.
     */
    public final AnalysisAclRule aclRule() {
        return aclRule;
    }

    /**
     * <p>
     * The resource to which the path component is attached.
     * </p>
     * 
     * @return The resource to which the path component is attached.
     */
    public final AnalysisComponent attachedTo() {
        return attachedTo;
    }

    /**
     * <p>
     * The component.
     * </p>
     * 
     * @return The component.
     */
    public final AnalysisComponent component() {
        return component;
    }

    /**
     * <p>
     * The destination VPC.
     * </p>
     * 
     * @return The destination VPC.
     */
    public final AnalysisComponent destinationVpc() {
        return destinationVpc;
    }

    /**
     * <p>
     * The outbound header.
     * </p>
     * 
     * @return The outbound header.
     */
    public final AnalysisPacketHeader outboundHeader() {
        return outboundHeader;
    }

    /**
     * <p>
     * The inbound header.
     * </p>
     * 
     * @return The inbound header.
     */
    public final AnalysisPacketHeader inboundHeader() {
        return inboundHeader;
    }

    /**
     * <p>
     * The route table route.
     * </p>
     * 
     * @return The route table route.
     */
    public final AnalysisRouteTableRoute routeTableRoute() {
        return routeTableRoute;
    }

    /**
     * <p>
     * The security group rule.
     * </p>
     * 
     * @return The security group rule.
     */
    public final AnalysisSecurityGroupRule securityGroupRule() {
        return securityGroupRule;
    }

    /**
     * <p>
     * The source VPC.
     * </p>
     * 
     * @return The source VPC.
     */
    public final AnalysisComponent sourceVpc() {
        return sourceVpc;
    }

    /**
     * <p>
     * The subnet.
     * </p>
     * 
     * @return The subnet.
     */
    public final AnalysisComponent subnet() {
        return subnet;
    }

    /**
     * <p>
     * The component VPC.
     * </p>
     * 
     * @return The component VPC.
     */
    public final AnalysisComponent vpc() {
        return vpc;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalDetails() {
        return additionalDetails != null && !(additionalDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalDetails} method.
     * </p>
     * 
     * @return The additional details.
     */
    public final List<AdditionalDetail> additionalDetails() {
        return additionalDetails;
    }

    /**
     * <p>
     * The transit gateway.
     * </p>
     * 
     * @return The transit gateway.
     */
    public final AnalysisComponent transitGateway() {
        return transitGateway;
    }

    /**
     * <p>
     * The route in a transit gateway route table.
     * </p>
     * 
     * @return The route in a transit gateway route table.
     */
    public final TransitGatewayRouteTableRoute transitGatewayRouteTableRoute() {
        return transitGatewayRouteTableRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(aclRule());
        hashCode = 31 * hashCode + Objects.hashCode(attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(component());
        hashCode = 31 * hashCode + Objects.hashCode(destinationVpc());
        hashCode = 31 * hashCode + Objects.hashCode(outboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(inboundHeader());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableRoute());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRule());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVpc());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalDetails() ? additionalDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitGateway());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent) obj;
        return Objects.equals(sequenceNumber(), other.sequenceNumber()) && Objects.equals(aclRule(), other.aclRule())
                && Objects.equals(attachedTo(), other.attachedTo()) && Objects.equals(component(), other.component())
                && Objects.equals(destinationVpc(), other.destinationVpc())
                && Objects.equals(outboundHeader(), other.outboundHeader())
                && Objects.equals(inboundHeader(), other.inboundHeader())
                && Objects.equals(routeTableRoute(), other.routeTableRoute())
                && Objects.equals(securityGroupRule(), other.securityGroupRule())
                && Objects.equals(sourceVpc(), other.sourceVpc()) && Objects.equals(subnet(), other.subnet())
                && Objects.equals(vpc(), other.vpc()) && hasAdditionalDetails() == other.hasAdditionalDetails()
                && Objects.equals(additionalDetails(), other.additionalDetails())
                && Objects.equals(transitGateway(), other.transitGateway())
                && Objects.equals(transitGatewayRouteTableRoute(), other.transitGatewayRouteTableRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathComponent").add("SequenceNumber", sequenceNumber()).add("AclRule", aclRule())
                .add("AttachedTo", attachedTo()).add("Component", component()).add("DestinationVpc", destinationVpc())
                .add("OutboundHeader", outboundHeader()).add("InboundHeader", inboundHeader())
                .add("RouteTableRoute", routeTableRoute()).add("SecurityGroupRule", securityGroupRule())
                .add("SourceVpc", sourceVpc()).add("Subnet", subnet()).add("Vpc", vpc())
                .add("AdditionalDetails", hasAdditionalDetails() ? additionalDetails() : null)
                .add("TransitGateway", transitGateway()).add("TransitGatewayRouteTableRoute", transitGatewayRouteTableRoute())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "AclRule":
            return Optional.ofNullable(clazz.cast(aclRule()));
        case "AttachedTo":
            return Optional.ofNullable(clazz.cast(attachedTo()));
        case "Component":
            return Optional.ofNullable(clazz.cast(component()));
        case "DestinationVpc":
            return Optional.ofNullable(clazz.cast(destinationVpc()));
        case "OutboundHeader":
            return Optional.ofNullable(clazz.cast(outboundHeader()));
        case "InboundHeader":
            return Optional.ofNullable(clazz.cast(inboundHeader()));
        case "RouteTableRoute":
            return Optional.ofNullable(clazz.cast(routeTableRoute()));
        case "SecurityGroupRule":
            return Optional.ofNullable(clazz.cast(securityGroupRule()));
        case "SourceVpc":
            return Optional.ofNullable(clazz.cast(sourceVpc()));
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "AdditionalDetails":
            return Optional.ofNullable(clazz.cast(additionalDetails()));
        case "TransitGateway":
            return Optional.ofNullable(clazz.cast(transitGateway()));
        case "TransitGatewayRouteTableRoute":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathComponent, T> g) {
        return obj -> g.apply((PathComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathComponent> {
        /**
         * <p>
         * The sequence number.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(Integer sequenceNumber);

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * 
         * @param aclRule
         *        The network ACL rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclRule(AnalysisAclRule aclRule);

        /**
         * <p>
         * The network ACL rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisAclRule.Builder} avoiding the
         * need to create one manually via {@link AnalysisAclRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisAclRule.Builder#build()} is called immediately and its
         * result is passed to {@link #aclRule(AnalysisAclRule)}.
         * 
         * @param aclRule
         *        a consumer that will call methods on {@link AnalysisAclRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aclRule(AnalysisAclRule)
         */
        default Builder aclRule(Consumer<AnalysisAclRule.Builder> aclRule) {
            return aclRule(AnalysisAclRule.builder().applyMutation(aclRule).build());
        }

        /**
         * <p>
         * The resource to which the path component is attached.
         * </p>
         * 
         * @param attachedTo
         *        The resource to which the path component is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedTo(AnalysisComponent attachedTo);

        /**
         * <p>
         * The resource to which the path component is attached.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #attachedTo(AnalysisComponent)}.
         * 
         * @param attachedTo
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedTo(AnalysisComponent)
         */
        default Builder attachedTo(Consumer<AnalysisComponent.Builder> attachedTo) {
            return attachedTo(AnalysisComponent.builder().applyMutation(attachedTo).build());
        }

        /**
         * <p>
         * The component.
         * </p>
         * 
         * @param component
         *        The component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(AnalysisComponent component);

        /**
         * <p>
         * The component.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #component(AnalysisComponent)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(AnalysisComponent)
         */
        default Builder component(Consumer<AnalysisComponent.Builder> component) {
            return component(AnalysisComponent.builder().applyMutation(component).build());
        }

        /**
         * <p>
         * The destination VPC.
         * </p>
         * 
         * @param destinationVpc
         *        The destination VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationVpc(AnalysisComponent destinationVpc);

        /**
         * <p>
         * The destination VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationVpc(AnalysisComponent)}.
         * 
         * @param destinationVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationVpc(AnalysisComponent)
         */
        default Builder destinationVpc(Consumer<AnalysisComponent.Builder> destinationVpc) {
            return destinationVpc(AnalysisComponent.builder().applyMutation(destinationVpc).build());
        }

        /**
         * <p>
         * The outbound header.
         * </p>
         * 
         * @param outboundHeader
         *        The outbound header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundHeader(AnalysisPacketHeader outboundHeader);

        /**
         * <p>
         * The outbound header.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisPacketHeader.Builder} avoiding
         * the need to create one manually via {@link AnalysisPacketHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisPacketHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundHeader(AnalysisPacketHeader)}.
         * 
         * @param outboundHeader
         *        a consumer that will call methods on {@link AnalysisPacketHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundHeader(AnalysisPacketHeader)
         */
        default Builder outboundHeader(Consumer<AnalysisPacketHeader.Builder> outboundHeader) {
            return outboundHeader(AnalysisPacketHeader.builder().applyMutation(outboundHeader).build());
        }

        /**
         * <p>
         * The inbound header.
         * </p>
         * 
         * @param inboundHeader
         *        The inbound header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundHeader(AnalysisPacketHeader inboundHeader);

        /**
         * <p>
         * The inbound header.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisPacketHeader.Builder} avoiding
         * the need to create one manually via {@link AnalysisPacketHeader#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisPacketHeader.Builder#build()} is called immediately and
         * its result is passed to {@link #inboundHeader(AnalysisPacketHeader)}.
         * 
         * @param inboundHeader
         *        a consumer that will call methods on {@link AnalysisPacketHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundHeader(AnalysisPacketHeader)
         */
        default Builder inboundHeader(Consumer<AnalysisPacketHeader.Builder> inboundHeader) {
            return inboundHeader(AnalysisPacketHeader.builder().applyMutation(inboundHeader).build());
        }

        /**
         * <p>
         * The route table route.
         * </p>
         * 
         * @param routeTableRoute
         *        The route table route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute);

        /**
         * <p>
         * The route table route.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRouteTableRoute.Builder} avoiding
         * the need to create one manually via {@link AnalysisRouteTableRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisRouteTableRoute.Builder#build()} is called immediately
         * and its result is passed to {@link #routeTableRoute(AnalysisRouteTableRoute)}.
         * 
         * @param routeTableRoute
         *        a consumer that will call methods on {@link AnalysisRouteTableRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableRoute(AnalysisRouteTableRoute)
         */
        default Builder routeTableRoute(Consumer<AnalysisRouteTableRoute.Builder> routeTableRoute) {
            return routeTableRoute(AnalysisRouteTableRoute.builder().applyMutation(routeTableRoute).build());
        }

        /**
         * <p>
         * The security group rule.
         * </p>
         * 
         * @param securityGroupRule
         *        The security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule);

        /**
         * <p>
         * The security group rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSecurityGroupRule.Builder}
         * avoiding the need to create one manually via {@link AnalysisSecurityGroupRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisSecurityGroupRule.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRule(AnalysisSecurityGroupRule)}.
         * 
         * @param securityGroupRule
         *        a consumer that will call methods on {@link AnalysisSecurityGroupRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRule(AnalysisSecurityGroupRule)
         */
        default Builder securityGroupRule(Consumer<AnalysisSecurityGroupRule.Builder> securityGroupRule) {
            return securityGroupRule(AnalysisSecurityGroupRule.builder().applyMutation(securityGroupRule).build());
        }

        /**
         * <p>
         * The source VPC.
         * </p>
         * 
         * @param sourceVpc
         *        The source VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVpc(AnalysisComponent sourceVpc);

        /**
         * <p>
         * The source VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceVpc(AnalysisComponent)}.
         * 
         * @param sourceVpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceVpc(AnalysisComponent)
         */
        default Builder sourceVpc(Consumer<AnalysisComponent.Builder> sourceVpc) {
            return sourceVpc(AnalysisComponent.builder().applyMutation(sourceVpc).build());
        }

        /**
         * <p>
         * The subnet.
         * </p>
         * 
         * @param subnet
         *        The subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(AnalysisComponent subnet);

        /**
         * <p>
         * The subnet.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #subnet(AnalysisComponent)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(AnalysisComponent)
         */
        default Builder subnet(Consumer<AnalysisComponent.Builder> subnet) {
            return subnet(AnalysisComponent.builder().applyMutation(subnet).build());
        }

        /**
         * <p>
         * The component VPC.
         * </p>
         * 
         * @param vpc
         *        The component VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(AnalysisComponent vpc);

        /**
         * <p>
         * The component VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(AnalysisComponent)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(AnalysisComponent)
         */
        default Builder vpc(Consumer<AnalysisComponent.Builder> vpc) {
            return vpc(AnalysisComponent.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * The additional details.
         * </p>
         * 
         * @param additionalDetails
         *        The additional details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(Collection<AdditionalDetail> additionalDetails);

        /**
         * <p>
         * The additional details.
         * </p>
         * 
         * @param additionalDetails
         *        The additional details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(AdditionalDetail... additionalDetails);

        /**
         * <p>
         * The additional details.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AdditionalDetail>.Builder} avoiding
         * the need to create one manually via {@link List<AdditionalDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalDetails(List<AdditionalDetail>)}.
         * 
         * @param additionalDetails
         *        a consumer that will call methods on {@link List<AdditionalDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalDetails(List<AdditionalDetail>)
         */
        Builder additionalDetails(Consumer<AdditionalDetail.Builder>... additionalDetails);

        /**
         * <p>
         * The transit gateway.
         * </p>
         * 
         * @param transitGateway
         *        The transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGateway(AnalysisComponent transitGateway);

        /**
         * <p>
         * The transit gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisComponent.Builder} avoiding the
         * need to create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #transitGateway(AnalysisComponent)}.
         * 
         * @param transitGateway
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGateway(AnalysisComponent)
         */
        default Builder transitGateway(Consumer<AnalysisComponent.Builder> transitGateway) {
            return transitGateway(AnalysisComponent.builder().applyMutation(transitGateway).build());
        }

        /**
         * <p>
         * The route in a transit gateway route table.
         * </p>
         * 
         * @param transitGatewayRouteTableRoute
         *        The route in a transit gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute);

        /**
         * <p>
         * The route in a transit gateway route table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayRouteTableRoute.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayRouteTableRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayRouteTableRoute.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute)}
         * .
         * 
         * @param transitGatewayRouteTableRoute
         *        a consumer that will call methods on {@link TransitGatewayRouteTableRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute)
         */
        default Builder transitGatewayRouteTableRoute(
                Consumer<TransitGatewayRouteTableRoute.Builder> transitGatewayRouteTableRoute) {
            return transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute.builder()
                    .applyMutation(transitGatewayRouteTableRoute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer sequenceNumber;

        private AnalysisAclRule aclRule;

        private AnalysisComponent attachedTo;

        private AnalysisComponent component;

        private AnalysisComponent destinationVpc;

        private AnalysisPacketHeader outboundHeader;

        private AnalysisPacketHeader inboundHeader;

        private AnalysisRouteTableRoute routeTableRoute;

        private AnalysisSecurityGroupRule securityGroupRule;

        private AnalysisComponent sourceVpc;

        private AnalysisComponent subnet;

        private AnalysisComponent vpc;

        private List<AdditionalDetail> additionalDetails = DefaultSdkAutoConstructList.getInstance();

        private AnalysisComponent transitGateway;

        private TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(PathComponent model) {
            sequenceNumber(model.sequenceNumber);
            aclRule(model.aclRule);
            attachedTo(model.attachedTo);
            component(model.component);
            destinationVpc(model.destinationVpc);
            outboundHeader(model.outboundHeader);
            inboundHeader(model.inboundHeader);
            routeTableRoute(model.routeTableRoute);
            securityGroupRule(model.securityGroupRule);
            sourceVpc(model.sourceVpc);
            subnet(model.subnet);
            vpc(model.vpc);
            additionalDetails(model.additionalDetails);
            transitGateway(model.transitGateway);
            transitGatewayRouteTableRoute(model.transitGatewayRouteTableRoute);
        }

        public final Integer getSequenceNumber() {
            return sequenceNumber;
        }

        public final void setSequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final AnalysisAclRule.Builder getAclRule() {
            return aclRule != null ? aclRule.toBuilder() : null;
        }

        public final void setAclRule(AnalysisAclRule.BuilderImpl aclRule) {
            this.aclRule = aclRule != null ? aclRule.build() : null;
        }

        @Override
        public final Builder aclRule(AnalysisAclRule aclRule) {
            this.aclRule = aclRule;
            return this;
        }

        public final AnalysisComponent.Builder getAttachedTo() {
            return attachedTo != null ? attachedTo.toBuilder() : null;
        }

        public final void setAttachedTo(AnalysisComponent.BuilderImpl attachedTo) {
            this.attachedTo = attachedTo != null ? attachedTo.build() : null;
        }

        @Override
        public final Builder attachedTo(AnalysisComponent attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final AnalysisComponent.Builder getDestinationVpc() {
            return destinationVpc != null ? destinationVpc.toBuilder() : null;
        }

        public final void setDestinationVpc(AnalysisComponent.BuilderImpl destinationVpc) {
            this.destinationVpc = destinationVpc != null ? destinationVpc.build() : null;
        }

        @Override
        public final Builder destinationVpc(AnalysisComponent destinationVpc) {
            this.destinationVpc = destinationVpc;
            return this;
        }

        public final AnalysisPacketHeader.Builder getOutboundHeader() {
            return outboundHeader != null ? outboundHeader.toBuilder() : null;
        }

        public final void setOutboundHeader(AnalysisPacketHeader.BuilderImpl outboundHeader) {
            this.outboundHeader = outboundHeader != null ? outboundHeader.build() : null;
        }

        @Override
        public final Builder outboundHeader(AnalysisPacketHeader outboundHeader) {
            this.outboundHeader = outboundHeader;
            return this;
        }

        public final AnalysisPacketHeader.Builder getInboundHeader() {
            return inboundHeader != null ? inboundHeader.toBuilder() : null;
        }

        public final void setInboundHeader(AnalysisPacketHeader.BuilderImpl inboundHeader) {
            this.inboundHeader = inboundHeader != null ? inboundHeader.build() : null;
        }

        @Override
        public final Builder inboundHeader(AnalysisPacketHeader inboundHeader) {
            this.inboundHeader = inboundHeader;
            return this;
        }

        public final AnalysisRouteTableRoute.Builder getRouteTableRoute() {
            return routeTableRoute != null ? routeTableRoute.toBuilder() : null;
        }

        public final void setRouteTableRoute(AnalysisRouteTableRoute.BuilderImpl routeTableRoute) {
            this.routeTableRoute = routeTableRoute != null ? routeTableRoute.build() : null;
        }

        @Override
        public final Builder routeTableRoute(AnalysisRouteTableRoute routeTableRoute) {
            this.routeTableRoute = routeTableRoute;
            return this;
        }

        public final AnalysisSecurityGroupRule.Builder getSecurityGroupRule() {
            return securityGroupRule != null ? securityGroupRule.toBuilder() : null;
        }

        public final void setSecurityGroupRule(AnalysisSecurityGroupRule.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        @Override
        public final Builder securityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        public final AnalysisComponent.Builder getSourceVpc() {
            return sourceVpc != null ? sourceVpc.toBuilder() : null;
        }

        public final void setSourceVpc(AnalysisComponent.BuilderImpl sourceVpc) {
            this.sourceVpc = sourceVpc != null ? sourceVpc.build() : null;
        }

        @Override
        public final Builder sourceVpc(AnalysisComponent sourceVpc) {
            this.sourceVpc = sourceVpc;
            return this;
        }

        public final AnalysisComponent.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        public final void setSubnet(AnalysisComponent.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public final Builder subnet(AnalysisComponent subnet) {
            this.subnet = subnet;
            return this;
        }

        public final AnalysisComponent.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(AnalysisComponent.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(AnalysisComponent vpc) {
            this.vpc = vpc;
            return this;
        }

        public final List<AdditionalDetail.Builder> getAdditionalDetails() {
            List<AdditionalDetail.Builder> result = AdditionalDetailListCopier.copyToBuilder(this.additionalDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDetails(Collection<AdditionalDetail.BuilderImpl> additionalDetails) {
            this.additionalDetails = AdditionalDetailListCopier.copyFromBuilder(additionalDetails);
        }

        @Override
        public final Builder additionalDetails(Collection<AdditionalDetail> additionalDetails) {
            this.additionalDetails = AdditionalDetailListCopier.copy(additionalDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDetails(AdditionalDetail... additionalDetails) {
            additionalDetails(Arrays.asList(additionalDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDetails(Consumer<AdditionalDetail.Builder>... additionalDetails) {
            additionalDetails(Stream.of(additionalDetails).map(c -> AdditionalDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AnalysisComponent.Builder getTransitGateway() {
            return transitGateway != null ? transitGateway.toBuilder() : null;
        }

        public final void setTransitGateway(AnalysisComponent.BuilderImpl transitGateway) {
            this.transitGateway = transitGateway != null ? transitGateway.build() : null;
        }

        @Override
        public final Builder transitGateway(AnalysisComponent transitGateway) {
            this.transitGateway = transitGateway;
            return this;
        }

        public final TransitGatewayRouteTableRoute.Builder getTransitGatewayRouteTableRoute() {
            return transitGatewayRouteTableRoute != null ? transitGatewayRouteTableRoute.toBuilder() : null;
        }

        public final void setTransitGatewayRouteTableRoute(TransitGatewayRouteTableRoute.BuilderImpl transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute != null ? transitGatewayRouteTableRoute.build()
                    : null;
        }

        @Override
        public final Builder transitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute) {
            this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
            return this;
        }

        @Override
        public PathComponent build() {
            return new PathComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
