/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpnTunnelOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpnTunnelOptionsRequest.Builder, ModifyVpnTunnelOptionsRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionId")
            .getter(getter(ModifyVpnTunnelOptionsRequest::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build()).build();

    private static final SdkField<String> VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnTunnelOutsideIpAddress")
            .getter(getter(ModifyVpnTunnelOptionsRequest::vpnTunnelOutsideIpAddress))
            .setter(setter(Builder::vpnTunnelOutsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOutsideIpAddress")
                    .unmarshallLocationName("VpnTunnelOutsideIpAddress").build()).build();

    private static final SdkField<ModifyVpnTunnelOptionsSpecification> TUNNEL_OPTIONS_FIELD = SdkField
            .<ModifyVpnTunnelOptionsSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("TunnelOptions")
            .getter(getter(ModifyVpnTunnelOptionsRequest::tunnelOptions))
            .setter(setter(Builder::tunnelOptions))
            .constructor(ModifyVpnTunnelOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions")
                    .unmarshallLocationName("TunnelOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD, TUNNEL_OPTIONS_FIELD));

    private final String vpnConnectionId;

    private final String vpnTunnelOutsideIpAddress;

    private final ModifyVpnTunnelOptionsSpecification tunnelOptions;

    private ModifyVpnTunnelOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnTunnelOutsideIpAddress = builder.vpnTunnelOutsideIpAddress;
        this.tunnelOptions = builder.tunnelOptions;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Site-to-Site VPN connection.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Site-to-Site VPN connection.
     */
    public final String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The external IP address of the VPN tunnel.
     * </p>
     * 
     * @return The external IP address of the VPN tunnel.
     */
    public final String vpnTunnelOutsideIpAddress() {
        return vpnTunnelOutsideIpAddress;
    }

    /**
     * <p>
     * The tunnel options to modify.
     * </p>
     * 
     * @return The tunnel options to modify.
     */
    public final ModifyVpnTunnelOptionsSpecification tunnelOptions() {
        return tunnelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnTunnelOutsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnTunnelOptionsRequest)) {
            return false;
        }
        ModifyVpnTunnelOptionsRequest other = (ModifyVpnTunnelOptionsRequest) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(vpnTunnelOutsideIpAddress(), other.vpnTunnelOutsideIpAddress())
                && Objects.equals(tunnelOptions(), other.tunnelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpnTunnelOptionsRequest").add("VpnConnectionId", vpnConnectionId())
                .add("VpnTunnelOutsideIpAddress", vpnTunnelOutsideIpAddress()).add("TunnelOptions", tunnelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "VpnTunnelOutsideIpAddress":
            return Optional.ofNullable(clazz.cast(vpnTunnelOutsideIpAddress()));
        case "TunnelOptions":
            return Optional.ofNullable(clazz.cast(tunnelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnTunnelOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpnTunnelOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpnTunnelOptionsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services Site-to-Site VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the Amazon Web Services Site-to-Site VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The external IP address of the VPN tunnel.
         * </p>
         * 
         * @param vpnTunnelOutsideIpAddress
         *        The external IP address of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress);

        /**
         * <p>
         * The tunnel options to modify.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(ModifyVpnTunnelOptionsSpecification tunnelOptions);

        /**
         * <p>
         * The tunnel options to modify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModifyVpnTunnelOptionsSpecification.Builder} avoiding the need to create one manually via
         * {@link ModifyVpnTunnelOptionsSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModifyVpnTunnelOptionsSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #tunnelOptions(ModifyVpnTunnelOptionsSpecification)}.
         * 
         * @param tunnelOptions
         *        a consumer that will call methods on {@link ModifyVpnTunnelOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelOptions(ModifyVpnTunnelOptionsSpecification)
         */
        default Builder tunnelOptions(Consumer<ModifyVpnTunnelOptionsSpecification.Builder> tunnelOptions) {
            return tunnelOptions(ModifyVpnTunnelOptionsSpecification.builder().applyMutation(tunnelOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String vpnTunnelOutsideIpAddress;

        private ModifyVpnTunnelOptionsSpecification tunnelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnTunnelOptionsRequest model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            vpnTunnelOutsideIpAddress(model.vpnTunnelOutsideIpAddress);
            tunnelOptions(model.tunnelOptions);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getVpnTunnelOutsideIpAddress() {
            return vpnTunnelOutsideIpAddress;
        }

        public final void setVpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
        }

        @Override
        public final Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
            return this;
        }

        public final ModifyVpnTunnelOptionsSpecification.Builder getTunnelOptions() {
            return tunnelOptions != null ? tunnelOptions.toBuilder() : null;
        }

        public final void setTunnelOptions(ModifyVpnTunnelOptionsSpecification.BuilderImpl tunnelOptions) {
            this.tunnelOptions = tunnelOptions != null ? tunnelOptions.build() : null;
        }

        @Override
        public final Builder tunnelOptions(ModifyVpnTunnelOptionsSpecification tunnelOptions) {
            this.tunnelOptions = tunnelOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnTunnelOptionsRequest build() {
            return new ModifyVpnTunnelOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
