/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityReservationsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCapacityReservationsResponse.Builder, DescribeCapacityReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityReservationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<CapacityReservation>> CAPACITY_RESERVATIONS_FIELD = SdkField
            .<List<CapacityReservation>> builder(MarshallingType.LIST)
            .memberName("CapacityReservations")
            .getter(getter(DescribeCapacityReservationsResponse::capacityReservations))
            .setter(setter(Builder::capacityReservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSet")
                    .unmarshallLocationName("capacityReservationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityReservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityReservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CAPACITY_RESERVATIONS_FIELD));

    private final String nextToken;

    private final List<CapacityReservation> capacityReservations;

    private DescribeCapacityReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservations = builder.capacityReservations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityReservations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityReservations() {
        return capacityReservations != null && !(capacityReservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Capacity Reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityReservations} method.
     * </p>
     * 
     * @return Information about the Capacity Reservations.
     */
    public final List<CapacityReservation> capacityReservations() {
        return capacityReservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityReservations() ? capacityReservations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationsResponse)) {
            return false;
        }
        DescribeCapacityReservationsResponse other = (DescribeCapacityReservationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCapacityReservations() == other.hasCapacityReservations()
                && Objects.equals(capacityReservations(), other.capacityReservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityReservationsResponse").add("NextToken", nextToken())
                .add("CapacityReservations", hasCapacityReservations() ? capacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityReservations":
            return Optional.ofNullable(clazz.cast(capacityReservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCapacityReservationsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the Capacity Reservations.
         * </p>
         * 
         * @param capacityReservations
         *        Information about the Capacity Reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservations(Collection<CapacityReservation> capacityReservations);

        /**
         * <p>
         * Information about the Capacity Reservations.
         * </p>
         * 
         * @param capacityReservations
         *        Information about the Capacity Reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservations(CapacityReservation... capacityReservations);

        /**
         * <p>
         * Information about the Capacity Reservations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CapacityReservation>.Builder}
         * avoiding the need to create one manually via {@link List<CapacityReservation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CapacityReservation>.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityReservations(List<CapacityReservation>)}.
         * 
         * @param capacityReservations
         *        a consumer that will call methods on {@link List<CapacityReservation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservations(List<CapacityReservation>)
         */
        Builder capacityReservations(Consumer<CapacityReservation.Builder>... capacityReservations);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CapacityReservation> capacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            capacityReservations(model.capacityReservations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservation.Builder> getCapacityReservations() {
            List<CapacityReservation.Builder> result = CapacityReservationSetCopier.copyToBuilder(this.capacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservations(Collection<CapacityReservation.BuilderImpl> capacityReservations) {
            this.capacityReservations = CapacityReservationSetCopier.copyFromBuilder(capacityReservations);
        }

        @Override
        public final Builder capacityReservations(Collection<CapacityReservation> capacityReservations) {
            this.capacityReservations = CapacityReservationSetCopier.copy(capacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(CapacityReservation... capacityReservations) {
            capacityReservations(Arrays.asList(capacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(Consumer<CapacityReservation.Builder>... capacityReservations) {
            capacityReservations(Stream.of(capacityReservations).map(c -> CapacityReservation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationsResponse build() {
            return new DescribeCapacityReservationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
