/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTransitGatewayVpcAttachmentResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteTransitGatewayVpcAttachmentResponse.Builder, DeleteTransitGatewayVpcAttachmentResponse> {
    private static final SdkField<TransitGatewayVpcAttachment> TRANSIT_GATEWAY_VPC_ATTACHMENT_FIELD = SdkField
            .<TransitGatewayVpcAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayVpcAttachment")
            .getter(getter(DeleteTransitGatewayVpcAttachmentResponse::transitGatewayVpcAttachment))
            .setter(setter(Builder::transitGatewayVpcAttachment))
            .constructor(TransitGatewayVpcAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayVpcAttachment")
                    .unmarshallLocationName("transitGatewayVpcAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_VPC_ATTACHMENT_FIELD));

    private final TransitGatewayVpcAttachment transitGatewayVpcAttachment;

    private DeleteTransitGatewayVpcAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayVpcAttachment = builder.transitGatewayVpcAttachment;
    }

    /**
     * <p>
     * Information about the deleted VPC attachment.
     * </p>
     * 
     * @return Information about the deleted VPC attachment.
     */
    public final TransitGatewayVpcAttachment transitGatewayVpcAttachment() {
        return transitGatewayVpcAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayVpcAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTransitGatewayVpcAttachmentResponse)) {
            return false;
        }
        DeleteTransitGatewayVpcAttachmentResponse other = (DeleteTransitGatewayVpcAttachmentResponse) obj;
        return Objects.equals(transitGatewayVpcAttachment(), other.transitGatewayVpcAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTransitGatewayVpcAttachmentResponse")
                .add("TransitGatewayVpcAttachment", transitGatewayVpcAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayVpcAttachment":
            return Optional.ofNullable(clazz.cast(transitGatewayVpcAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTransitGatewayVpcAttachmentResponse, T> g) {
        return obj -> g.apply((DeleteTransitGatewayVpcAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTransitGatewayVpcAttachmentResponse> {
        /**
         * <p>
         * Information about the deleted VPC attachment.
         * </p>
         * 
         * @param transitGatewayVpcAttachment
         *        Information about the deleted VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayVpcAttachment(TransitGatewayVpcAttachment transitGatewayVpcAttachment);

        /**
         * <p>
         * Information about the deleted VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayVpcAttachment.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayVpcAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayVpcAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayVpcAttachment(TransitGatewayVpcAttachment)}.
         * 
         * @param transitGatewayVpcAttachment
         *        a consumer that will call methods on {@link TransitGatewayVpcAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayVpcAttachment(TransitGatewayVpcAttachment)
         */
        default Builder transitGatewayVpcAttachment(Consumer<TransitGatewayVpcAttachment.Builder> transitGatewayVpcAttachment) {
            return transitGatewayVpcAttachment(TransitGatewayVpcAttachment.builder().applyMutation(transitGatewayVpcAttachment)
                    .build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayVpcAttachment transitGatewayVpcAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTransitGatewayVpcAttachmentResponse model) {
            super(model);
            transitGatewayVpcAttachment(model.transitGatewayVpcAttachment);
        }

        public final TransitGatewayVpcAttachment.Builder getTransitGatewayVpcAttachment() {
            return transitGatewayVpcAttachment != null ? transitGatewayVpcAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayVpcAttachment(TransitGatewayVpcAttachment.BuilderImpl transitGatewayVpcAttachment) {
            this.transitGatewayVpcAttachment = transitGatewayVpcAttachment != null ? transitGatewayVpcAttachment.build() : null;
        }

        @Override
        public final Builder transitGatewayVpcAttachment(TransitGatewayVpcAttachment transitGatewayVpcAttachment) {
            this.transitGatewayVpcAttachment = transitGatewayVpcAttachment;
            return this;
        }

        @Override
        public DeleteTransitGatewayVpcAttachmentResponse build() {
            return new DeleteTransitGatewayVpcAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
