/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcResponse extends Ec2Response implements
        ToCopyableBuilder<CreateVpcResponse.Builder, CreateVpcResponse> {
    private static final SdkField<Vpc> VPC_FIELD = SdkField
            .<Vpc> builder(MarshallingType.SDK_POJO)
            .memberName("Vpc")
            .getter(getter(CreateVpcResponse::vpc))
            .setter(setter(Builder::vpc))
            .constructor(Vpc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").unmarshallLocationName("vpc")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_FIELD));

    private final Vpc vpc;

    private CreateVpcResponse(BuilderImpl builder) {
        super(builder);
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * Information about the VPC.
     * </p>
     * 
     * @return Information about the VPC.
     */
    public final Vpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcResponse)) {
            return false;
        }
        CreateVpcResponse other = (CreateVpcResponse) obj;
        return Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcResponse").add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcResponse, T> g) {
        return obj -> g.apply((CreateVpcResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcResponse> {
        /**
         * <p>
         * Information about the VPC.
         * </p>
         * 
         * @param vpc
         *        Information about the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(Vpc vpc);

        /**
         * <p>
         * Information about the VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link Vpc.Builder} avoiding the need to create
         * one manually via {@link Vpc#builder()}.
         *
         * When the {@link Consumer} completes, {@link Vpc.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(Vpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link Vpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(Vpc)
         */
        default Builder vpc(Consumer<Vpc.Builder> vpc) {
            return vpc(Vpc.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Vpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcResponse model) {
            super(model);
            vpc(model.vpc);
        }

        public final Vpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(Vpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public CreateVpcResponse build() {
            return new CreateVpcResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
