/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(CreateTransitGatewayRouteRequest.getter(CreateTransitGatewayRouteRequest::destinationCidrBlock)).setter(CreateTransitGatewayRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(CreateTransitGatewayRouteRequest.getter(CreateTransitGatewayRouteRequest::transitGatewayRouteTableId)).setter(CreateTransitGatewayRouteRequest.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("TransitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(CreateTransitGatewayRouteRequest.getter(CreateTransitGatewayRouteRequest::transitGatewayAttachmentId)).setter(CreateTransitGatewayRouteRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<Boolean> BLACKHOLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blackhole").getter(CreateTransitGatewayRouteRequest.getter(CreateTransitGatewayRouteRequest::blackhole)).setter(CreateTransitGatewayRouteRequest.setter(Builder::blackhole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blackhole").unmarshallLocationName("Blackhole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, BLACKHOLE_FIELD));
    private final String destinationCidrBlock;
    private final String transitGatewayRouteTableId;
    private final String transitGatewayAttachmentId;
    private final Boolean blackhole;

    private CreateTransitGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.blackhole = builder.blackhole;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final Boolean blackhole() {
        return this.blackhole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackhole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayRouteRequest)) {
            return false;
        }
        CreateTransitGatewayRouteRequest other = (CreateTransitGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.blackhole(), other.blackhole());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("Blackhole", (Object)this.blackhole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "Blackhole": {
                return Optional.ofNullable(clazz.cast(this.blackhole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayRouteRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String transitGatewayRouteTableId;
        private String transitGatewayAttachmentId;
        private Boolean blackhole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.blackhole(model.blackhole);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        @Transient
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final Boolean getBlackhole() {
            return this.blackhole;
        }

        public final void setBlackhole(Boolean blackhole) {
            this.blackhole = blackhole;
        }

        @Override
        @Transient
        public final Builder blackhole(Boolean blackhole) {
            this.blackhole = blackhole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayRouteRequest build() {
            return new CreateTransitGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder transitGatewayRouteTableId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder blackhole(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

