/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateEnclaveCertificateIamRoleResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateEnclaveCertificateIamRoleResponse> {
    private static final SdkField<String> CERTIFICATE_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateS3BucketName").getter(AssociateEnclaveCertificateIamRoleResponse.getter(AssociateEnclaveCertificateIamRoleResponse::certificateS3BucketName)).setter(AssociateEnclaveCertificateIamRoleResponse.setter(Builder::certificateS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3BucketName").unmarshallLocationName("certificateS3BucketName").build()}).build();
    private static final SdkField<String> CERTIFICATE_S3_OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateS3ObjectKey").getter(AssociateEnclaveCertificateIamRoleResponse.getter(AssociateEnclaveCertificateIamRoleResponse::certificateS3ObjectKey)).setter(AssociateEnclaveCertificateIamRoleResponse.setter(Builder::certificateS3ObjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateS3ObjectKey").unmarshallLocationName("certificateS3ObjectKey").build()}).build();
    private static final SdkField<String> ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKmsKeyId").getter(AssociateEnclaveCertificateIamRoleResponse.getter(AssociateEnclaveCertificateIamRoleResponse::encryptionKmsKeyId)).setter(AssociateEnclaveCertificateIamRoleResponse.setter(Builder::encryptionKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKmsKeyId").unmarshallLocationName("encryptionKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_S3_BUCKET_NAME_FIELD, CERTIFICATE_S3_OBJECT_KEY_FIELD, ENCRYPTION_KMS_KEY_ID_FIELD));
    private final String certificateS3BucketName;
    private final String certificateS3ObjectKey;
    private final String encryptionKmsKeyId;

    private AssociateEnclaveCertificateIamRoleResponse(BuilderImpl builder) {
        super(builder);
        this.certificateS3BucketName = builder.certificateS3BucketName;
        this.certificateS3ObjectKey = builder.certificateS3ObjectKey;
        this.encryptionKmsKeyId = builder.encryptionKmsKeyId;
    }

    public final String certificateS3BucketName() {
        return this.certificateS3BucketName;
    }

    public final String certificateS3ObjectKey() {
        return this.certificateS3ObjectKey;
    }

    public final String encryptionKmsKeyId() {
        return this.encryptionKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateS3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEnclaveCertificateIamRoleResponse)) {
            return false;
        }
        AssociateEnclaveCertificateIamRoleResponse other = (AssociateEnclaveCertificateIamRoleResponse)((Object)obj);
        return Objects.equals(this.certificateS3BucketName(), other.certificateS3BucketName()) && Objects.equals(this.certificateS3ObjectKey(), other.certificateS3ObjectKey()) && Objects.equals(this.encryptionKmsKeyId(), other.encryptionKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateEnclaveCertificateIamRoleResponse").add("CertificateS3BucketName", (Object)this.certificateS3BucketName()).add("CertificateS3ObjectKey", (Object)this.certificateS3ObjectKey()).add("EncryptionKmsKeyId", (Object)this.encryptionKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.certificateS3BucketName()));
            }
            case "CertificateS3ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.certificateS3ObjectKey()));
            }
            case "EncryptionKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.encryptionKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateEnclaveCertificateIamRoleResponse, T> g) {
        return obj -> g.apply((AssociateEnclaveCertificateIamRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String certificateS3BucketName;
        private String certificateS3ObjectKey;
        private String encryptionKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEnclaveCertificateIamRoleResponse model) {
            super(model);
            this.certificateS3BucketName(model.certificateS3BucketName);
            this.certificateS3ObjectKey(model.certificateS3ObjectKey);
            this.encryptionKmsKeyId(model.encryptionKmsKeyId);
        }

        public final String getCertificateS3BucketName() {
            return this.certificateS3BucketName;
        }

        public final void setCertificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
        }

        @Override
        @Transient
        public final Builder certificateS3BucketName(String certificateS3BucketName) {
            this.certificateS3BucketName = certificateS3BucketName;
            return this;
        }

        public final String getCertificateS3ObjectKey() {
            return this.certificateS3ObjectKey;
        }

        public final void setCertificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
        }

        @Override
        @Transient
        public final Builder certificateS3ObjectKey(String certificateS3ObjectKey) {
            this.certificateS3ObjectKey = certificateS3ObjectKey;
            return this;
        }

        public final String getEncryptionKmsKeyId() {
            return this.encryptionKmsKeyId;
        }

        public final void setEncryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
        }

        @Override
        @Transient
        public final Builder encryptionKmsKeyId(String encryptionKmsKeyId) {
            this.encryptionKmsKeyId = encryptionKmsKeyId;
            return this;
        }

        @Override
        public AssociateEnclaveCertificateIamRoleResponse build() {
            return new AssociateEnclaveCertificateIamRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateEnclaveCertificateIamRoleResponse> {
        public Builder certificateS3BucketName(String var1);

        public Builder certificateS3ObjectKey(String var1);

        public Builder encryptionKmsKeyId(String var1);
    }
}

