/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tags to apply to the AMI object that will be stored in the S3 bucket. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html">Categorizing your storage using
 * tags</a> in the <i>Amazon Simple Storage Service User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ObjectTag implements SdkPojo, Serializable, ToCopyableBuilder<S3ObjectTag.Builder, S3ObjectTag> {
    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Key")
            .getter(getter(S3ObjectTag::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("Key")
                    .build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(S3ObjectTag::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private S3ObjectTag(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The key of the tag.
     * </p>
     * <p>
     * Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in length. May not begin with
     * <code>aws</code>:.
     * </p>
     * 
     * @return The key of the tag.</p>
     *         <p>
     *         Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in length. May not begin
     *         with <code>aws</code>:.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the tag.
     * </p>
     * <p>
     * Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in length.
     * </p>
     * 
     * @return The value of the tag.</p>
     *         <p>
     *         Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in length.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectTag)) {
            return false;
        }
        S3ObjectTag other = (S3ObjectTag) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ObjectTag").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ObjectTag, T> g) {
        return obj -> g.apply((S3ObjectTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ObjectTag> {
        /**
         * <p>
         * The key of the tag.
         * </p>
         * <p>
         * Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in length. May not begin
         * with <code>aws</code>:.
         * </p>
         * 
         * @param key
         *        The key of the tag.</p>
         *        <p>
         *        Constraints: Tag keys are case-sensitive and can be up to 128 Unicode characters in length. May not
         *        begin with <code>aws</code>:.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the tag.
         * </p>
         * <p>
         * Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in length.
         * </p>
         * 
         * @param value
         *        The value of the tag.</p>
         *        <p>
         *        Constraints: Tag values are case-sensitive and can be up to 256 Unicode characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ObjectTag model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public S3ObjectTag build() {
            return new S3ObjectTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
