/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<RunInstancesRequest.Builder, RunInstancesRequest> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(RunInstancesRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("BlockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(RunInstancesRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(RunInstancesRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(RunInstancesRequest::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("Ipv6AddressCount").build()).build();

    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<InstanceIpv6Address>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(RunInstancesRequest::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address")
                    .unmarshallLocationName("Ipv6Address").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(RunInstancesRequest::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("KernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(RunInstancesRequest::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build()).build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCount")
            .getter(getter(RunInstancesRequest::maxCount))
            .setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount")
                    .unmarshallLocationName("MaxCount").build()).build();

    private static final SdkField<Integer> MIN_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCount")
            .getter(getter(RunInstancesRequest::minCount))
            .setter(setter(Builder::minCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCount")
                    .unmarshallLocationName("MinCount").build()).build();

    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField
            .<RunInstancesMonitoringEnabled> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(RunInstancesRequest::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(RunInstancesMonitoringEnabled::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("Monitoring").build()).build();

    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField
            .<Placement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(RunInstancesRequest::placement))
            .setter(setter(Builder::placement))
            .constructor(Placement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("Placement").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamdiskId")
            .getter(getter(RunInstancesRequest::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("RamdiskId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(RunInstancesRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(RunInstancesRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup")
                    .unmarshallLocationName("SecurityGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroup").unmarshallLocationName("SecurityGroup")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(RunInstancesRequest::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(RunInstancesRequest::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("UserData").build()).build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo")
            .getter(getter(RunInstancesRequest::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo")
                    .unmarshallLocationName("additionalInfo").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(RunInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiTermination")
            .getter(getter(RunInstancesRequest::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("disableApiTermination").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(RunInstancesRequest::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfileSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(RunInstancesRequest::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfileSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(RunInstancesRequest::instanceInitiatedShutdownBehaviorAsString))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("instanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterfaceSpecification>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(RunInstancesRequest::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("networkInterface").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterfaceSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterfaceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(RunInstancesRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATION_FIELD = SdkField
            .<List<ElasticGpuSpecification>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuSpecification")
            .getter(getter(RunInstancesRequest::elasticGpuSpecification))
            .setter(setter(Builder::elasticGpuSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification")
                    .unmarshallLocationName("ElasticGpuSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<ElasticInferenceAccelerator>> builder(MarshallingType.LIST)
            .memberName("ElasticInferenceAccelerators")
            .getter(getter(RunInstancesRequest::elasticInferenceAccelerators))
            .setter(setter(Builder::elasticInferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator")
                    .unmarshallLocationName("ElasticInferenceAccelerator").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticInferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticInferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(RunInstancesRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate")
            .getter(getter(RunInstancesRequest::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate")
                    .unmarshallLocationName("LaunchTemplate").build()).build();

    private static final SdkField<InstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<InstanceMarketOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMarketOptions")
            .getter(getter(RunInstancesRequest::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions))
            .constructor(InstanceMarketOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions")
                    .unmarshallLocationName("InstanceMarketOptions").build()).build();

    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField
            .<CreditSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CreditSpecification")
            .getter(getter(RunInstancesRequest::creditSpecification))
            .setter(setter(Builder::creditSpecification))
            .constructor(CreditSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification")
                    .unmarshallLocationName("CreditSpecification").build()).build();

    private static final SdkField<CpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField
            .<CpuOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("CpuOptions")
            .getter(getter(RunInstancesRequest::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(CpuOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("CpuOptions").build()).build();

    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(RunInstancesRequest::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("CapacityReservationSpecification").build()).build();

    private static final SdkField<HibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField
            .<HibernationOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("HibernationOptions")
            .getter(getter(RunInstancesRequest::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(HibernationOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("HibernationOptions").build()).build();

    private static final SdkField<List<LicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LicenseConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(RunInstancesRequest::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification")
                    .unmarshallLocationName("LicenseSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LicenseConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("MetadataOptions")
            .getter(getter(RunInstancesRequest::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("MetadataOptions").build()).build();

    private static final SdkField<EnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField
            .<EnclaveOptionsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("EnclaveOptions")
            .getter(getter(RunInstancesRequest::enclaveOptions))
            .setter(setter(Builder::enclaveOptions))
            .constructor(EnclaveOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions")
                    .unmarshallLocationName("EnclaveOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD,
            MAX_COUNT_FIELD, MIN_COUNT_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SECURITY_GROUP_IDS_FIELD,
            SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, USER_DATA_FIELD, ADDITIONAL_INFO_FIELD, CLIENT_TOKEN_FIELD,
            DISABLE_API_TERMINATION_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD,
            INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, NETWORK_INTERFACES_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            ELASTIC_GPU_SPECIFICATION_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, TAG_SPECIFICATIONS_FIELD,
            LAUNCH_TEMPLATE_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, HIBERNATION_OPTIONS_FIELD, LICENSE_SPECIFICATIONS_FIELD,
            METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD));

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String imageId;

    private final String instanceType;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String kernelId;

    private final String keyName;

    private final Integer maxCount;

    private final Integer minCount;

    private final RunInstancesMonitoringEnabled monitoring;

    private final Placement placement;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final String subnetId;

    private final String userData;

    private final String additionalInfo;

    private final String clientToken;

    private final Boolean disableApiTermination;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String instanceInitiatedShutdownBehavior;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final String privateIpAddress;

    private final List<ElasticGpuSpecification> elasticGpuSpecification;

    private final List<ElasticInferenceAccelerator> elasticInferenceAccelerators;

    private final List<TagSpecification> tagSpecifications;

    private final LaunchTemplateSpecification launchTemplate;

    private final InstanceMarketOptionsRequest instanceMarketOptions;

    private final CreditSpecificationRequest creditSpecification;

    private final CpuOptionsRequest cpuOptions;

    private final CapacityReservationSpecification capacityReservationSpecification;

    private final HibernationOptionsRequest hibernationOptions;

    private final List<LicenseConfigurationRequest> licenseSpecifications;

    private final InstanceMetadataOptionsRequest metadataOptions;

    private final EnclaveOptionsRequest enclaveOptions;

    private RunInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.maxCount = builder.maxCount;
        this.minCount = builder.minCount;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.additionalInfo = builder.additionalInfo;
        this.clientToken = builder.clientToken;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.networkInterfaces = builder.networkInterfaces;
        this.privateIpAddress = builder.privateIpAddress;
        this.elasticGpuSpecification = builder.elasticGpuSpecification;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.tagSpecifications = builder.tagSpecifications;
        this.launchTemplate = builder.launchTemplate;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.hibernationOptions = builder.hibernationOptions;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mapping entries.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch
     * template.
     * </p>
     * 
     * @return The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch
     *         template.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>m1.small</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>m1.small</code>
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>m1.small</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>m1.small</code>
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the
     * IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific
     * IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances
     * to launch.
     * </p>
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * </p>
     * 
     * @return [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2
     *         chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option
     *         to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a
     *         minimum number of instances to launch.</p>
     *         <p>
     *         You cannot specify this option and the network interfaces option in the same request.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface. You
     * cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot
     * specify this option if you've specified a minimum number of instances to launch.
     * </p>
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network
     *         interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same
     *         request. You cannot specify this option if you've specified a minimum number of instances to launch.</p>
     *         <p>
     *         You cannot specify this option and the network interfaces option in the same request.
     */
    public final List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon
     * EC2 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the kernel.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     *         </p>
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair. You can create a key pair using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     * </p>
     * <important>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured
     * to allow users another way to log in.
     * </p>
     * </important>
     * 
     * @return The name of the key pair. You can create a key pair using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or
     *         <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     *         </p> <important>
     *         <p>
     *         If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
     *         configured to allow users another way to log in.
     *         </p>
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target
     * Availability Zone, Amazon EC2 launches the largest possible number of instances above <code>MinCount</code>.
     * </p>
     * <p>
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     * information about the default limits, and how to request an increase, see <a
     * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in
     * Amazon EC2</a> in the Amazon EC2 FAQ.
     * </p>
     * 
     * @return The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in
     *         the target Availability Zone, Amazon EC2 launches the largest possible number of instances above
     *         <code>MinCount</code>.</p>
     *         <p>
     *         Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     *         information about the default limits, and how to request an increase, see <a
     *         href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can
     *         I run in Amazon EC2</a> in the Amazon EC2 FAQ.
     */
    public final Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can
     * launch in the target Availability Zone, Amazon EC2 launches no instances.
     * </p>
     * <p>
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     * information about the default limits, and how to request an increase, see <a
     * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in
     * Amazon EC2</a> in the Amazon EC2 General FAQ.
     * </p>
     * 
     * @return The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon
     *         EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p>
     *         <p>
     *         Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     *         information about the default limits, and how to request an increase, see <a
     *         href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can
     *         I run in Amazon EC2</a> in the Amazon EC2 General FAQ.
     */
    public final Integer minCount() {
        return minCount;
    }

    /**
     * <p>
     * Specifies whether detailed monitoring is enabled for the instance.
     * </p>
     * 
     * @return Specifies whether detailed monitoring is enabled for the instance.
     */
    public final RunInstancesMonitoringEnabled monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement for the instance.
     * </p>
     * 
     * @return The placement for the instance.
     */
    public final Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel
     * requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the
     * Amazon Web Services Resource Center and search for the kernel ID.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon
     * EC2 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel
     *         requirements for information about whether you need to specify a RAM disk. To find kernel requirements,
     *         go to the Amazon Web Services Resource Center and search for the kernel ID.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     *         </p>
     */
    public final String ramdiskId() {
        return ramdiskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups. You can create a security group using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
     * >CreateSecurityGroup</a>.
     * </p>
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups. You can create a security group using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
     *         >CreateSecurityGroup</a>.</p>
     *         <p>
     *         If you specify a network interface, you must specify any security groups as part of the network
     *         interface.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use security group
     * IDs instead.
     * </p>
     * <p>
     * If you specify a network interface, you must specify any security groups as part of the network interface.
     * </p>
     * <p>
     * Default: Amazon EC2 uses the default security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use security
     *         group IDs instead.</p>
     *         <p>
     *         If you specify a network interface, you must specify any security groups as part of the network
     *         interface.
     *         </p>
     *         <p>
     *         Default: Amazon EC2 uses the default security group.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet to launch the instance into.
     * </p>
     * <p>
     * If you specify a network interface, you must specify any subnets as part of the network interface.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet to launch the instance into.</p>
     *         <p>
     *         If you specify a network interface, you must specify any subnets as part of the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The user data to make available to the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running commands on your Linux instance
     * at launch</a> (Linux) and <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     * >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and
     * you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16
     * KB.
     * </p>
     * 
     * @return The user data to make available to the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running commands on your Linux
     *         instance at launch</a> (Linux) and <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     *         >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for
     *         you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is
     *         limited to 16 KB.
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a
     * client token, a randomly generated token is used for the request to ensure idempotency.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * <p>
     * Constraints: Maximum 64 ASCII characters
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     *         </p>
     *         <p>
     *         Constraints: Maximum 64 ASCII characters
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2 console,
     * CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
     *         console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     *         >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     *         <code>terminate</code>, you can terminate the instance by running the shutdown command from the
     *         instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized
     * instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS-optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    public final IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public final String instanceInitiatedShutdownBehaviorAsString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces to associate with the instance. If you specify a network interface, you must specify any
     * security groups and subnets as part of the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return The network interfaces to associate with the instance. If you specify a network interface, you must
     *         specify any security groups and subnets as part of the network interface.
     */
    public final List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     * </p>
     * <p>
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the
     * option to designate a private IP address as the primary IP address in a network interface specification. You
     * cannot specify this option if you're launching more than one instance in the request.
     * </p>
     * <p>
     * You cannot specify this option and the network interfaces option in the same request.
     * </p>
     * 
     * @return [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the
     *         subnet.</p>
     *         <p>
     *         Only one private IP address can be designated as primary. You can't specify this option if you've
     *         specified the option to designate a private IP address as the primary IP address in a network interface
     *         specification. You cannot specify this option if you're launching more than one instance in the request.
     *         </p>
     *         <p>
     *         You cannot specify this option and the network interfaces option in the same request.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticGpuSpecification property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticGpuSpecification() {
        return elasticGpuSpecification != null && !(elasticGpuSpecification instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your
     * Windows instance to accelerate the graphics performance of your applications. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic GPUs</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticGpuSpecification} method.
     * </p>
     * 
     * @return An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to
     *         your Windows instance to accelerate the graphics performance of your applications. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2
     *         Elastic GPUs</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final List<ElasticGpuSpecification> elasticGpuSpecification() {
        return elasticGpuSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticInferenceAccelerators property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticInferenceAccelerators() {
        return elasticInferenceAccelerators != null && !(elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a resource
     * you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.
     * </p>
     * <p>
     * You cannot specify accelerators from different generations in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticInferenceAccelerators} method.
     * </p>
     * 
     * @return An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
     *         resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
     *         workloads.</p>
     *         <p>
     *         You cannot specify accelerators from different generations in the same request.
     */
    public final List<ElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return elasticInferenceAccelerators;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The specified
     * tags are applied to all instances or volumes that are created during launch. To tag a resource after it has been
     * created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
     *         specified tags are applied to all instances or volumes that are created during launch. To tag a resource
     *         after it has been created, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The launch template to use to launch the instances. Any parameters that you specify in <a>RunInstances</a>
     * override the same parameters in the launch template. You can specify either the name or ID of a launch template,
     * but not both.
     * </p>
     * 
     * @return The launch template to use to launch the instances. Any parameters that you specify in
     *         <a>RunInstances</a> override the same parameters in the launch template. You can specify either the name
     *         or ID of a launch template, but not both.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The market (purchasing) option for the instances.
     * </p>
     * <p>
     * For <a>RunInstances</a>, persistent Spot Instance requests are only supported when
     * <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.
     * </p>
     * 
     * @return The market (purchasing) option for the instances.</p>
     *         <p>
     *         For <a>RunInstances</a>, persistent Spot Instance requests are only supported when
     *         <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.
     */
    public final InstanceMarketOptionsRequest instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The credit option for CPU usage of the burstable performance instance. Valid values are <code>standard</code> and
     * <code>unlimited</code>. To change this attribute after launch, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">
     * ModifyInstanceCreditSpecification</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
     * </p>
     * 
     * @return The credit option for CPU usage of the burstable performance instance. Valid values are
     *         <code>standard</code> and <code>unlimited</code>. To change this attribute after launch, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">
     *         ModifyInstanceCreditSpecification</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     *         performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
     */
    public final CreditSpecificationRequest creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * The CPU options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU options</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The CPU options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
     *         options</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final CpuOptionsRequest cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * Information about the Capacity Reservation targeting option. If you do not specify this parameter, the instance's
     * Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
     * Reservation that has matching attributes (instance type, platform, Availability Zone).
     * </p>
     * 
     * @return Information about the Capacity Reservation targeting option. If you do not specify this parameter, the
     *         instance's Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any
     *         open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     */
    public final CapacityReservationSpecification capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Indicates whether an instance is enabled for hibernation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
     * </p>
     * 
     * @return Indicates whether an instance is enabled for hibernation. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in
     *         the <i>Amazon EC2 User Guide</i>.</p>
     *         <p>
     *         You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
     */
    public final HibernationOptionsRequest hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return The license configurations.
     */
    public final List<LicenseConfigurationRequest> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * The metadata options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user
     * data</a>.
     * </p>
     * 
     * @return The metadata options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata
     *         and user data</a>.
     */
    public final InstanceMetadataOptionsRequest metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services Nitro
     * Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information,
     *         see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web
     *         Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
     *         <p>
     *         You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
     */
    public final EnclaveOptionsRequest enclaveOptions() {
        return enclaveOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(minCount());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuSpecification() ? elasticGpuSpecification() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest) obj;
        return hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(maxCount(), other.maxCount())
                && Objects.equals(minCount(), other.minCount()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(userData(), other.userData())
                && Objects.equals(additionalInfo(), other.additionalInfo()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasElasticGpuSpecification() == other.hasElasticGpuSpecification()
                && Objects.equals(elasticGpuSpecification(), other.elasticGpuSpecification())
                && hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators()
                && Objects.equals(elasticInferenceAccelerators(), other.elasticInferenceAccelerators())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(metadataOptions(), other.metadataOptions())
                && Objects.equals(enclaveOptions(), other.enclaveOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunInstancesRequest")
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("KernelId", kernelId())
                .add("KeyName", keyName()).add("MaxCount", maxCount()).add("MinCount", minCount())
                .add("Monitoring", monitoring()).add("Placement", placement()).add("RamdiskId", ramdiskId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubnetId", subnetId())
                .add("UserData", userData()).add("AdditionalInfo", additionalInfo()).add("ClientToken", clientToken())
                .add("DisableApiTermination", disableApiTermination()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehaviorAsString())
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null)
                .add("PrivateIpAddress", privateIpAddress())
                .add("ElasticGpuSpecification", hasElasticGpuSpecification() ? elasticGpuSpecification() : null)
                .add("ElasticInferenceAccelerators", hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("LaunchTemplate", launchTemplate()).add("InstanceMarketOptions", instanceMarketOptions())
                .add("CreditSpecification", creditSpecification()).add("CpuOptions", cpuOptions())
                .add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("HibernationOptions", hibernationOptions())
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("MetadataOptions", metadataOptions()).add("EnclaveOptions", enclaveOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "MaxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "MinCount":
            return Optional.ofNullable(clazz.cast(minCount()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehaviorAsString()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "ElasticGpuSpecification":
            return Optional.ofNullable(clazz.cast(elasticGpuSpecification()));
        case "ElasticInferenceAccelerators":
            return Optional.ofNullable(clazz.cast(elasticInferenceAccelerators()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunInstancesRequest, T> g) {
        return obj -> g.apply((RunInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RunInstancesRequest> {
        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch
         * template.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a
         *        launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>m1.small</code>
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>m1.small</code>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>m1.small</code>
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>m1.small</code>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses
         * the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign
         * specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number
         * of instances to launch.
         * </p>
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * </p>
         * 
         * @param ipv6AddressCount
         *        [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2
         *        chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the
         *        option to assign specific IPv6 addresses in the same request. You can specify this option if you've
         *        specified a minimum number of instances to launch.</p>
         *        <p>
         *        You cannot specify this option and the network interfaces option in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You
         * cannot specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * </p>
         * 
         * @param ipv6Addresses
         *        [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network
         *        interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the
         *        same request. You cannot specify this option if you've specified a minimum number of instances to
         *        launch.</p>
         *        <p>
         *        You cannot specify this option and the network interfaces option in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You
         * cannot specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * </p>
         * 
         * @param ipv6Addresses
         *        [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network
         *        interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the
         *        same request. You cannot specify this option if you've specified a minimum number of instances to
         *        launch.</p>
         *        <p>
         *        You cannot specify this option and the network interfaces option in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
         * You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You
         * cannot specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceIpv6Address>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceIpv6Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceIpv6Address>.Builder#build()} is called immediately
         * and its result is passed to {@link #ipv6Addresses(List<InstanceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on {@link List<InstanceIpv6Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(List<InstanceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kernelId
         *        The ID of the kernel.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair. You can create a key pair using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
         * </p>
         * <important>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         * configured to allow users another way to log in.
         * </p>
         * </important>
         * 
         * @param keyName
         *        The name of the key pair. You can create a key pair using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a>
         *        or <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair
         *        </a>.</p> <important>
         *        <p>
         *        If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         *        configured to allow users another way to log in.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the
         * target Availability Zone, Amazon EC2 launches the largest possible number of instances above
         * <code>MinCount</code>.
         * </p>
         * <p>
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         * information about the default limits, and how to request an increase, see <a
         * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
         * run in Amazon EC2</a> in the Amazon EC2 FAQ.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in
         *        the target Availability Zone, Amazon EC2 launches the largest possible number of instances above
         *        <code>MinCount</code>.</p>
         *        <p>
         *        Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         *        information about the default limits, and how to request an increase, see <a
         *        href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances
         *        can I run in Amazon EC2</a> in the Amazon EC2 FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2
         * can launch in the target Availability Zone, Amazon EC2 launches no instances.
         * </p>
         * <p>
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         * information about the default limits, and how to request an increase, see <a
         * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
         * run in Amazon EC2</a> in the Amazon EC2 General FAQ.
         * </p>
         * 
         * @param minCount
         *        The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon
         *        EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p>
         *        <p>
         *        Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         *        information about the default limits, and how to request an increase, see <a
         *        href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances
         *        can I run in Amazon EC2</a> in the Amazon EC2 General FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCount(Integer minCount);

        /**
         * <p>
         * Specifies whether detailed monitoring is enabled for the instance.
         * </p>
         * 
         * @param monitoring
         *        Specifies whether detailed monitoring is enabled for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(RunInstancesMonitoringEnabled monitoring);

        /**
         * <p>
         * Specifies whether detailed monitoring is enabled for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link RunInstancesMonitoringEnabled.Builder} avoiding
         * the need to create one manually via {@link RunInstancesMonitoringEnabled#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunInstancesMonitoringEnabled.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(RunInstancesMonitoringEnabled)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link RunInstancesMonitoringEnabled.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(RunInstancesMonitoringEnabled)
         */
        default Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return monitoring(RunInstancesMonitoringEnabled.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * 
         * @param placement
         *        The placement for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Placement.Builder} avoiding the need to create
         * one manually via {@link Placement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel
         * requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to
         * the Amazon Web Services Resource Center and search for the kernel ID.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel
         *        requirements for information about whether you need to specify a RAM disk. To find kernel
         *        requirements, go to the Amazon Web Services Resource Center and search for the kernel ID.</p>
         *        <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The IDs of the security groups. You can create a security group using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         * >CreateSecurityGroup</a>.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. You can create a security group using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         *        >CreateSecurityGroup</a>.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups. You can create a security group using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         * >CreateSecurityGroup</a>.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups. You can create a security group using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         *        >CreateSecurityGroup</a>.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use security
         * group IDs instead.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use
         *        security group IDs instead.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface.
         *        </p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use security
         * group IDs instead.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any security groups as part of the network interface.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use
         *        security group IDs instead.</p>
         *        <p>
         *        If you specify a network interface, you must specify any security groups as part of the network
         *        interface.
         *        </p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet to launch the instance into.
         * </p>
         * <p>
         * If you specify a network interface, you must specify any subnets as part of the network interface.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet to launch the instance into.</p>
         *        <p>
         *        If you specify a network interface, you must specify any subnets as part of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The user data to make available to the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running commands on your Linux
         * instance at launch</a> (Linux) and <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         * >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you,
         * and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited
         * to 16 KB.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running commands on your
         *        Linux instance at launch</a> (Linux) and <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         *        >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed
         *        for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User
         *        data is limited to 16 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify
         * a client token, a randomly generated token is used for the request to ensure idempotency.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * <p>
         * Constraints: Maximum 64 ASCII characters
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
         *        specify a client token, a randomly generated token is used for the request to ensure idempotency.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         *        </p>
         *        <p>
         *        Constraints: Maximum 64 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         * console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
         * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param disableApiTermination
         *        If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         *        console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         *        >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code>
         *        to <code>terminate</code>, you can terminate the instance by running the shutdown command from the
         *        instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an
         * EBS-optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
         *        performance. This optimization isn't available with all instance types. Additional usage charges apply
         *        when using an EBS-optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The network interfaces to associate with the instance. If you specify a network interface, you must specify
         * any security groups and subnets as part of the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces to associate with the instance. If you specify a network interface, you must
         *        specify any security groups and subnets as part of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * The network interfaces to associate with the instance. If you specify a network interface, you must specify
         * any security groups and subnets as part of the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces to associate with the instance. If you specify a network interface, you must
         *        specify any security groups and subnets as part of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * The network interfaces to associate with the instance. If you specify a network interface, you must specify
         * any security groups and subnets as part of the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <InstanceNetworkInterfaceSpecification>.Builder} avoiding the need to create one manually via {@link List
         * <InstanceNetworkInterfaceSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceNetworkInterfaceSpecification>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<InstanceNetworkInterfaceSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<InstanceNetworkInterfaceSpecification>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
         * </p>
         * <p>
         * Only one private IP address can be designated as primary. You can't specify this option if you've specified
         * the option to designate a private IP address as the primary IP address in a network interface specification.
         * You cannot specify this option if you're launching more than one instance in the request.
         * </p>
         * <p>
         * You cannot specify this option and the network interfaces option in the same request.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the
         *        subnet.</p>
         *        <p>
         *        Only one private IP address can be designated as primary. You can't specify this option if you've
         *        specified the option to designate a private IP address as the primary IP address in a network
         *        interface specification. You cannot specify this option if you're launching more than one instance in
         *        the request.
         *        </p>
         *        <p>
         *        You cannot specify this option and the network interfaces option in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your
         * Windows instance to accelerate the graphics performance of your applications. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic
         * GPUs</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param elasticGpuSpecification
         *        An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to
         *        your Windows instance to accelerate the graphics performance of your applications. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic
         *        GPUs</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification);

        /**
         * <p>
         * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your
         * Windows instance to accelerate the graphics performance of your applications. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic
         * GPUs</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param elasticGpuSpecification
         *        An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to
         *        your Windows instance to accelerate the graphics performance of your applications. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic
         *        GPUs</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecification(ElasticGpuSpecification... elasticGpuSpecification);

        /**
         * <p>
         * An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your
         * Windows instance to accelerate the graphics performance of your applications. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon EC2 Elastic
         * GPUs</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticGpuSpecification>.Builder} avoiding
         * the need to create one manually via {@link List<ElasticGpuSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticGpuSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticGpuSpecification(List<ElasticGpuSpecification>)}.
         * 
         * @param elasticGpuSpecification
         *        a consumer that will call methods on {@link List<ElasticGpuSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuSpecification(List<ElasticGpuSpecification>)
         */
        Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecification);

        /**
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         *        resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         *        workloads.</p>
         *        <p>
         *        You cannot specify accelerators from different generations in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(Collection<ElasticInferenceAccelerator> elasticInferenceAccelerators);

        /**
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         *        resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         *        workloads.</p>
         *        <p>
         *        You cannot specify accelerators from different generations in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(ElasticInferenceAccelerator... elasticInferenceAccelerators);

        /**
         * <p>
         * An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a
         * resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference
         * workloads.
         * </p>
         * <p>
         * You cannot specify accelerators from different generations in the same request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticInferenceAccelerator>.Builder}
         * avoiding the need to create one manually via {@link List<ElasticInferenceAccelerator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticInferenceAccelerator>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #elasticInferenceAccelerators(List<ElasticInferenceAccelerator>)}.
         * 
         * @param elasticInferenceAccelerators
         *        a consumer that will call methods on {@link List<ElasticInferenceAccelerator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAccelerators(List<ElasticInferenceAccelerator>)
         */
        Builder elasticInferenceAccelerators(Consumer<ElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can only tag instances and volumes on launch.
         *        The specified tags are applied to all instances or volumes that are created during launch. To tag a
         *        resource after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can only tag instances and volumes on launch.
         *        The specified tags are applied to all instances or volumes that are created during launch. To tag a
         *        resource after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The launch template to use to launch the instances. Any parameters that you specify in <a>RunInstances</a>
         * override the same parameters in the launch template. You can specify either the name or ID of a launch
         * template, but not both.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template to use to launch the instances. Any parameters that you specify in
         *        <a>RunInstances</a> override the same parameters in the launch template. You can specify either the
         *        name or ID of a launch template, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template to use to launch the instances. Any parameters that you specify in <a>RunInstances</a>
         * override the same parameters in the launch template. You can specify either the name or ID of a launch
         * template, but not both.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * <p>
         * For <a>RunInstances</a>, persistent Spot Instance requests are only supported when
         * <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.
         * </p>
         * 
         * @param instanceMarketOptions
         *        The market (purchasing) option for the instances.</p>
         *        <p>
         *        For <a>RunInstances</a>, persistent Spot Instance requests are only supported when
         *        <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * <p>
         * For <a>RunInstances</a>, persistent Spot Instance requests are only supported when
         * <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMarketOptionsRequest.Builder} avoiding
         * the need to create one manually via {@link InstanceMarketOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMarketOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceMarketOptions(InstanceMarketOptionsRequest)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link InstanceMarketOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(InstanceMarketOptionsRequest)
         */
        default Builder instanceMarketOptions(Consumer<InstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return instanceMarketOptions(InstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions).build());
        }

        /**
         * <p>
         * The credit option for CPU usage of the burstable performance instance. Valid values are <code>standard</code>
         * and <code>unlimited</code>. To change this attribute after launch, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">
         * ModifyInstanceCreditSpecification</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
         * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
         * </p>
         * 
         * @param creditSpecification
         *        The credit option for CPU usage of the burstable performance instance. Valid values are
         *        <code>standard</code> and <code>unlimited</code>. To change this attribute after launch, use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html"
         *        > ModifyInstanceCreditSpecification</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html"
         *        >Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(CreditSpecificationRequest creditSpecification);

        /**
         * <p>
         * The credit option for CPU usage of the burstable performance instance. Valid values are <code>standard</code>
         * and <code>unlimited</code>. To change this attribute after launch, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">
         * ModifyInstanceCreditSpecification</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
         * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)
         * </p>
         * This is a convenience that creates an instance of the {@link CreditSpecificationRequest.Builder} avoiding the
         * need to create one manually via {@link CreditSpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreditSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #creditSpecification(CreditSpecificationRequest)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on {@link CreditSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(CreditSpecificationRequest)
         */
        default Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return creditSpecification(CreditSpecificationRequest.builder().applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * options</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         *        options</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(CpuOptionsRequest cpuOptions);

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * options</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link CpuOptionsRequest.Builder} avoiding the need to
         * create one manually via {@link CpuOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CpuOptionsRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #cpuOptions(CpuOptionsRequest)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link CpuOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(CpuOptionsRequest)
         */
        default Builder cpuOptions(Consumer<CpuOptionsRequest.Builder> cpuOptions) {
            return cpuOptions(CpuOptionsRequest.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * Information about the Capacity Reservation targeting option. If you do not specify this parameter, the
         * instance's Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open
         * Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Information about the Capacity Reservation targeting option. If you do not specify this parameter, the
         *        instance's Capacity Reservation preference defaults to <code>open</code>, which enables it to run in
         *        any open Capacity Reservation that has matching attributes (instance type, platform, Availability
         *        Zone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option. If you do not specify this parameter, the
         * instance's Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open
         * Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * This is a convenience that creates an instance of the {@link CapacityReservationSpecification.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityReservationSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecification)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecification)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecification.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether an instance is enabled for hibernation. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a>
         *        in the <i>Amazon EC2 User Guide</i>.</p>
         *        <p>
         *        You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(HibernationOptionsRequest hibernationOptions);

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * <p>
         * You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same instance.
         * </p>
         * This is a convenience that creates an instance of the {@link HibernationOptionsRequest.Builder} avoiding the
         * need to create one manually via {@link HibernationOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link HibernationOptionsRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #hibernationOptions(HibernationOptionsRequest)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link HibernationOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(HibernationOptionsRequest)
         */
        default Builder hibernationOptions(Consumer<HibernationOptionsRequest.Builder> hibernationOptions) {
            return hibernationOptions(HibernationOptionsRequest.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LicenseConfigurationRequest... licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseConfigurationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<LicenseConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseConfigurationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #licenseSpecifications(List<LicenseConfigurationRequest>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on {@link List<LicenseConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(List<LicenseConfigurationRequest>)
         */
        Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder>... licenseSpecifications);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        metadata and user data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMetadataOptionsRequest.Builder} avoiding
         * the need to create one manually via {@link InstanceMetadataOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMetadataOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(InstanceMetadataOptionsRequest)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptionsRequest)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see
         * <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services
         * Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
         * </p>
         * <p>
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * </p>
         * 
         * @param enclaveOptions
         *        Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more
         *        information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What
         *        is Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User
         *        Guide</i>.</p>
         *        <p>
         *        You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see
         * <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services
         * Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
         * </p>
         * <p>
         * You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same instance.
         * </p>
         * This is a convenience that creates an instance of the {@link EnclaveOptionsRequest.Builder} avoiding the need
         * to create one manually via {@link EnclaveOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnclaveOptionsRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #enclaveOptions(EnclaveOptionsRequest)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link EnclaveOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(EnclaveOptionsRequest)
         */
        default Builder enclaveOptions(Consumer<EnclaveOptionsRequest.Builder> enclaveOptions) {
            return enclaveOptions(EnclaveOptionsRequest.builder().applyMutation(enclaveOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String imageId;

        private String instanceType;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String kernelId;

        private String keyName;

        private Integer maxCount;

        private Integer minCount;

        private RunInstancesMonitoringEnabled monitoring;

        private Placement placement;

        private String ramdiskId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String userData;

        private String additionalInfo;

        private String clientToken;

        private Boolean disableApiTermination;

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String instanceInitiatedShutdownBehavior;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String privateIpAddress;

        private List<ElasticGpuSpecification> elasticGpuSpecification = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateSpecification launchTemplate;

        private InstanceMarketOptionsRequest instanceMarketOptions;

        private CreditSpecificationRequest creditSpecification;

        private CpuOptionsRequest cpuOptions;

        private CapacityReservationSpecification capacityReservationSpecification;

        private HibernationOptionsRequest hibernationOptions;

        private List<LicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private InstanceMetadataOptionsRequest metadataOptions;

        private EnclaveOptionsRequest enclaveOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesRequest model) {
            super(model);
            blockDeviceMappings(model.blockDeviceMappings);
            imageId(model.imageId);
            instanceType(model.instanceType);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            kernelId(model.kernelId);
            keyName(model.keyName);
            maxCount(model.maxCount);
            minCount(model.minCount);
            monitoring(model.monitoring);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            userData(model.userData);
            additionalInfo(model.additionalInfo);
            clientToken(model.clientToken);
            disableApiTermination(model.disableApiTermination);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            networkInterfaces(model.networkInterfaces);
            privateIpAddress(model.privateIpAddress);
            elasticGpuSpecification(model.elasticGpuSpecification);
            elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            tagSpecifications(model.tagSpecifications);
            launchTemplate(model.launchTemplate);
            instanceMarketOptions(model.instanceMarketOptions);
            creditSpecification(model.creditSpecification);
            cpuOptions(model.cpuOptions);
            capacityReservationSpecification(model.capacityReservationSpecification);
            hibernationOptions(model.hibernationOptions);
            licenseSpecifications(model.licenseSpecifications);
            metadataOptions(model.metadataOptions);
            enclaveOptions(model.enclaveOptions);
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        @Transient
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        @Transient
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        @Transient
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> InstanceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        @Transient
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        @Transient
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        @Transient
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Integer getMinCount() {
            return minCount;
        }

        public final void setMinCount(Integer minCount) {
            this.minCount = minCount;
        }

        @Override
        @Transient
        public final Builder minCount(Integer minCount) {
            this.minCount = minCount;
            return this;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        @Transient
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        @Transient
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        @Transient
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        @Transient
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        @Override
        @Transient
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        @Transient
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        @Transient
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null
                    : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final List<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterfaceSpecification.Builder> result = InstanceNetworkInterfaceSpecificationListCopier
                    .copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        @Transient
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> InstanceNetworkInterfaceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<ElasticGpuSpecification.Builder> getElasticGpuSpecification() {
            List<ElasticGpuSpecification.Builder> result = ElasticGpuSpecificationsCopier
                    .copyToBuilder(this.elasticGpuSpecification);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSpecification(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copyFromBuilder(elasticGpuSpecification);
        }

        @Override
        @Transient
        public final Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copy(elasticGpuSpecification);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticGpuSpecification(ElasticGpuSpecification... elasticGpuSpecification) {
            elasticGpuSpecification(Arrays.asList(elasticGpuSpecification));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticGpuSpecification(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecification) {
            elasticGpuSpecification(Stream.of(elasticGpuSpecification)
                    .map(c -> ElasticGpuSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            List<ElasticInferenceAccelerator.Builder> result = ElasticInferenceAcceleratorsCopier
                    .copyToBuilder(this.elasticInferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAccelerators(
                Collection<ElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = ElasticInferenceAcceleratorsCopier.copyFromBuilder(elasticInferenceAccelerators);
        }

        @Override
        @Transient
        public final Builder elasticInferenceAccelerators(Collection<ElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = ElasticInferenceAcceleratorsCopier.copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(ElasticInferenceAccelerator... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                Consumer<ElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators)
                    .map(c -> ElasticInferenceAccelerator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final InstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(InstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceMarketOptions(InstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final CpuOptionsRequest.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cpuOptions(CpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final HibernationOptionsRequest.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder hibernationOptions(HibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final List<LicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LicenseConfigurationRequest.Builder> result = LicenseSpecificationListRequestCopier
                    .copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        @Transient
        public final Builder licenseSpecifications(Collection<LicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseSpecifications(LicenseConfigurationRequest... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LicenseConfigurationRequest.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LicenseConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder metadataOptions(InstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final EnclaveOptionsRequest.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder enclaveOptions(EnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunInstancesRequest build() {
            return new RunInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
