/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastSnapshotRestoresResponse extends Ec2Response implements
        ToCopyableBuilder<EnableFastSnapshotRestoresResponse.Builder, EnableFastSnapshotRestoresResponse> {
    private static final SdkField<List<EnableFastSnapshotRestoreSuccessItem>> SUCCESSFUL_FIELD = SdkField
            .<List<EnableFastSnapshotRestoreSuccessItem>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(EnableFastSnapshotRestoresResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful")
                    .unmarshallLocationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<EnableFastSnapshotRestoreSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnableFastSnapshotRestoreSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<EnableFastSnapshotRestoreErrorItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<EnableFastSnapshotRestoreErrorItem>> builder(MarshallingType.LIST)
            .memberName("Unsuccessful")
            .getter(getter(EnableFastSnapshotRestoresResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<EnableFastSnapshotRestoreErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnableFastSnapshotRestoreErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD,
            UNSUCCESSFUL_FIELD));

    private final List<EnableFastSnapshotRestoreSuccessItem> successful;

    private final List<EnableFastSnapshotRestoreErrorItem> unsuccessful;

    private EnableFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores were successfully enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores were successfully enabled.
     */
    public final List<EnableFastSnapshotRestoreSuccessItem> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unsuccessful property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores could not be enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessful} method.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores could not be enabled.
     */
    public final List<EnableFastSnapshotRestoreErrorItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessful() ? unsuccessful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresResponse)) {
            return false;
        }
        EnableFastSnapshotRestoresResponse other = (EnableFastSnapshotRestoresResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFastSnapshotRestoresResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Unsuccessful", hasUnsuccessful() ? unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, EnableFastSnapshotRestoresResponse> {
        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully enabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<EnableFastSnapshotRestoreSuccessItem> successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully enabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(EnableFastSnapshotRestoreSuccessItem... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <EnableFastSnapshotRestoreSuccessItem>.Builder} avoiding the need to create one manually via {@link List
         * <EnableFastSnapshotRestoreSuccessItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnableFastSnapshotRestoreSuccessItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successful(List<EnableFastSnapshotRestoreSuccessItem>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<EnableFastSnapshotRestoreSuccessItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<EnableFastSnapshotRestoreSuccessItem>)
         */
        Builder successful(Consumer<EnableFastSnapshotRestoreSuccessItem.Builder>... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be enabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<EnableFastSnapshotRestoreErrorItem> unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be enabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(EnableFastSnapshotRestoreErrorItem... unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <EnableFastSnapshotRestoreErrorItem>.Builder} avoiding the need to create one manually via {@link List
         * <EnableFastSnapshotRestoreErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnableFastSnapshotRestoreErrorItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unsuccessful(List<EnableFastSnapshotRestoreErrorItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on {@link List<EnableFastSnapshotRestoreErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(List<EnableFastSnapshotRestoreErrorItem>)
         */
        Builder unsuccessful(Consumer<EnableFastSnapshotRestoreErrorItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<EnableFastSnapshotRestoreSuccessItem> successful = DefaultSdkAutoConstructList.getInstance();

        private List<EnableFastSnapshotRestoreErrorItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoresResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final List<EnableFastSnapshotRestoreSuccessItem.Builder> getSuccessful() {
            List<EnableFastSnapshotRestoreSuccessItem.Builder> result = EnableFastSnapshotRestoreSuccessSetCopier
                    .copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<EnableFastSnapshotRestoreSuccessItem.BuilderImpl> successful) {
            this.successful = EnableFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(successful);
        }

        @Override
        @Transient
        public final Builder successful(Collection<EnableFastSnapshotRestoreSuccessItem> successful) {
            this.successful = EnableFastSnapshotRestoreSuccessSetCopier.copy(successful);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successful(EnableFastSnapshotRestoreSuccessItem... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder successful(Consumer<EnableFastSnapshotRestoreSuccessItem.Builder>... successful) {
            successful(Stream.of(successful).map(c -> EnableFastSnapshotRestoreSuccessItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EnableFastSnapshotRestoreErrorItem.Builder> getUnsuccessful() {
            List<EnableFastSnapshotRestoreErrorItem.Builder> result = EnableFastSnapshotRestoreErrorSetCopier
                    .copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<EnableFastSnapshotRestoreErrorItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = EnableFastSnapshotRestoreErrorSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        @Transient
        public final Builder unsuccessful(Collection<EnableFastSnapshotRestoreErrorItem> unsuccessful) {
            this.unsuccessful = EnableFastSnapshotRestoreErrorSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unsuccessful(EnableFastSnapshotRestoreErrorItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unsuccessful(Consumer<EnableFastSnapshotRestoreErrorItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> EnableFastSnapshotRestoreErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnableFastSnapshotRestoresResponse build() {
            return new EnableFastSnapshotRestoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
