/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBundleTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeBundleTasksResponse.Builder, DescribeBundleTasksResponse> {
    private static final SdkField<List<BundleTask>> BUNDLE_TASKS_FIELD = SdkField
            .<List<BundleTask>> builder(MarshallingType.LIST)
            .memberName("BundleTasks")
            .getter(getter(DescribeBundleTasksResponse::bundleTasks))
            .setter(setter(Builder::bundleTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleInstanceTasksSet")
                    .unmarshallLocationName("bundleInstanceTasksSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BundleTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(BundleTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_TASKS_FIELD));

    private final List<BundleTask> bundleTasks;

    private DescribeBundleTasksResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTasks = builder.bundleTasks;
    }

    /**
     * For responses, this returns true if the service returned a value for the BundleTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBundleTasks() {
        return bundleTasks != null && !(bundleTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the bundle tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBundleTasks} method.
     * </p>
     * 
     * @return Information about the bundle tasks.
     */
    public final List<BundleTask> bundleTasks() {
        return bundleTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundleTasks() ? bundleTasks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksResponse)) {
            return false;
        }
        DescribeBundleTasksResponse other = (DescribeBundleTasksResponse) obj;
        return hasBundleTasks() == other.hasBundleTasks() && Objects.equals(bundleTasks(), other.bundleTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBundleTasksResponse").add("BundleTasks", hasBundleTasks() ? bundleTasks() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleTasks":
            return Optional.ofNullable(clazz.cast(bundleTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleTasksResponse, T> g) {
        return obj -> g.apply((DescribeBundleTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBundleTasksResponse> {
        /**
         * <p>
         * Information about the bundle tasks.
         * </p>
         * 
         * @param bundleTasks
         *        Information about the bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTasks(Collection<BundleTask> bundleTasks);

        /**
         * <p>
         * Information about the bundle tasks.
         * </p>
         * 
         * @param bundleTasks
         *        Information about the bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTasks(BundleTask... bundleTasks);

        /**
         * <p>
         * Information about the bundle tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BundleTask>.Builder} avoiding the need to
         * create one manually via {@link List<BundleTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BundleTask>.Builder#build()} is called immediately and its
         * result is passed to {@link #bundleTasks(List<BundleTask>)}.
         * 
         * @param bundleTasks
         *        a consumer that will call methods on {@link List<BundleTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleTasks(List<BundleTask>)
         */
        Builder bundleTasks(Consumer<BundleTask.Builder>... bundleTasks);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<BundleTask> bundleTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksResponse model) {
            super(model);
            bundleTasks(model.bundleTasks);
        }

        public final List<BundleTask.Builder> getBundleTasks() {
            List<BundleTask.Builder> result = BundleTaskListCopier.copyToBuilder(this.bundleTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundleTasks(Collection<BundleTask.BuilderImpl> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copyFromBuilder(bundleTasks);
        }

        @Override
        @Transient
        public final Builder bundleTasks(Collection<BundleTask> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copy(bundleTasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bundleTasks(BundleTask... bundleTasks) {
            bundleTasks(Arrays.asList(bundleTasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bundleTasks(Consumer<BundleTask.Builder>... bundleTasks) {
            bundleTasks(Stream.of(bundleTasks).map(c -> BundleTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeBundleTasksResponse build() {
            return new DescribeBundleTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
