/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointServiceConfigurationRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcEndpointServiceConfigurationRequest.Builder, CreateVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired")
                    .unmarshallLocationName("AcceptanceRequired").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsName")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("PrivateDnsName").build()).build();

    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkLoadBalancerArns")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::networkLoadBalancerArns))
            .setter(setter(Builder::networkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn")
                    .unmarshallLocationName("NetworkLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GatewayLoadBalancerArns")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::gatewayLoadBalancerArns))
            .setter(setter(Builder::gatewayLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArn")
                    .unmarshallLocationName("GatewayLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVpcEndpointServiceConfigurationRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_REQUIRED_FIELD,
            PRIVATE_DNS_NAME_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, GATEWAY_LOAD_BALANCER_ARNS_FIELD, CLIENT_TOKEN_FIELD,
            TAG_SPECIFICATIONS_FIELD));

    private final Boolean acceptanceRequired;

    private final String privateDnsName;

    private final List<String> networkLoadBalancerArns;

    private final List<String> gatewayLoadBalancerArns;

    private final String clientToken;

    private final List<TagSpecification> tagSpecifications;

    private CreateVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.acceptanceRequired = builder.acceptanceRequired;
        this.privateDnsName = builder.privateDnsName;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To
     * accept a request, use <a>AcceptVpcEndpointConnections</a>.
     * </p>
     * 
     * @return Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
     *         To accept a request, use <a>AcceptVpcEndpointConnections</a>.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * <p>
     * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
     * </p>
     * 
     * @return (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
     */
    public final String privateDnsName() {
        return privateDnsName;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkLoadBalancerArns() {
        return networkLoadBalancerArns != null && !(networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
     */
    public final List<String> networkLoadBalancerArns() {
        return networkLoadBalancerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayLoadBalancerArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns != null && !(gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayLoadBalancerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
     */
    public final List<String> gatewayLoadBalancerArns() {
        return gatewayLoadBalancerArns;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to Ensure Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to associate with the service.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationRequest other = (CreateVpcEndpointServiceConfigurationRequest) obj;
        return Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns()
                && Objects.equals(networkLoadBalancerArns(), other.networkLoadBalancerArns())
                && hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns()
                && Objects.equals(gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns())
                && Objects.equals(clientToken(), other.clientToken()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcEndpointServiceConfigurationRequest").add("AcceptanceRequired", acceptanceRequired())
                .add("PrivateDnsName", privateDnsName())
                .add("NetworkLoadBalancerArns", hasNetworkLoadBalancerArns() ? networkLoadBalancerArns() : null)
                .add("GatewayLoadBalancerArns", hasGatewayLoadBalancerArns() ? gatewayLoadBalancerArns() : null)
                .add("ClientToken", clientToken()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "NetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(networkLoadBalancerArns()));
        case "GatewayLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(gatewayLoadBalancerArns()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointServiceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationRequest> {
        /**
         * <p>
         * Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To
         * accept a request, use <a>AcceptVpcEndpointConnections</a>.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether requests from service consumers to create an endpoint to your service must be
         *        accepted. To accept a request, use <a>AcceptVpcEndpointConnections</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
         * </p>
         * 
         * @param privateDnsName
         *        (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
         * </p>
         * 
         * @param networkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArns(String... networkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         * </p>
         * 
         * @param gatewayLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to associate with the service.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to associate with the service.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to associate with the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean acceptanceRequired;

        private String privateDnsName;

        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationRequest model) {
            super(model);
            acceptanceRequired(model.acceptanceRequired);
            privateDnsName(model.privateDnsName);
            networkLoadBalancerArns(model.networkLoadBalancerArns);
            gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            clientToken(model.clientToken);
            tagSpecifications(model.tagSpecifications);
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        @Transient
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return networkLoadBalancerArns;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String... networkLoadBalancerArns) {
            networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return gatewayLoadBalancerArns;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = ValueStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String... gatewayLoadBalancerArns) {
            gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationRequest build() {
            return new CreateVpcEndpointServiceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
